@extends("landingpage::themes.{$activeTheme}.layouts.app")

@section('meta_title', $pageTitle ?? 'Company Projects')
@section('meta_description', $metaDescription ?? 'Discover projects by companies in our network.')

@section('content')
<div class="bg-gray-50 dark:bg-gray-900 py-12 md:py-20">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        <header class="mb-12 text-center">
            <h1 class="text-4xl font-bold text-gray-800 dark:text-white">{{ $pageTitle ?? 'Company Projects' }}</h1>
            @if(isset($metaDescription))
            <p class="mt-4 text-lg text-gray-600 dark:text-gray-300">{{ $metaDescription }}</p>
            @endif
        </header>

        {{-- Optional: Add filters for status, company, etc. here later --}}
        {{-- Example:
        <div class="mb-8 p-4 bg-white dark:bg-gray-800 rounded-lg shadow">
            <form method="GET" action="{{ route('landingpage.company-projects.index') }}">
                <select name="status" onchange="this.form.submit()" class="p-2 border rounded-md dark:bg-gray-700 dark:border-gray-600 dark:text-white">
                    <option value="all" {{ request('status') == 'all' ? 'selected' : '' }}>All Statuses</option>
                    <option value="completed" {{ request('status') == 'completed' ? 'selected' : '' }}>Completed</option>
                    <option value="in_progress" {{ request('status') == 'in_progress' ? 'selected' : '' }}>In Progress</option>
                    <option value="planning" {{ request('status') == 'planning' ? 'selected' : '' }}>Planning</option>
                </select>
            </form>
        </div>
        --}}

        @if($projects->isNotEmpty())
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8 mb-12">
                @foreach($projects as $project)
                    <div class="bg-white dark:bg-gray-800 rounded-lg shadow-lg hover:shadow-xl transition-shadow duration-300 flex flex-col p-6">
                        <div class="flex-grow">
                            <h2 class="text-2xl font-semibold text-[var(--clr-accent)] mb-2">
                                <a href="{{-- route('module.company-projects.show', $project->slug) --}}#" class="hover:underline">
                                    {{ $project->name }}
                                </a>
                            </h2>
                            @if($project->company)
                                <p class="text-sm text-gray-500 dark:text-gray-400 mb-1">Implemented by: <a href="{{-- route('module.companies.show', $project->company->slug) --}}#" class="hover:underline">{{ $project->company->name }}</a></p>
                            @endif
                            <p class="text-sm text-gray-500 dark:text-gray-400 mb-3">Status: <span class="font-semibold">{{ Str::title(str_replace('_', ' ', $project->status)) }}</span></p>
                            <p class="text-gray-600 dark:text-gray-300 text-sm mb-4">
                                {{ Str::limit($project->description ?? 'No description provided.', 150) }}
                            </p>
                        </div>
                        <div class="mt-auto">
                            <a href="{{-- route('module.company-projects.show', $project->slug) --}}#" class="inline-block mt-4 text-purple-500 hover:text-purple-700 dark:hover:text-purple-300 font-semibold text-sm">
                                Learn More &rarr;
                            </a>
                        </div>
                    </div>
                @endforeach
            </div>
            <div class="mt-8">
                {{ $projects->appends(request()->query())->links() }} {{-- Appends query string to pagination --}}
            </div>
        @else
            <p class="text-center text-gray-600 dark:text-gray-400 text-xl">No company projects found matching your criteria. Please check back later.</p>
        @endif
    </div>
</div>
@endsection