@extends('layouts.app') {{-- Or your main user-facing layout --}}

@section('title', 'Deploy Website: ' . ($website->name ?: 'Untitled Website'))
@section('header_title', 'Deploy Website')

@section('content')
<div class="container mx-auto px-4 py-8">
    <div class="max-w-2xl mx-auto bg-white dark:bg-gray-800 shadow-xl rounded-lg p-6 md:p-8">
        <h1 class="text-2xl font-bold text-gray-800 dark:text-white mb-2">Deploy: {{ $website->name ?: 'Untitled Website' }}</h1>
        <p class="text-gray-600 dark:text-gray-300 mb-6">Enter your hosting details. Ensure the website ZIP is generated and ready.</p>

        @include('webpilotai::user.partials._validation_errors')
        @include('webpilotai::user.partials._session_messages') {{-- Or your main app's session messages partial --}}

        <form action="{{ route('frontend.webpilotai.websites.deploy.submit', $website->id) }}" method="POST" class="space-y-6">
            @csrf

            <div>
                <label for="deployment_type" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Deployment Type</label>
                <select name="deployment_type" id="deployment_type" required class="mt-1 block w-full py-2 px-3 border border-gray-300 dark:border-gray-600 bg-white dark:bg-gray-700 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500 sm:text-sm dark:text-gray-200">
                    <option value="ftp" {{ (old('deployment_type', $lastDeploymentDetails['type'] ?? 'ftp') == 'ftp') ? 'selected' : '' }}>FTP</option>
                    <option value="sftp" {{ (old('deployment_type', $lastDeploymentDetails['type'] ?? '') == 'sftp') ? 'selected' : '' }}>SFTP (Recommended)</option>
                    <option value="cpanel" {{ (old('deployment_type', $lastDeploymentDetails['type'] ?? '') == 'cpanel') ? 'selected' : '' }}>cPanel API</option>
                </select>
                @error('deployment_type') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
            </div>

            <div>
                <label for="host" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Host / Server Address</label>
                <input type="text" id="host" name="host" value="{{ old('host', $lastDeploymentDetails['host'] ?? '') }}" required placeholder="e.g., ftp.yourdomain.com or your_server_ip"
                       class="mt-1 block w-full py-2 px-3 border border-gray-300 dark:border-gray-600 bg-white dark:bg-gray-700 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500 sm:text-sm dark:text-gray-200">
                @error('host') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
            </div>

            <div>
                <label for="username" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Username</label>
                <input type="text" id="username" name="username" value="{{ old('username', $lastDeploymentDetails['username'] ?? '') }}" required placeholder="e.g., user123"
                       class="mt-1 block w-full py-2 px-3 border border-gray-300 dark:border-gray-600 bg-white dark:bg-gray-700 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500 sm:text-sm dark:text-gray-200">
                @error('username') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
            </div>

            <div>
                <label for="password" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Password</label>
                <input type="password" id="password" name="password" required autocomplete="new-password"
                       class="mt-1 block w-full py-2 px-3 border border-gray-300 dark:border-gray-600 bg-white dark:bg-gray-700 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500 sm:text-sm dark:text-gray-200">
                @error('password') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
            </div>

            <div>
                <label for="port" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Port (Optional)</label>
                <input type="number" id="port" name="port" value="{{ old('port', $lastDeploymentDetails['port'] ?? '') }}" placeholder="e.g., 21 for FTP, 22 for SFTP"
                       class="mt-1 block w-full py-2 px-3 border border-gray-300 dark:border-gray-600 bg-white dark:bg-gray-700 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500 sm:text-sm dark:text-gray-200">
                <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">Leave blank for default (FTP: 21, SFTP: 22, cPanel: 2083).</p>
                @error('port') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
            </div>

            <div>
                <label for="remote_path" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Remote Path (Optional)</label>
                <input type="text" id="remote_path" name="remote_path" value="{{ old('remote_path', $lastDeploymentDetails['remote_path'] ?? '') }}" placeholder="e.g., public_html, httpdocs, www, / (for root)"
                       class="mt-1 block w-full py-2 px-3 border border-gray-300 dark:border-gray-600 bg-white dark:bg-gray-700 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500 sm:text-sm dark:text-gray-200">
                <p class="mt-1 text-xs text-gray-500 dark:text-gray-400" id="remote_path_help">The directory on your server where website files should be uploaded. Common paths: <code class="text-xs bg-gray-200 dark:bg-gray-600 px-1 rounded">public_html</code>, <code class="text-xs bg-gray-200 dark:bg-gray-600 px-1 rounded">httpdocs</code>, <code class="text-xs bg-gray-200 dark:bg-gray-600 px-1 rounded">www</code>. Use <code class="text-xs bg-gray-200 dark:bg-gray-600 px-1 rounded">/</code> for the root directory if unsure for FTP/SFTP.</p>
                @error('remote_path') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
            </div>

            {{-- cPanel specific fields - initially hidden, shown by JS if cPanel is selected --}}
            <div id="cpanel_fields" class="p-4 border border-dashed border-blue-300 dark:border-blue-700 rounded-md bg-blue-50 dark:bg-blue-900/30 {{ old('deployment_type', $lastDeploymentDetails['type'] ?? 'ftp') == 'cpanel' ? '' : 'hidden' }}">
                <h4 class="text-md font-semibold text-blue-700 dark:text-blue-300 mb-3">cPanel Specific Settings</h4>
                <div>
                    <label for="cpanel_domain" class="block text-sm font-medium text-gray-700 dark:text-gray-300">cPanel Domain</label>
                    <input type="text" id="cpanel_domain" name="cpanel_domain" value="{{ old('cpanel_domain', $lastDeploymentDetails['cpanel_domain'] ?? '') }}" placeholder="e.g., yourdomain.com"
                           class="mt-1 block w-full py-2 px-3 border border-gray-300 dark:border-gray-600 bg-white dark:bg-gray-700 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500 sm:text-sm dark:text-gray-200">
                    <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">The primary domain of your cPanel account, or the specific domain if deploying to an addon domain's root. The 'Host / Server Address' above should be your cPanel server's hostname (e.g., server.hosting.com).</p>
                    @error('cpanel_domain') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
                </div>
            </div>

            <div class="flex justify-end space-x-3 pt-5 border-t border-gray-200 dark:border-gray-700">
                <a href="{{ route('frontend.webpilotai.websites.show', $website->id) }}" class="bg-gray-200 hover:bg-gray-300 text-gray-700 font-bold py-2 px-4 rounded-lg transition duration-150 ease-in-out dark:bg-gray-600 dark:text-gray-200 dark:hover:bg-gray-500">
                    Cancel
                </a>
                <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded-lg shadow-md transition duration-150 ease-in-out">
                    <i class="fas fa-cloud-upload-alt mr-2"></i> Start Deployment
                </button>
            </div>
        </form>
    </div>
</div>
@endsection

@push('scripts')
<script>
        document.addEventListener('DOMContentLoaded', function () {
            const deploymentTypeSelect = document.getElementById('deployment_type');
            const cpanelFieldsDiv = document.getElementById('cpanel_fields');
            const cpanelDomainInput = document.getElementById('cpanel_domain');
            const remotePathInput = document.getElementById('remote_path');
            const remotePathHelp = document.getElementById('remote_path_help');

            function toggleCpanelFields() {
                const isCpanel = deploymentTypeSelect.value === 'cpanel';
                cpanelFieldsDiv.classList.toggle('hidden', !isCpanel);
                cpanelDomainInput.required = isCpanel; // Make cpanel_domain required only if cPanel is selected

                // Update remote_path placeholder and help text based on type
                if (isCpanel) {
                    remotePathInput.placeholder = 'e.g., public_html or public_html/addon_domain_folder';
                    remotePathHelp.innerHTML = "For cPanel, this is usually <code class='text-xs bg-gray-200 dark:bg-gray-600 px-1 rounded'>public_html</code> for the main domain, or a subfolder within <code class='text-xs bg-gray-200 dark:bg-gray-600 px-1 rounded'>public_html</code> for addon domains (e.g., <code class='text-xs bg-gray-200 dark:bg-gray-600 px-1 rounded'>public_html/myaddondomain.com</code>).";
                    if (remotePathInput.value === '' || remotePathInput.value === '/' || remotePathInput.value === 'httpdocs' || remotePathInput.value === 'www') {
                        remotePathInput.value = '{{ config('webpilotai.default_deployment_path_cpanel', 'public_html') }}'; // Set default for cPanel if current value is a common FTP/SFTP root
                    }
                } else if (deploymentTypeSelect.value === 'ftp' || deploymentTypeSelect.value === 'sftp') {
                    remotePathInput.placeholder = 'e.g., /httpdocs, /www, /public_html, or / for root';
                    remotePathHelp.innerHTML = "For FTP/SFTP, common paths are <code class='text-xs bg-gray-200 dark:bg-gray-600 px-1 rounded'>/httpdocs</code>, <code class='text-xs bg-gray-200 dark:bg-gray-600 px-1 rounded'>/www</code>, <code class='text-xs bg-gray-200 dark:bg-gray-600 px-1 rounded'>/public_html</code>. Use <code class='text-xs bg-gray-200 dark:bg-gray-600 px-1 rounded'>/</code> if you want to upload to the root directory you log into. If deploying to a subdirectory, specify it like <code class='text-xs bg-gray-200 dark:bg-gray-600 px-1 rounded'>/public_html/my-site</code>.";
                    if (remotePathInput.value === '{{ config('webpilotai.default_deployment_path_cpanel', 'public_html') }}') {
                         // remotePathInput.value = '/'; // Optionally clear cPanel default if switching away
                    }
                }
            }

            deploymentTypeSelect.addEventListener('change', toggleCpanelFields);
            toggleCpanelFields(); // Initial check
        });
</script>
@endpush

@push('styles')
{{-- Font Awesome for icons if not already globally included --}}
{{-- <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css" /> --}}
@endpush
