@extends('layouts.app') {{-- Or your main user-facing layout --}}

@section('title', 'AI Template Library')
@section('header_title', 'AI Template Library') {{-- Or your layout's equivalent section for page titles --}}

@section('content')
<div class="container mx-auto px-4 py-8">
    <div class="mb-8 text-center">
        <h1 class="text-4xl font-bold text-gray-800 dark:text-white">Explore AI Templates</h1>
        <p class="mt-2 text-lg text-gray-600 dark:text-gray-300">
            Discover professionally designed templates to kickstart your website generation.
        </p>
    </div>

    @include('webpilotai::user.partials._session_messages') {{-- Assuming you have this partial --}}

    @if($aiTemplates->isEmpty())
        <div class="text-center py-12 px-6 bg-white dark:bg-gray-800 shadow-xl rounded-lg">
            <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor" aria-hidden="true">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 10h16M4 14h16M4 18h16"/>
            </svg>
            <h3 class="mt-2 text-lg font-medium text-gray-900 dark:text-white">No Templates Available</h3>
            <p class="mt-1 text-sm text-gray-500 dark:text-gray-400">
                We're constantly adding new templates. Please check back soon!
            </p>
        </div>
    @else
        <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-6">
            @foreach ($aiTemplates as $template)
                <div class="bg-white dark:bg-gray-800 shadow-lg rounded-lg overflow-hidden transform transition duration-300 hover:scale-105">
                    @if($template->preview_image_path)
                        <img src="{{ asset('storage/' . $template->preview_image_path) }}" alt="{{ $template->name }} Preview" class="w-full h-48 object-cover">
                    @else
                        <div class="w-full h-48 bg-gray-200 dark:bg-gray-700 flex items-center justify-center">
                            <span class="text-gray-500 dark:text-gray-400">No Preview</span>
                        </div>
                    @endif
                    <div class="p-4">
                        <h3 class="text-lg font-semibold text-gray-800 dark:text-white mb-1">{{ $template->name }}</h3>
                        @if($template->is_premium)
                            <span class="inline-block bg-yellow-400 text-yellow-800 text-xs font-semibold px-2 py-0.5 rounded-full mb-2">Premium</span>
                        @endif
                        <p class="text-sm text-gray-600 dark:text-gray-400 mb-3 h-16 overflow-hidden">
                            {{ Str::limit($template->description, 100) }}
                        </p>
                        {{-- You might want a button to select/use the template, or view details --}}
                        {{-- <a href="#" class="text-blue-500 hover:text-blue-600 dark:text-blue-400 dark:hover:text-blue-300 text-sm font-medium">
                            Use Template &rarr;
                        </a> --}}
                    </div>
                </div>
            @endforeach
        </div>

        @if ($aiTemplates->hasPages())
            <div class="mt-8">
                {{ $aiTemplates->links() }} {{-- Ensure Tailwind pagination views are configured --}}
            </div>
        @endif
    @endif
</div>
@endsection