@component('mail::message')
# Deployment Successful!

Hello {{ $website->user->name ?? 'User' }},

Your AI website, **"{{ $website->name ?: 'Untitled Website' }}"**, has been successfully deployed!

**Deployment Details:**
- **Type:** {{ strtoupper($website->deployment_details['type'] ?? 'N/A') }}
- **Host:** {{ $website->deployment_details['host'] ?? 'N/A' }}
@if(isset($website->deployment_details['remote_path']))
- **Remote Path:** {{ $website->deployment_details['remote_path'] }}
@endif
@if(isset($website->deployment_details['cpanel_domain']) && $website->deployment_details['type'] === 'cpanel')
- **cPanel Domain:** {{ $website->deployment_details['cpanel_domain'] }}
@endif

You can view the status and further details from your dashboard.

@component('mail::button', ['url' => route('frontend.webpilotai.websites.show', $website->id)])
View Website Details
@endcomponent

Thanks,<br>
{{ config('app.name') }}
@endcomponent