@extends('layouts.admin') {{-- Or your main user-facing layout --}}

@section('title', 'My AI Websites')
@section('header_title', 'My AI Websites') {{-- Or your layout's equivalent section for page titles --}}

@section('content')
<div class="container mx-auto px-4 py-8">
    <div class="flex justify-between items-center mb-6">
        <h1 class="text-3xl font-bold text-gray-800 dark:text-white">My AI Websites</h1>
        <a href="{{ route('admin.webpilotai.user-sites.create') }}" class="bg-blue-500 hover:bg-blue-600 text-white font-bold py-2 px-4 rounded-lg shadow-md transition duration-150 ease-in-out">
            <i class="fas fa-plus mr-2"></i> Create New AI Website
        </a>
    </div>

    @include('webpilotai::admin.partials._session_messages') {{-- Assuming partials are in user/partials --}}

    <div class="bg-white dark:bg-gray-800 shadow-xl rounded-lg overflow-hidden">
        @if($websites->isEmpty())
            <div class="text-center py-12 px-6">
                <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor" aria-hidden="true">
                    <path vector-effect="non-scaling-stroke" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 13h6m-3-3v6m-9 1V7a2 2 0 012-2h6l2 2h6a2 2 0 012 2v8a2 2 0 01-2 2H5a2 2 0 01-2-2z" />
                </svg>
                <h3 class="mt-2 text-lg font-medium text-gray-900 dark:text-white">No websites yet</h3>
                <p class="mt-1 text-sm text-gray-500 dark:text-gray-400">Get started by creating your first AI-powered website.</p>
                <div class="mt-6">
                    <a href="{{ route('admin.webpilotai.user-sites.create') }}" class="inline-flex items-center px-4 py-2 border border-transparent shadow-sm text-sm font-medium rounded-md text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                        <i class="fas fa-plus -ml-1 mr-2 h-5 w-5"></i>
                        Create New Website
                    </a>
                </div>
            </div>
        @else
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
                    <thead class="bg-gray-50 dark:bg-gray-700">
                        <tr>
                            <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Name</th>
                            <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Status</th>
                            <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">AI Model</th>
                            <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Last Generated</th>
                            <th scope="col" class="px-6 py-3 text-right text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
                        @foreach ($websites as $website)
                        <tr>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="text-sm font-semibold text-gray-900 dark:text-white">{{ $website->name ?: 'Untitled Website' }}</div>
                                <div class="text-xs text-gray-500 dark:text-gray-400">ID: {{ $website->id }}</div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full
                                    @if($website->status === \Modules\WebPilotAI\Models\Website::STATUS_COMPLETED) bg-green-100 text-green-800 dark:bg-green-700 dark:text-green-100
                                    @elseif(in_array($website->status, [\Modules\WebPilotAI\Models\Website::STATUS_PENDING_GENERATION, \Modules\WebPilotAI\Models\Website::STATUS_GENERATING, \Modules\WebPilotAI\Models\Website::STATUS_PENDING_REGENERATION])) bg-yellow-100 text-yellow-800 dark:bg-yellow-700 dark:text-yellow-100
                                    @elseif($website->status === \Modules\WebPilotAI\Models\Website::STATUS_FAILED) bg-red-100 text-red-800 dark:bg-red-700 dark:text-red-100
                                    @else bg-gray-100 text-gray-800 dark:bg-gray-600 dark:text-gray-200 @endif">
                                    {{ Str::title(str_replace('_', ' ', $website->status)) }}
                                </span>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-400">
                                {{ $website->aiModel->name ?? 'N/A' }}
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-400">
                                {{ $website->last_generated_at ? $website->last_generated_at->format('M d, Y H:i') : 'Never' }}
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium">
                                <a href="{{ route('admin.webpilotai.user-sites.show', $website->id) }}" class="text-blue-600 hover:text-blue-800 dark:text-blue-400 dark:hover:text-blue-300 mr-3 transition duration-150 ease-in-out" title="View">
                                    <i class="fas fa-eye"></i> <span class="sr-only">View</span>
                                </a>
                                <a href="{{ route('admin.webpilotai.user-sites.edit', $website->id) }}" class="text-indigo-600 hover:text-indigo-800 dark:text-indigo-400 dark:hover:text-indigo-300 mr-3 transition duration-150 ease-in-out" title="Edit">
                                    <i class="fas fa-edit"></i> <span class="sr-only">Edit</span>
                                </a>
                                @if($website->status === \Modules\WebPilotAI\Models\Website::STATUS_COMPLETED && $website->generated_content_path)
                                    <a href="{{ asset($website->generated_content_path) }}" download class="text-green-600 hover:text-green-800 dark:text-green-400 dark:hover:text-green-300 mr-3 transition duration-150 ease-in-out" title="Download ZIP">
                                        <i class="fas fa-download"></i> <span class="sr-only">Download</span>
                                    </a>
                                @endif
                                @if($website->status === \Modules\WebPilotAI\Models\Website::STATUS_FAILED)
                                <form action="{{ route('admin.webpilotai.user-sites.regenerate', $website->id) }}" method="POST" class="inline-block mr-2" onsubmit="return confirm('Are you sure you want to retry generating this website?');">
                                    @csrf
                                    <button type="submit" class="text-orange-500 hover:text-orange-700 dark:text-orange-400 dark:hover:text-orange-300 transition duration-150 ease-in-out" title="Retry Generation">
                                        <i class="fas fa-sync-alt"></i> <span class="sr-only">Retry Generation</span>
                                    </button>
                                </form>
                                @endif
                                <form action="{{ route('admin.webpilotai.user-sites.destroy', $website->id) }}" method="POST" class="inline-block" onsubmit="return confirm('Are you sure you want to delete this website? This action cannot be undone.');">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="text-red-600 hover:text-red-800 dark:text-red-400 dark:hover:text-red-300 transition duration-150 ease-in-out" title="Delete">
                                        <i class="fas fa-trash-alt"></i> <span class="sr-only">Delete</span>
                                    </button>
                                </form>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

            @if ($websites->hasPages())
                <div class="bg-white dark:bg-gray-800 px-4 py-3 border-t border-gray-200 dark:border-gray-700 sm:px-6">
                    {{ $websites->links() }} {{-- Ensure Tailwind pagination views are configured --}}
                </div>
            @endif
        @endif
    </div>
</div>
@endsection
