@extends('layouts.admin') {{-- Or your main admin layout if different, e.g., layouts.app if that's your admin base --}}

@section('title', 'WebPilotAI Dashboard')
@section('header_title', 'WebPilotAI Dashboard')

@section('content')
<div class="p-6">
    <p class="mb-6 text-gray-700 dark:text-gray-300">Overview of the WebPilotAI module activity.</p>

    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-6 mb-6">
        {{-- Stat Card: AI Models --}}
        <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-lg rounded-lg">
            <div class="p-5">
                <div class="flex items-center">
                    <div class="flex-shrink-0 bg-blue-500 dark:bg-blue-700 rounded-md p-3">
                        {{-- Heroicon: cpu-chip --}}
                        <svg class="h-6 w-6 text-white" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M8.25 3v1.5M4.5 8.25H3m18 0h-1.5M4.5 12H3m18 0h-1.5m-15 3.75H3m18 0h-1.5M8.25 19.5V21M12 3v1.5m0 15V21m3.75-18v1.5m0 15V21m-9-7.5h10.5a2.25 2.25 0 0 0 2.25-2.25V8.25a2.25 2.25 0 0 0-2.25-2.25H6.75A2.25 2.25 0 0 0 4.5 8.25v3.5A2.25 2.25 0 0 0 6.75 14.25h10.5" />
                        </svg>
                    </div>
                    <div class="ml-5 w-0 flex-1">
                        <dl>
                            <dt class="text-sm font-medium text-gray-500 dark:text-gray-400 truncate">AI Models</dt>
                            <dd class="text-lg font-semibold text-gray-900 dark:text-white">Total: {{ $totalAIModels ?? 0 }}</dd>
                            <dd class="text-sm font-medium text-green-500 dark:text-green-400">Active: {{ $activeAIModels ?? 0 }}</dd>
                        </dl>
                    </div>
                </div>
            </div>
            <div class="bg-gray-50 dark:bg-gray-700 px-5 py-3">
                <div class="text-sm">
                    <a href="{{ route('admin.webpilotai.models.index') }}" class="font-medium text-blue-600 dark:text-blue-400 hover:text-blue-500">Manage AI Models</a>
                </div>
            </div>
        </div>

        {{-- Stat Card: User Websites --}}
        <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-lg rounded-lg">
            <div class="p-5">
                <div class="flex items-center">
                    <div class="flex-shrink-0 bg-indigo-500 dark:bg-indigo-700 rounded-md p-3">
                        {{-- Heroicon: globe-alt --}}
                        <svg class="h-6 w-6 text-white" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M12 21a9.004 9.004 0 0 0 8.716-6.747M12 21a9.004 9.004 0 0 1-8.716-6.747M12 21c2.485 0 4.5-4.03 4.5-9S14.485 3 12 3m0 18c-2.485 0-4.5-4.03-4.5-9S9.515 3 12 3m0 0a8.997 8.997 0 0 1 7.843 4.582M12 3a8.997 8.997 0 0 0-7.843 4.582m15.686 0A11.953 11.953 0 0 1 12 10.5c-2.998 0-5.74-1.1-7.843-2.918m15.686 0A8.959 8.959 0 0 1 21 12c0 .778-.099 1.533-.284 2.253m0 0A11.978 11.978 0 0 1 12 16.5c-3.162 0-6.024-1.205-8.242-3.243m16.484 0L12 16.5" />
                        </svg>
                    </div>
                    <div class="ml-5 w-0 flex-1">
                        <dl>
                            <dt class="text-sm font-medium text-gray-500 dark:text-gray-400 truncate">User Websites</dt>
                            <dd class="text-lg font-semibold text-gray-900 dark:text-white">Total: {{ $totalWebsites ?? 0 }}</dd>
                            <dd class="text-sm font-medium text-green-500 dark:text-green-400">Completed: {{ $completedWebsites ?? 0 }}</dd>
                            <dd class="text-sm font-medium text-yellow-500 dark:text-yellow-400">Pending: {{ $pendingWebsites ?? 0 }}</dd>
                        </dl>
                    </div>
                </div>
            </div>
            <div class="bg-gray-50 dark:bg-gray-700 px-5 py-3">
                <div class="text-sm">
                    <a href="{{ route('admin.webpilotai.user-sites.index') }}" class="font-medium text-indigo-600 dark:text-indigo-400 hover:text-indigo-500">Manage User Websites</a>
                </div>
            </div>
        </div>

        {{-- Stat Card: AI Templates --}}
        <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-lg rounded-lg">
            <div class="p-5">
                <div class="flex items-center">
                    <div class="flex-shrink-0 bg-purple-500 dark:bg-purple-700 rounded-md p-3">
                        {{-- Heroicon: document-duplicate --}}
                        <svg class="h-6 w-6 text-white" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M15.75 17.25v3.375c0 .621-.504 1.125-1.125 1.125h-9.75a1.125 1.125 0 0 1-1.125-1.125V7.875c0-.621.504-1.125 1.125-1.125H6.75a9.06 9.06 0 0 1 1.5.124m7.5 10.376h3.375c.621 0 1.125-.504 1.125-1.125V11.25c0-4.46-3.243-8.161-7.5-8.876a9.06 9.06 0 0 0-1.5-.124H9.375c-.621 0-1.125.504-1.125 1.125v3.5m7.5 10.375H9.375a1.125 1.125 0 0 1-1.125-1.125v-9.25m12 6.625v-1.875a3.375 3.375 0 0 0-3.375-3.375h-1.5a1.125 1.125 0 0 1-1.125-1.125v-1.5a3.375 3.375 0 0 0-3.375-3.375H9.75" />
                        </svg>
                    </div>
                    <div class="ml-5 w-0 flex-1">
                        <dl>
                            <dt class="text-sm font-medium text-gray-500 dark:text-gray-400 truncate">AI Templates</dt>
                            <dd class="text-lg font-semibold text-gray-900 dark:text-white">Total: {{ $totalAITemplates ?? 0 }}</dd>
                            <dd class="text-sm font-medium text-green-500 dark:text-green-400">Active: {{ $activeAITemplates ?? 0 }}</dd>
                        </dl>
                    </div>
                </div>
            </div>
            <div class="bg-gray-50 dark:bg-gray-700 px-5 py-3">
                <div class="text-sm">
                    <a href="{{ route('admin.webpilotai.ai-templates.index') }}" class="font-medium text-purple-600 dark:text-purple-400 hover:text-purple-500">Manage AI Templates</a>
                </div>
            </div>
        </div>

        {{-- Stat Card: AI Style Presets --}}
        <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-lg rounded-lg">
            <div class="p-5">
                <div class="flex items-center">
                    <div class="flex-shrink-0 bg-pink-500 dark:bg-pink-700 rounded-md p-3">
                        {{-- Heroicon: paint-brush --}}
                        <svg class="h-6 w-6 text-white" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M9.53 16.122a3 3 0 0 0-5.78 1.128 2.25 2.25 0 0 1-2.4 2.245 4.5 4.5 0 0 0 8.4-2.245c0-.399-.078-.78-.22-1.128Zm0 0a15.998 15.998 0 0 0 3.388-1.62m-5.043-.025a15.994 15.994 0 0 1 1.622-3.395m3.42 3.42a15.995 15.995 0 0 0 4.764-4.648l3.876-5.814a1.151 1.151 0 0 0-1.597-1.597L14.146 6.32a15.996 15.996 0 0 0-4.649 4.763m3.42 3.42a6.776 6.776 0 0 0-3.42-3.42" />
                        </svg>
                    </div>
                    <div class="ml-5 w-0 flex-1">
                        <dl>
                            <dt class="text-sm font-medium text-gray-500 dark:text-gray-400 truncate">AI Style Presets</dt>
                            <dd class="text-lg font-semibold text-gray-900 dark:text-white">Total: {{ $totalAIStylePresets ?? 0 }}</dd>
                            <dd class="text-sm font-medium text-green-500 dark:text-green-400">Active: {{ $activeAIStylePresets ?? 0 }}</dd>
                        </dl>
                    </div>
                </div>
            </div>
            <div class="bg-gray-50 dark:bg-gray-700 px-5 py-3">
                <div class="text-sm">
                    <a href="{{ route('admin.webpilotai.ai-style-presets.index') }}" class="font-medium text-pink-600 dark:text-pink-400 hover:text-pink-500">Manage AI Style Presets</a>
                </div>
            </div>
        </div>

        {{-- Stat Card: AI Image Studio --}}
        <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-lg rounded-lg">
            <div class="p-5">
                <div class="flex items-center">
                    <div class="flex-shrink-0 bg-teal-500 dark:bg-teal-700 rounded-md p-3">
                        {{-- Heroicon: photo --}}
                        <svg class="h-6 w-6 text-white" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M2.25 15.75l5.159-5.159a2.25 2.25 0 013.182 0l5.159 5.159m-1.5-1.5l1.409-1.409a2.25 2.25 0 013.182 0l2.909 2.909m-18 3.75h16.5a1.5 1.5 0 001.5-1.5V6a1.5 1.5 0 00-1.5-1.5H3.75A1.5 1.5 0 002.25 6v12a1.5 1.5 0 001.5 1.5z" />
                        </svg>
                    </div>
                    <div class="ml-5 w-0 flex-1">
                        <dl>
                            <dt class="text-sm font-medium text-gray-500 dark:text-gray-400 truncate">AI Image Studio</dt>
                            <dd class="text-lg font-semibold text-gray-900 dark:text-white">Generated: {{ $totalGeneratedImages ?? 0 }}</dd> {{-- Placeholder --}}
                            <dd class="text-sm font-medium text-green-500 dark:text-green-400">Providers Active: {{ $activeImageProviders ?? 0 }}</dd>
                        </dl>
                    </div>
                </div>
            </div>
            <div class="bg-gray-50 dark:bg-gray-700 px-5 py-3">
                <div class="text-sm">
                    <a href="{{ route('admin.webpilotai.settings.index') }}#ai-image-studio" class="font-medium text-teal-600 dark:text-teal-400 hover:text-teal-500">Configure Image Studio</a>
                </div>
            </div>
        </div>

        {{-- Link to Module Settings --}}
        <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-lg rounded-lg col-span-1 md:col-span-2 lg:col-span-1">
            <div class="p-5">
                <div class="flex items-center">
                    <div class="flex-shrink-0 bg-gray-500 dark:bg-gray-700 rounded-md p-3">
                        {{-- Heroicon: cog-6-tooth --}}
                        <svg class="h-6 w-6 text-white" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M9.594 3.94c.09-.542.56-.94 1.11-.94h2.593c.55 0 1.02.398 1.11.94l.213 1.281c.063.374.313.686.646.87.074.04.147.083.22.127.324.196.72.257 1.075.124l1.217-.456a1.125 1.125 0 0 1 1.37.49l1.296 2.247a1.125 1.125 0 0 1-.26 1.431l-1.003.827c-.293.24-.438.613-.431.992a6.759 6.759 0 0 1 0 1.905c-.007.378.138.75.43.99l1.005.828c.424.35.534.954.26 1.43l-1.298 2.247a1.125 1.125 0 0 1-1.369.491l-1.217-.456c-.355-.133-.75-.072-1.076.124a6.57 6.57 0 0 1-.22.128c-.333.183-.582.495-.644.869l-.213 1.28c-.09.543-.56.941-1.11.941h-2.594c-.55 0-1.02-.398-1.11-.94l-.213-1.281c-.062-.374-.312-.686-.644-.87a6.52 6.52 0 0 1-.22-.127c-.325-.196-.72-.257-1.076-.124l-1.217.456a1.125 1.125 0 0 1-1.369-.49l-1.297-2.247a1.125 1.125 0 0 1 .26-1.431l1.004-.827c.292-.24.437-.613.43-.992a6.759 6.759 0 0 1 0-1.905c.007-.378-.138-.75-.43-.99l-1.004-.828a1.125 1.125 0 0 1-.26-1.43l1.297-2.247a1.125 1.125 0 0 1 1.37-.491l1.216.456c.356.133.751.072 1.076-.124.072-.044.146-.087.22-.128.332-.183.582-.495.644-.869l.214-1.281Z" />
                            <path stroke-linecap="round" stroke-linejoin="round" d="M15 12a3 3 0 1 1-6 0 3 3 0 0 1 6 0Z" />
                        </svg>
                    </div>
                    <div class="ml-5 w-0 flex-1">
                        <dl>
                            <dt class="text-lg font-semibold text-gray-900 dark:text-white">Module Settings</dt>
                            <dd class="text-sm font-medium text-gray-500 dark:text-gray-400">API keys, defaults, etc.</dd>
                        </dl>
                    </div>
                </div>
            </div>
            <div class="bg-gray-50 dark:bg-gray-700 px-5 py-3">
                <div class="text-sm">
                    <a href="{{ route('admin.webpilotai.settings.index') }}" class="font-medium text-gray-600 dark:text-gray-400 hover:text-gray-500">Go to Settings</a>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection