@extends('layouts.admin') {{-- Or your main admin layout --}}

@section('title', 'AI Models')
@section('header_title', 'Manage AI Models')

@section('content')
<div class="p-6">
    <div class="bg-white dark:bg-gray-800 shadow-md rounded-lg p-6">
        <div class="flex justify-between items-center mb-6">
            <h2 class="text-2xl font-semibold text-gray-700 dark:text-gray-200">AI Models List</h2>
            <a href="{{ route('admin.webpilotai.models.create') }}" class="bg-blue-500 hover:bg-blue-600 text-white font-bold py-2 px-4 rounded-lg shadow-md transition duration-150 ease-in-out">
                <i class="fas fa-plus mr-2"></i> Add New Model
            </a>
        </div>

        @include('webpilotai::admin.partials._session_messages')

        @if($aiModels->isEmpty())
            <div class="text-center py-10">
                <p class="text-gray-500 dark:text-gray-400 text-lg">No AI Models configured.</p>
                <p class="mt-2 text-gray-400 dark:text-gray-500">Get started by adding a new AI model!</p>
            </div>
        @else
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
                    <thead class="bg-gray-50 dark:bg-gray-700">
                        <tr>
                            <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Name</th>
                            <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Provider</th>
                            <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Identifier</th>
                            <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Status</th>
                            <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Premium</th>
                            <th scope="col" class="px-6 py-3 text-right text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
                        @foreach ($aiModels as $model)
                        <tr>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="text-sm font-medium text-gray-900 dark:text-white">{{ $model->name }}</div>
                                @if($model->description)
                                <div class="text-xs text-gray-500 dark:text-gray-400 truncate" style="max-width: 200px;" title="{{ $model->description }}">{{ Str::limit($model->description, 40) }}</div>
                                @endif
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full 
                                    @if($model->provider === 'OpenAI') bg-sky-100 text-sky-800 dark:bg-sky-700 dark:text-sky-100
                                    @elseif($model->provider === 'Anthropic') bg-orange-100 text-orange-800 dark:bg-orange-700 dark:text-orange-100
                                    @elseif($model->provider === 'GoogleAI') bg-emerald-100 text-emerald-800 dark:bg-emerald-700 dark:text-emerald-100
                                    @else bg-gray-100 text-gray-800 dark:bg-gray-600 dark:text-gray-200 @endif">
                                    {{ $model->provider }}
                                </span>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="text-sm text-gray-500 dark:text-gray-400">{{ $model->identifier }}</div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                @if ($model->is_active)
                                    <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-green-100 text-green-800 dark:bg-green-700 dark:text-green-100">
                                        Active
                                    </span>
                                @else
                                    <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-red-100 text-red-800 dark:bg-red-700 dark:text-red-100">
                                        Inactive
                                    </span>
                                @endif
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                @if ($model->is_premium)
                                    <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-yellow-100 text-yellow-800 dark:bg-yellow-600 dark:text-yellow-100">
                                        Yes
                                    </span>
                                @else
                                    <span class="text-xs text-gray-500 dark:text-gray-400">No</span>
                                @endif
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium">
                                <a href="{{ route('admin.webpilotai.models.edit', $model->id) }}" class="text-indigo-600 hover:text-indigo-900 dark:text-indigo-400 dark:hover:text-indigo-200 mr-3 transition duration-150 ease-in-out">
                                    <i class="fas fa-edit"></i> Edit
                                </a>
                                <form action="{{ route('admin.webpilotai.models.destroy', $model->id) }}" method="POST" class="inline-block" onsubmit="return confirm('Are you sure you want to delete this AI Model? This action cannot be undone.');">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="text-red-600 hover:text-red-900 dark:text-red-400 dark:hover:text-red-200 transition duration-150 ease-in-out">
                                        <i class="fas fa-trash-alt"></i> Delete
                                    </button>
                                </form>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

            @if ($aiModels->hasPages())
                <div class="mt-6">
                    {{ $aiModels->links() }} {{-- Ensure your app is configured for Tailwind pagination views --}}
                </div>
            @endif
        @endif
    </div>
</div>
@endsection

@push('scripts')
{{-- Add any specific scripts for this page here if needed --}}
@endpush

@push('styles')
<style>
    /* You can add specific styles here if absolutely necessary, but prefer Tailwind classes */
</style>
@endpush