@extends('layouts.admin') {{-- Or your main admin layout --}}

@section('title', 'AI Templates')
@section('header_title', 'Manage AI Templates')

@section('content')
<div class="p-6">
    <div class="bg-white dark:bg-gray-800 shadow-md rounded-lg p-6">
        <div class="flex justify-between items-center mb-6">
            <h2 class="text-2xl font-semibold text-gray-700 dark:text-gray-200">AI Templates List</h2>
            <a href="{{ route('admin.webpilotai.ai-templates.create') }}" class="bg-blue-500 hover:bg-blue-600 text-white font-bold py-2 px-4 rounded-lg shadow-md transition duration-150 ease-in-out">
                <i class="fas fa-plus mr-2"></i> Create New Template
            </a>
        </div>

        @include('webpilotai::admin.partials._session_messages')

        @if($aiTemplates->isEmpty())
            <div class="text-center py-10">
                <p class="text-gray-500 dark:text-gray-400 text-lg">No AI Templates found.</p>
                <p class="mt-2 text-gray-400 dark:text-gray-500">Get started by creating a new template!</p>
            </div>
        @else
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
                    <thead class="bg-gray-50 dark:bg-gray-700">
                        <tr>
                            <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Preview</th>
                            <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Name</th>
                            <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Description</th>
                            <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Status</th>
                            <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Premium</th>
                            <th scope="col" class="px-6 py-3 text-right text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
                        @foreach ($aiTemplates as $template)
                        <tr>
                            <td class="px-6 py-4 whitespace-nowrap">
                                @if($template->preview_image_path)
                                    <img src="{{ asset('storage/' . $template->preview_image_path) }}" alt="{{ $template->name }} preview" class="h-10 w-16 object-cover rounded border border-gray-300 dark:border-gray-600">
                                @else
                                    <div class="h-10 w-16 flex items-center justify-center bg-gray-100 dark:bg-gray-700 text-gray-400 dark:text-gray-500 rounded border border-gray-300 dark:border-gray-600 text-xs">
                                        No Preview
                                    </div>
                                @endif
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="text-sm font-medium text-gray-900 dark:text-white">{{ $template->name }}</div>
                            </td>
                            <td class="px-6 py-4">
                                <div class="text-sm text-gray-500 dark:text-gray-400 truncate" style="max-width: 250px;" title="{{ $template->description }}">
                                    {{ Str::limit($template->description, 60) }}
                                </div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                @if ($template->is_active)
                                    <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-green-100 text-green-800 dark:bg-green-700 dark:text-green-100">
                                        Active
                                    </span>
                                @else
                                    <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-red-100 text-red-800 dark:bg-red-700 dark:text-red-100">
                                        Inactive
                                    </span>
                                @endif
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                @if ($template->is_premium)
                                    <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-yellow-100 text-yellow-800 dark:bg-yellow-600 dark:text-yellow-100">
                                        Yes
                                    </span>
                                @else
                                    <span class="text-xs text-gray-500 dark:text-gray-400">No</span>
                                @endif
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium">
                                <a href="{{ route('admin.webpilotai.ai-templates.edit', $template->id) }}" class="text-indigo-600 hover:text-indigo-900 dark:text-indigo-400 dark:hover:text-indigo-200 mr-3 transition duration-150 ease-in-out">
                                    <i class="fas fa-edit"></i> Edit
                                </a>
                                <form action="{{ route('admin.webpilotai.ai-templates.destroy', $template->id) }}" method="POST" class="inline-block" onsubmit="return confirm('Are you sure you want to delete this AI Template? This action cannot be undone.');">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="text-red-600 hover:text-red-900 dark:text-red-400 dark:hover:text-red-200 transition duration-150 ease-in-out">
                                        <i class="fas fa-trash-alt"></i> Delete
                                    </button>
                                </form>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

            @if ($aiTemplates->hasPages())
                <div class="mt-6">
                    {{ $aiTemplates->links() }} {{-- Ensure your app is configured for Tailwind pagination views --}}
                </div>
            @endif
        @endif
    </div>
</div>
@endsection

@push('scripts')
{{-- Add any specific scripts for this page here if needed --}}
@endpush

@push('styles')
<style>
    /* You can add specific styles here if absolutely necessary, but prefer Tailwind classes */
</style>
@endpush

{{--
Ensure you have these partials or adapt to your existing ones:
Modules/WebPilotAI/resources/views/admin/partials/_session_messages.blade.php
Modules/WebPilotAI/resources/views/admin/partials/_validation_errors.blade.php
--}}