@extends('layouts.admin') {{-- Or your main admin layout --}}

@section('title', 'Edit AI Template')
@section('header_title', 'Edit AI Template: ' . $aiTemplate->name)

@section('content')
<div class="p-6">
    <div class="bg-white dark:bg-gray-800 shadow-md rounded-lg p-6">
        <h2 class="text-2xl font-semibold text-gray-700 dark:text-gray-200 mb-6">Update AI Template Details</h2>

        @include('webpilotai::admin.partials._validation_errors')

        <form action="{{ route('admin.webpilotai.ai-templates.update', $aiTemplate->id) }}" method="POST" enctype="multipart/form-data">
            @csrf
            @method('PUT')

            {{-- Name --}}
            <div class="mb-6">
                <label for="name" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Template Name <span class="text-red-500">*</span></label>
                <input type="text" name="name" id="name" value="{{ old('name', $aiTemplate->name) }}" required
                       class="mt-1 block w-full py-2 px-3 border border-gray-300 dark:border-gray-600 bg-white dark:bg-gray-700 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm dark:text-gray-200">
            </div>

            {{-- Description --}}
            <div class="mb-6">
                <label for="description" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Description</label>
                <textarea name="description" id="description" rows="3"
                          class="mt-1 block w-full py-2 px-3 border border-gray-300 dark:border-gray-600 bg-white dark:bg-gray-700 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm dark:text-gray-200">{{ old('description', $aiTemplate->description) }}</textarea>
                <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">A brief explanation of what this template is for.</p>
            </div>

            {{-- Prompt Structure (JSON) --}}
            <div class="mb-6">
                <label for="prompt_modifications" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Prompt Modifications (JSON) <span class="text-red-500">*</span></label>
                <textarea name="prompt_structure" id="prompt_structure" rows="10" required
                          class="mt-1 block w-full py-2 px-3 border border-gray-300 dark:border-gray-600 bg-white dark:bg-gray-700 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm font-mono dark:text-gray-200"
                          placeholder='e.g., {"prefix": "Generate a website about...", "suffix": "Ensure it is responsive."}'
                          >{{ old('prompt_structure', json_encode($aiTemplate->prompt_modifications, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES)) }}</textarea>
                <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">
                    Enter valid JSON. Can include 'prefix', 'suffix', or 'full_prompt_template'.
                </p>
                <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">Available placeholders for <code>full_prompt_template</code>:</p>
                <ul class="list-disc list-inside text-xs text-gray-500 dark:text-gray-400 ml-4">
                    <li><code>[WEBSITE_NAME]</code>: The name of the website.</li>
                    <li><code>[USER_PROMPT]</code>: The user's description prompt.</li>
                    <li><code>[PAGES_LIST]</code>: A formatted list of pages the user wants.</li>
                    <li><code>[ASSETS_LIST]</code>: A formatted list of uploaded assets with their target filenames and descriptions.</li>
                    <li><code>[STYLING_GUIDELINES]</code>: Structured styling instructions from selected style presets.</li>
                </ul>
                <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">Example (Full Template):</p>
                <pre class="bg-gray-100 dark:bg-gray-700 p-2 rounded text-xs font-mono"><code>{
  "full_prompt_template": "Create a website for [WEBSITE_NAME] based on this: [USER_PROMPT].\nPages to include:\n[PAGES_LIST]\nAvailable assets:\n[ASSETS_LIST]\nApply these styles:\n[STYLING_GUIDELINES]"
}</code></pre>
                <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">Example (Prefix/Suffix):</p>
                <pre class="bg-gray-100 dark:bg-gray-700 p-2 rounded text-xs font-mono"><code>{
  "prefix": "Focus on a professional tone.",
  "suffix": "End with a call to action."
}</code></pre>
            </div>

            {{-- Preview Image --}}
            <div class="mb-6">
                <label for="preview_image" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Preview Image (Optional)</label>
                @if($aiTemplate->preview_image_path)
                    <div class="mb-2">
                        <img src="{{ asset('storage/' . $aiTemplate->preview_image_path) }}" alt="Current Preview" class="h-20 w-auto rounded border border-gray-300 dark:border-gray-600">
                        <label for="remove_preview_image" class="mt-1 text-xs flex items-center text-red-600 dark:text-red-400">
                            <input type="checkbox" name="remove_preview_image" id="remove_preview_image" value="1" class="mr-1 h-3 w-3"> Remove current image
                        </label>
                    </div>
                @endif
                <input type="file" name="preview_image" id="preview_image"
                       class="mt-1 block w-full text-sm text-gray-900 dark:text-gray-200 border border-gray-300 dark:border-gray-600 rounded-lg cursor-pointer bg-gray-50 dark:bg-gray-700 focus:outline-none
                              file:mr-4 file:py-2 file:px-4
                              file:rounded-l-lg file:border-0
                              file:text-sm file:font-semibold
                              file:bg-indigo-50 dark:file:bg-indigo-800 file:text-indigo-700 dark:file:text-indigo-300
                              hover:file:bg-indigo-100 dark:hover:file:bg-indigo-700">
                <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">Recommended size: 300x200px. Max 2MB. Uploading a new image will replace the current one.</p>
            </div>

            {{-- Flags --}}
            <div class="mb-6 grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <label for="is_active" class="flex items-center">
                        <input type="checkbox" name="is_active" id="is_active" value="1" {{ old('is_active', $aiTemplate->is_active) ? 'checked' : '' }}
                               class="h-4 w-4 text-indigo-600 border-gray-300 dark:border-gray-600 rounded focus:ring-indigo-500 dark:bg-gray-700 dark:focus:ring-offset-gray-800">
                        <span class="ml-2 text-sm text-gray-700 dark:text-gray-300">Active (Available for users)</span>
                    </label>
                </div>
                <div>
                    <label for="is_premium" class="flex items-center">
                        <input type="checkbox" name="is_premium" id="is_premium" value="1" {{ old('is_premium', $aiTemplate->is_premium) ? 'checked' : '' }}
                               class="h-4 w-4 text-indigo-600 border-gray-300 dark:border-gray-600 rounded focus:ring-indigo-500 dark:bg-gray-700 dark:focus:ring-offset-gray-800">
                        <span class="ml-2 text-sm text-gray-700 dark:text-gray-300">Premium (Requires subscription/permission)</span>
                    </label>
                </div>
            </div>

            {{-- Actions --}}
            <div class="mt-8 pt-5 border-t border-gray-200 dark:border-gray-700">
                <div class="flex justify-end">
                    <a href="{{ route('admin.webpilotai.ai-templates.index') }}" class="bg-gray-200 hover:bg-gray-300 text-gray-700 font-bold py-2 px-4 rounded-lg mr-3 transition duration-150 ease-in-out dark:bg-gray-600 dark:text-gray-200 dark:hover:bg-gray-500">
                        Cancel
                    </a>
                    <button type="submit" class="bg-green-500 hover:bg-green-600 text-white font-bold py-2 px-4 rounded-lg shadow-md transition duration-150 ease-in-out">
                        <i class="fas fa-save mr-2"></i> Update Template
                    </button>
                </div>
            </div>
        </form>
    </div>
</div>
@endsection

@push('styles')
{{-- <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.52.2/codemirror.min.css"> --}}
{{-- <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.52.2/theme/material-darker.min.css"> --}}
@endpush

@push('scripts')
{{-- <script src="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.52.2/codemirror.min.js"></script> --}}
{{-- <script src="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.52.2/mode/javascript/javascript.min.js"></script> --}}
{{-- <script>
    // document.addEventListener('DOMContentLoaded', function () {
    //     var promptStructureTextArea = document.getElementById('prompt_structure');
    //     if (promptStructureTextArea) {
    //         CodeMirror.fromTextArea(promptStructureTextArea, {
    //             lineNumbers: true,
    //             mode: { name: "javascript", json: true },
    //             theme: "material-darker", // or any other theme you prefer
    //             matchBrackets: true,
    //             autoCloseBrackets: true,
    //         });
    //     }
    // });
</script> --}}
@endpush