@extends('layouts.admin') {{-- Or your main admin layout --}}

@section('title', 'Create AI Style Preset')
@section('header_title', 'Create New AI Style Preset')

@section('content')
<div class="p-6">
    <div class="bg-white dark:bg-gray-800 shadow-md rounded-lg p-6">
        <h2 class="text-2xl font-semibold text-gray-700 dark:text-gray-200 mb-6">New AI Style Preset Details</h2>

        @include('webpilotai::admin.partials._validation_errors')

        <form action="{{ route('admin.webpilotai.ai-style-presets.store') }}" method="POST" enctype="multipart/form-data">
            @csrf

            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                {{-- Name --}}
                <div>
                    <label for="name" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Preset Name <span class="text-red-500">*</span></label>
                    <input type="text" name="name" id="name" value="{{ old('name') }}" required
                           class="mt-1 block w-full py-2 px-3 border border-gray-300 dark:border-gray-600 bg-white dark:bg-gray-700 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm dark:text-gray-200">
                </div>

                {{-- Type --}}
                <div>
                    <label for="type" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Preset Type <span class="text-red-500">*</span></label>
                    <select name="type" id="type" required
                            class="mt-1 block w-full py-2 px-3 border border-gray-300 dark:border-gray-600 bg-white dark:bg-gray-700 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm dark:text-gray-200">
                        <option value="">-- Select Type --</option>
                        <option value="color_palette" {{ old('type') == 'color_palette' ? 'selected' : '' }}>Color Palette</option>
                        <option value="font_scheme" {{ old('type') == 'font_scheme' ? 'selected' : '' }}>Font Scheme</option>
                        <option value="visual_theme" {{ old('type') == 'visual_theme' ? 'selected' : '' }}>Visual Theme</option>
                        <option value="element_specific_styles" {{ old('type') == 'element_specific_styles' ? 'selected' : '' }}>Element Specific Styles</option>
                        <option value="direct_instruction" {{ old('type') == 'direct_instruction' ? 'selected' : '' }}>Direct Instruction</option>
                        {{-- Add other types as needed --}}
                    </select>
                </div>
            </div>

            {{-- Description --}}
            <div class="mt-6">
                <label for="description" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Description</label>
                <textarea name="description" id="description" rows="3"
                          class="mt-1 block w-full py-2 px-3 border border-gray-300 dark:border-gray-600 bg-white dark:bg-gray-700 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm dark:text-gray-200">{{ old('description') }}</textarea>
                <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">A brief explanation of what this style preset does.</p>
            </div>

            {{-- Configuration (JSON) --}}
            <div class="mt-6">
                <label for="configuration" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Configuration (JSON) <span class="text-red-500">*</span></label>
                <textarea name="configuration" id="configuration" rows="10" required
                          class="mt-1 block w-full py-2 px-3 border border-gray-300 dark:border-gray-600 bg-white dark:bg-gray-700 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm font-mono dark:text-gray-200"
                          placeholder='e.g., {"primary_color": "#aabbcc", "font_family": "Arial"}'
                          >{{ old('configuration') }}</textarea>
                <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">
                    Enter valid JSON. Refer to documentation for structure based on 'Preset Type'.
                    <br>Example for Color Palette: <code>{"primary": "#3498db", "secondary": "#2ecc71"}</code>
                    <br>Example for Font Scheme: <code>{"headings": {"family": "Montserrat", "weight": "700"}, "body": "Lato"}</code>
                </p>
            </div>

            {{-- Preview Image --}}
            <div class="mt-6">
                <label for="preview_image" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Preview Image (Optional)</label>
                <input type="file" name="preview_image" id="preview_image"
                       class="mt-1 block w-full text-sm text-gray-900 dark:text-gray-200 border border-gray-300 dark:border-gray-600 rounded-lg cursor-pointer bg-gray-50 dark:bg-gray-700 focus:outline-none
                              file:mr-4 file:py-2 file:px-4
                              file:rounded-l-lg file:border-0
                              file:text-sm file:font-semibold
                              file:bg-indigo-50 dark:file:bg-indigo-800 file:text-indigo-700 dark:file:text-indigo-300
                              hover:file:bg-indigo-100 dark:hover:file:bg-indigo-700">
                <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">Recommended size: 300x200px. Max 2MB.</p>
            </div>

            {{-- Flags --}}
            <div class="mt-6 grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <label for="is_active" class="flex items-center">
                        <input type="checkbox" name="is_active" id="is_active" value="1" {{ old('is_active', true) ? 'checked' : '' }}
                               class="h-4 w-4 text-indigo-600 border-gray-300 dark:border-gray-600 rounded focus:ring-indigo-500 dark:bg-gray-700 dark:focus:ring-offset-gray-800">
                        <span class="ml-2 text-sm text-gray-700 dark:text-gray-300">Active (Available for users)</span>
                    </label>
                </div>
                <div>
                    <label for="is_premium" class="flex items-center">
                        <input type="checkbox" name="is_premium" id="is_premium" value="1" {{ old('is_premium') ? 'checked' : '' }}
                               class="h-4 w-4 text-indigo-600 border-gray-300 dark:border-gray-600 rounded focus:ring-indigo-500 dark:bg-gray-700 dark:focus:ring-offset-gray-800">
                        <span class="ml-2 text-sm text-gray-700 dark:text-gray-300">Premium (Requires subscription/permission)</span>
                    </label>
                </div>
            </div>

            {{-- Actions --}}
            <div class="mt-8 pt-5 border-t border-gray-200 dark:border-gray-700">
                <div class="flex justify-end">
                    <a href="{{ route('admin.webpilotai.ai-style-presets.index') }}" class="bg-gray-200 hover:bg-gray-300 text-gray-700 font-bold py-2 px-4 rounded-lg mr-3 transition duration-150 ease-in-out dark:bg-gray-600 dark:text-gray-200 dark:hover:bg-gray-500">
                        Cancel
                    </a>
                    <button type="submit" class="bg-green-500 hover:bg-green-600 text-white font-bold py-2 px-4 rounded-lg shadow-md transition duration-150 ease-in-out">
                        <i class="fas fa-save mr-2"></i> Save Preset
                    </button>
                </div>
            </div>
        </form>
    </div>
</div>
@endsection

@push('styles')
{{-- For a better JSON editing experience, consider CodeMirror or a similar library --}}
{{-- <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.52.2/codemirror.min.css"> --}}
{{-- <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.52.2/theme/material-darker.min.css"> --}}
@endpush

@push('scripts')
{{-- <script src="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.52.2/codemirror.min.js"></script> --}}
{{-- <script src="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.52.2/mode/javascript/javascript.min.js"></script> --}}
{{-- <script>
    // document.addEventListener('DOMContentLoaded', function () {
    //     var configTextArea = document.getElementById('configuration');
    //     if (configTextArea) {
    //         CodeMirror.fromTextArea(configTextArea, {
    //             lineNumbers: true,
    //             mode: { name: "javascript", json: true },
    //             theme: "material-darker", // or any other theme you prefer
    //             matchBrackets: true,
    //             autoCloseBrackets: true,
    //         });
    //     }
    // });
</script> --}}
@endpush

{{-- Create a partial for validation errors if you don't have one --}}
{{-- Example: resources/views/admin/partials/_validation_errors.blade.php --}}
{{--
@if ($errors->any())
    <div class="bg-red-100 dark:bg-red-700 border-l-4 border-red-500 dark:border-red-300 text-red-700 dark:text-red-200 p-4 mb-6" role="alert">
        <p class="font-bold">Please correct the following errors:</p>
        <ul class="mt-2 list-disc list-inside text-sm">
            @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
@endif
--}}