<?php

namespace Modules\WebPilotAI\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use App\Models\User;

class WebsiteAsset extends Model
{
    use HasFactory;

    protected $table = 'website_assets';

    protected $fillable = [
        'website_id',
        'user_id',
        'type',
        'disk',
        'path',
        'original_name',
        'mime_type',
        'size',
        'description',
        'metadata',
    ];

    protected $casts = [
        'metadata' => 'array',
    ];

    public function website(): BelongsTo
    {
        return $this->belongsTo(Website::class);
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    // TODO: Add factory if needed: protected static function newFactory() { return \Modules\WebPilotAI\Database\factories\WebsiteAssetFactory::new(); }
}