<?php

namespace Modules\WebPilotAI\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class AIModel extends Model
{
    use HasFactory;

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'ai_models';

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'identifier',
        'provider',
        'api_key_setting_name',
        'description',
        'is_active',
        'is_premium',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'is_active' => 'boolean',
        'is_premium' => 'boolean',
    ];

    // If you plan to use factories for testing or seeding:
    // protected static function newFactory()
    // {
    //     return \Modules\WebPilotAI\Database\factories\AIModelFactory::new();
    // }
}