<?php

use Illuminate\Support\Facades\Route;
    use Modules\BusinessDirectory\Http\Controllers\Frontend\HomepageController; // Added
use Modules\BusinessDirectory\Http\Controllers\Frontend\FrontendProductController;
use Modules\BusinessDirectory\Http\Controllers\Frontend\CompanyController as FrontendCompanyController; // Corrected import
use Modules\BusinessDirectory\Http\Controllers\Frontend\TenderController as FrontendTenderController;
use Modules\BusinessDirectory\Http\Controllers\Frontend\BidController as FrontendBidController;
use Modules\BusinessDirectory\Http\Controllers\Frontend\JobController as FrontendJobController;
use Modules\BusinessDirectory\Http\Controllers\Frontend\JobApplicationController as FrontendJobApplicationController;
use Modules\BusinessDirectory\Http\Controllers\Frontend\CompanyProjectController as FrontendCompanyProjectController;
use Modules\BusinessDirectory\Http\Controllers\Frontend\CompanyTaskController as FrontendCompanyTaskController;
use Modules\BusinessDirectory\Http\Controllers\Frontend\ReviewController as FrontendReviewController;
use Modules\BusinessDirectory\Http\Controllers\Frontend\CartController as FrontendCartController;
use Modules\BusinessDirectory\Http\Controllers\Frontend\OrderController as FrontendOrderController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::group(['middleware' => 'web', 'as' => 'frontend.businessdirectory.'], function () {
        // Homepage for Business Directory (if LandingPage module is not active or this is the primary)
        Route::get('/', [HomepageController::class, 'index'])->name('homepage');

    // Company Public Routes
    Route::get('companies', [FrontendCompanyController::class, 'index'])->name('companies.index');
    Route::get('companies/{company:slug}', [FrontendCompanyController::class, 'show'])->name('companies.show');
    Route::get('companies/type/{companyType:slug}', [FrontendCompanyController::class, 'indexByType'])->name('companies.by-type');

    // Product Public Routes (if companies have product listings)
    Route::get('companies/{company:slug}/products', [FrontendProductController::class, 'index'])->name('companies.products.index');
    Route::get('products/{product:slug}', [FrontendProductController::class, 'show'])->name('products.show'); // Direct product link
    Route::get('products', [FrontendProductController::class, 'index'])->name('products.index'); // General public product listing

    // Tender Public Routes
    Route::get('tenders', [FrontendTenderController::class, 'index'])->name('tenders.index');
    Route::get('tenders/{tender:slug}', [FrontendTenderController::class, 'show'])->name('tenders.show');

     // Public Job Listings
    Route::get('jobs', [FrontendJobController::class, 'index'])->name('jobs.index');
    Route::get('jobs/{slug}', [FrontendJobController::class, 'show'])->name('jobs.show'); // Using slug for SEO friendly URLs
    Route::post('jobs/{job}/apply', [FrontendJobApplicationController::class, 'store'])->name('jobs.apply')->middleware('auth'); // Job model binding

    // Company Reviews (Frontend Submission)
    Route::post('companies/{company:slug}/reviews', [FrontendReviewController::class, 'store'])->name('companies.reviews.store')->middleware('auth');

    // Category Public Routes
    Route::get('categories', [FrontendCompanyController::class, 'allCategories'])->name('categories.index');
    Route::get('category/{category:slug}', [FrontendCompanyController::class, 'showCategory'])->name('category.show');

    // General Search Route (can point to company index or a dedicated search handler)
    Route::get('search', [FrontendCompanyController::class, 'index'])->name('search.index'); // Reusing company index for general search

    Route::post('newsletter/subscribe', [HomepageController::class, 'subscribeNewsletter'])->name('newsletter.subscribe');

    // Authenticated User Routes for Business Directory (e.g., managing their own companies, products, tenders, bids)
    Route::group(['middleware' => 'auth'], function () {
        Route::get('my-companies', [FrontendCompanyController::class, 'myCompanies'])->name('my-companies.index');
        Route::get('my-companies/create', [FrontendCompanyController::class, 'create'])->name('my-companies.create');
        Route::post('my-companies', [FrontendCompanyController::class, 'store'])->name('my-companies.store');
        Route::get('my-companies/{company:slug}/edit', [FrontendCompanyController::class, 'edit'])->name('my-companies.edit');
        Route::put('my-companies/{company:slug}', [FrontendCompanyController::class, 'update'])->name('my-companies.update');
        Route::delete('my-companies/{company:slug}', [FrontendCompanyController::class, 'destroy'])->name('my-companies.destroy');

        // My Products - Management within a specific company context
        Route::get('my-companies/{company:slug}/manage-products', [FrontendProductController::class, 'manageCompanyProducts'])->name('my-companies.products.manage');
        Route::get('my-companies/{company:slug}/products/create', [FrontendProductController::class, 'create'])->name('my-companies.products.create');
        // Note: Storing products is often tied to a company, so the store route might be better associated with a company context or handled generally below.
        Route::post('my-companies/{company:slug}/products', [FrontendProductController::class, 'store'])->name('my-companies.products.store');

        // My Products - General actions (create, edit, update, delete specific product)
        // The 'create' and 'store' routes here are for the general "Post Product" link from main navigation
        Route::get('my-products/create', [FrontendProductController::class, 'create'])->name('my-products.create');
        Route::post('my-products', [FrontendProductController::class, 'store'])->name('my-products.store');
        Route::get('my-products/{product:slug}/edit', [FrontendProductController::class, 'edit'])->name('my-products.edit');
        Route::get('my-products', [FrontendProductController::class, 'myProductsIndex'])->name('my-products.index'); // Added for "Manage My Products" link
        Route::put('my-products/{product:slug}', [FrontendProductController::class, 'update'])->name('my-products.update');
        Route::delete('my-products/{product:slug}', [FrontendProductController::class, 'destroy'])->name('my-products.destroy');
        

        // My Tenders
        Route::get('my-tenders', [FrontendTenderController::class, 'myTenders'])->name('my-tenders.index');
        Route::get('my-tenders/create', [FrontendTenderController::class, 'create'])->name('my-tenders.create');
        Route::post('my-tenders', [FrontendTenderController::class, 'store'])->name('my-tenders.store');
        Route::get('my-tenders/{tender:slug}/edit', [FrontendTenderController::class, 'edit'])->name('my-tenders.edit');
        Route::put('my-tenders/{tender:slug}', [FrontendTenderController::class, 'update'])->name('my-tenders.update');
        Route::get('my-tenders/{tender:slug}', [FrontendTenderController::class, 'showMyTender'])->name('my-tenders.show'); // View a specific tender I posted
        Route::delete('my-tenders/{tender:slug}', [FrontendTenderController::class, 'destroy'])->name('my-tenders.destroy');
        Route::get('my-tenders/{tender:slug}/bids', [FrontendTenderController::class, 'showBids'])->name('my-tenders.bids'); // View bids on my tender
        Route::patch('my-bids/{bid}/update-status', [FrontendTenderController::class, 'updateBidStatus'])->name('my-bids.update-status'); // Tender owner updates bid status

        // Submitting Bids
        Route::post('tenders/{tender:slug}/bids', [FrontendBidController::class, 'store'])->name('tenders.bids.store'); // New route for storing bids

        // My Submitted Bids (Viewing bids I've made)
        Route::get('my-submitted-bids', [FrontendBidController::class, 'mySubmittedBids'])->name('my-submitted-bids.index');
        Route::get('my-submitted-bids/{bid}', [FrontendBidController::class, 'showMyBid'])->name('my-submitted-bids.show'); // Optional: view a specific bid I made
        Route::delete('my-submitted-bids/{bid}/withdraw', [FrontendBidController::class, 'withdrawBid'])->name('my-submitted-bids.withdraw'); // Optional: withdraw a bid

        // My Jobs (Company Management) - Assuming a user manages jobs for their primary company
        Route::get('my-jobs', [FrontendJobController::class, 'myJobs'])->name('my-jobs.index');
        Route::get('my-jobs/create', [FrontendJobController::class, 'createMyJob'])->name('my_jobs.create');
        Route::post('my-jobs', [FrontendJobController::class, 'storeMyJob'])->name('my_jobs.store');
        Route::get('my-jobs/{job}/edit', [FrontendJobController::class, 'editMyJob'])->name('my_jobs.edit'); // Job model binding
        Route::put('my-jobs/{job}', [FrontendJobController::class, 'updateMyJob'])->name('my_jobs.update'); // Job model binding
        Route::delete('my-jobs/{job}', [FrontendJobController::class, 'destroyMyJob'])->name('my_jobs.destroy');

        // My Job Applications (User)
        Route::get('my-job-applications', [FrontendJobApplicationController::class, 'myApplications'])->name('my-job-applications.index');

        // My Projects (Company Management)
        Route::resource('my-projects', FrontendCompanyProjectController::class)->parameters(['my-projects' => 'project']);
        // My Tasks (Nested under My Projects for company owners)
        Route::resource('my-projects.tasks', FrontendCompanyTaskController::class)
            ->parameters(['my-projects' => 'project', 'tasks' => 'task'])
            ->except(['index', 'show']); // Index/show usually handled by project show page

        // My Orders (User)
        Route::get('my-orders', [FrontendOrderController::class, 'myOrders'])->name('my-orders.index');
        Route::get('my-orders/{order}', [FrontendOrderController::class, 'showMyOrder'])->name('my-orders.show');

        // My Reviews (User)
        Route::get('my-reviews', [FrontendReviewController::class, 'myReviews'])->name('my-reviews.index');

        // Create Opportunity Page (Generic)
        Route::get('create-opportunity', [HomepageController::class, 'showOpportunityCreatePage'])->name('opportunity.create');
    });

    // Cart Routes (can be outside auth group if guests can add to cart)
    Route::post('cart/add/{product:slug}', [FrontendCartController::class, 'add'])->name('cart.add');
    Route::get('cart', [FrontendCartController::class, 'index'])->name('cart.index');
    Route::post('cart/update/{cartItem}', [FrontendCartController::class, 'update'])->name('cart.update'); // Assuming CartItem model binding
    Route::post('cart/remove/{cartItem}', [FrontendCartController::class, 'remove'])->name('cart.remove'); // Assuming CartItem model binding
    Route::post('cart/clear', [FrontendCartController::class, 'clear'])->name('cart.clear');

    // Checkout Routes (typically requires auth)
    Route::group(['middleware' => 'auth'], function () {
        Route::get('checkout', [FrontendOrderController::class, 'showCheckoutForm'])->name('checkout.form');
        Route::post('checkout', [FrontendOrderController::class, 'processCheckout'])->name('checkout.process');
    });
});
