<?php

use Illuminate\Support\Facades\Route;
use Modules\BusinessDirectory\Http\Controllers\Admin\CompanyController;
use Modules\BusinessDirectory\Http\Controllers\Admin\CompanyTypeController;
use Modules\BusinessDirectory\Http\Controllers\Admin\ProductController;
use Modules\BusinessDirectory\Http\Controllers\Admin\TenderController;
use Modules\BusinessDirectory\Http\Controllers\Admin\BusinessDirectorySettingController;
use Modules\BusinessDirectory\Http\Controllers\Admin\JobController as AdminJobController;
use Modules\BusinessDirectory\Http\Controllers\Admin\CompanyProjectController as AdminCompanyProjectController;
use Modules\BusinessDirectory\Http\Controllers\Admin\CompanyTaskController as AdminCompanyTaskController;
use Modules\BusinessDirectory\Http\Controllers\Admin\ReviewController as AdminReviewController;
use Modules\BusinessDirectory\Http\Controllers\Admin\OrderController as AdminOrderController;
use Modules\BusinessDirectory\Http\Controllers\Admin\CategoryController as AdminCategoryController; // Added

// The main app/Providers/RouteServiceProvider.php already applies the
// 'Modules\BusinessDirectory\Http\Controllers\Admin' namespace.
// Routes defined here will use that namespace.

// Corresponds to "admin.businessdirectory.dashboard"
Route::get('dashboard', [\Modules\BusinessDirectory\Http\Controllers\Admin\DashboardController::class, 'index'])->name('dashboard');

// Corresponds to "admin.businessdirectory.companies.index" (and others like .create, .store, .edit, .update, .destroy)
Route::resource('companies', CompanyController::class);

// Corresponds to "admin.businessdirectory.companytypes.index"
// Using custom names to match the module.json if 'companytypes.index' is desired
Route::resource('company-types', CompanyTypeController::class)->names([
    'index' => 'company-types.index',
    'create' => 'company-types.create',
    'store' => 'company-types.store',
    'show' => 'company-types.show',
    'edit' => 'company-types.edit',
    'update' => 'company-types.update',
    'destroy' => 'company-types.destroy',
]);

// Nested resource for products under companies.
// index, create, store will be companies/{company}/products
// show, edit, update, destroy will be products/{product} (due to shallow)
Route::resource('companies.products', ProductController::class)->shallow();

// Corresponds to "admin.businessdirectory.tenders.index"
Route::resource('tenders', TenderController::class);
Route::get('tenders/{tender}/bids', [TenderController::class, 'showBids'])->name('tenders.show-bids');
Route::patch('bids/{bid}/toggle-flag', [TenderController::class, 'toggleBidFlag'])->name('bids.toggle-flag');

// Jobs Management (Admin)
Route::resource('jobs', AdminJobController::class);
Route::post('job-applications/{application}/update-status', [AdminJobController::class, 'updateApplicationStatus'])
    ->name('job-applications.updateStatus');

// Projects & Tasks Management (Admin)
Route::resource('projects', AdminCompanyProjectController::class);
Route::resource('projects.tasks', AdminCompanyTaskController::class)->shallow(); // Tasks nested under projects

// Reviews Management (Admin)
Route::resource('reviews', AdminReviewController::class)->only(['index', 'show', 'destroy']);
Route::post('reviews/{review}/update-status', [AdminReviewController::class, 'updateStatus'])
    ->name('reviews.updateStatus');
Route::post('reviews/bulk-actions', [AdminReviewController::class, 'bulkActions'])->name('reviews.bulk-actions');

// Orders Management (Admin)
Route::resource('orders', AdminOrderController::class)->only(['index', 'show', 'update']);

// Categories Management (Admin) - Added
Route::resource('categories', AdminCategoryController::class);

// Specific routes for company status changes if not handled by update
Route::patch('companies/{company}/approve', [CompanyController::class, 'approve'])->name('companies.approve');
Route::patch('companies/{company}/reject', [CompanyController::class, 'reject'])->name('companies.reject');
Route::patch('companies/{company}/suspend', [CompanyController::class, 'suspend'])->name('companies.suspend');
Route::patch('companies/{company}/reactivate', [CompanyController::class, 'reactivate'])->name('companies.reactivate');
Route::patch('companies/{company}/toggle-featured', [CompanyController::class, 'toggleFeatured'])->name('companies.toggle-featured');
Route::patch('companies/{company}/toggle-verified', [CompanyController::class, 'toggleVerified'])->name('companies.toggle-verified');

// Settings for the Business Directory module
Route::get('settings', [BusinessDirectorySettingController::class, 'edit'])->name('settings.edit');
Route::put('settings', [BusinessDirectorySettingController::class, 'update'])->name('settings.update');
