@props(['title' => config('app.name', 'Laravel')])

<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" x-data="{
    darkMode: localStorage.getItem('darkMode') === 'true' || (!('darkMode' in localStorage) && window.matchMedia('(prefers-color-scheme: dark)').matches),
    initDarkMode() {
        this.$watch('darkMode', val => {
            localStorage.setItem('darkMode', val);
            document.documentElement.classList.toggle('dark', val);
        });
        document.documentElement.classList.toggle('dark', this.darkMode); // Initial set
    }
}" x-init="initDarkMode()">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>{{ $title }} - {{ setting('site_name', config('app.name', 'Digital Vocano')) }}</title>
    @if(setting('site_favicon'))
    <link rel="icon" href="{{ Storage::url(setting('site_favicon')) }}" type="{{ image_mime_type(Storage::path(setting('site_favicon'))) }}">
    @endif

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />

    <!-- Styles & Scripts -->
    @vite(['resources/css/app.css', 'resources/js/app.js']) {{-- This usually points to main app assets --}}

    <!-- Styles -->
    @livewireStyles
    @stack('styles')
    <script>
        // Apply dark mode immediately to prevent FOUC
        if (localStorage.getItem('darkMode') === 'true' ||
            (!('darkMode' in localStorage) && window.matchMedia('(prefers-color-scheme: dark)').matches)) {
            document.documentElement.classList.add('dark');
        } else {
            document.documentElement.classList.remove('dark');
        }
    </script>
</head>
<body class="font-sans antialiased bg-gray-100 dark:bg-gray-900 text-gray-900 dark:text-gray-100">
    <div class="min-h-screen flex flex-col items-center justify-center pt-6 sm:pt-0">
        <div>
            {{-- You can add a logo here if needed --}}
        </div>
        <main class="w-full sm:max-w-2xl mt-6 px-6 py-8 bg-white dark:bg-gray-800 shadow-md overflow-hidden sm:rounded-lg">
            @include('layouts.partials.flash-messages') {{-- Assumes this partial exists in your main app's views --}}
            {{ $slot }} {{-- Content from views like my_companies.blade.php will be injected here --}}
        </main>
    </div>
    @stack('scripts')
    @livewireScripts
</body>
</html>