@extends('layouts.frontend') {{-- Your main frontend layout --}}

@section('title', $pageTitle ?? $tender->title)
@section('meta_description', $metaDescription ?? Str::limit(strip_tags($tender->description), 160))

@section('content')
<div class="bg-gray-100 dark:bg-gray-900">
    <!-- Company Hero Section (if company exists) -->
    @if($tender->company)
    <section class="relative mb-8">
        @if($tender->company->banner_url && $tender->company->banner_url !== asset('path/to/default-banner.png')) {{-- Replace with your actual default banner path check --}}
            <img src="{{ $tender->company->banner_url }}" alt="{{ $tender->company->name }} banner" class="w-full h-48 md:h-64 object-cover">
            <div class="absolute inset-0 bg-gradient-to-t from-black/50 via-black/20 to-transparent"></div>
        @else
            <div class="w-full h-48 md:h-64 bg-gradient-to-br from-slate-400 to-slate-600 dark:from-slate-700 dark:to-slate-800 flex items-center justify-center">
                {{-- Placeholder if no banner --}}
            </div>
        @endif
        <div class="absolute bottom-0 left-0 right-0 px-4 sm:px-6 lg:px-8 pb-4">
            <div class="container mx-auto">
                <div class="flex items-end space-x-4">
                    @if($tender->company->logo_url && $tender->company->logo_url !== asset('path/to/default-logo.png')) {{-- Replace with your actual default logo path check --}}
                        <img src="{{ $tender->company->logo_url }}" alt="{{ $tender->company->name }} logo" class="w-20 h-20 md:w-24 md:h-24 object-contain rounded-md bg-white dark:bg-gray-700 p-1 border-2 border-white dark:border-gray-600 shadow-lg -mb-8 md:-mb-10 relative z-10">
                    @else
                        <div class="flex items-center justify-center w-20 h-20 md:w-24 md:h-24 object-contain rounded-md bg-gray-200 dark:bg-gray-700 p-1 border-2 border-white dark:border-gray-600 shadow-lg -mb-8 md:-mb-10 relative z-10 text-gray-400 dark:text-gray-500">
                            <i class="fas fa-building text-3xl"></i>
                        </div>
                    @endif
                    <div>
                        <p class="text-sm text-gray-200 dark:text-gray-300 drop-shadow-sm">Tender by</p>
                        <h2 class="text-xl md:text-2xl font-semibold text-white drop-shadow-lg">
                            <a href="{{ active_public_route_url('companies.show', ['company' => $tender->company->slug]) }}" class="hover:underline">{{ $tender->company->name }}</a>
                        </h2>
                    </div>
                </div>
            </div>
        </div>
    </section>
    @endif

    <div class="container mx-auto px-4 sm:px-6 lg:px-8 pb-12 {{ $tender->company ? 'pt-8 md:pt-12' : 'pt-12' }}">  {{-- Adjust top padding if no company hero --}}
        <div class="lg:flex lg:space-x-8">
            <!-- Main Tender Content -->
            <div class="lg:w-2/3">
                <div class="bg-white dark:bg-gray-800 shadow-xl rounded-lg overflow-hidden">
                    <div class="p-6 md:p-8">
                        @if($tender->category)
                            <div class="mb-3">
                                <a href="{{-- active_public_route_url('tenders.index', ['category' => $tender->category->slug]) --}}" class="text-xs font-semibold uppercase tracking-wider text-purple-600 dark:text-purple-400 hover:underline">{{ $tender->category->name }}</a>
                            </div>
                        @endif
                        <h1 class="text-3xl md:text-4xl font-bold text-gray-900 dark:text-white mb-3">{{ $tender->title }}</h1>
                        @if(!$tender->company) {{-- Show company name here if no hero --}}
                            <p class="text-sm text-gray-500 dark:text-gray-400 mb-3"><i class="fas fa-building mr-1"></i> {{ $tender->company_name_fallback ?? 'A Reputable Organization' }}</p>
                        @endif

                        @if($tender->reference_number)
                            <p class="text-sm text-gray-500 dark:text-gray-400 mb-1">Reference: <span class="font-semibold text-gray-700 dark:text-gray-300">{{ $tender->reference_number }}</span></p>
                        @endif

                        <div class="flex flex-wrap items-center text-sm text-gray-500 dark:text-gray-400 mb-6 space-x-2 sm:space-x-4">
                            <span>
                                <i class="fas fa-calendar-alt mr-1.5"></i> Deadline: <span class="font-semibold text-gray-700 dark:text-gray-300">{{ $tender->deadline->format('F d, Y H:i A') }}</span> ({{ $tender->deadline->diffForHumans() }})
                            </span>
                            @if($tender->location)
                                <span>
                                    <i class="fas fa-map-marker-alt mr-1.5"></i> <span class="text-gray-700 dark:text-gray-300">{{ $tender->location }}</span>
                                </span>
                            @endif
                            @if($tender->type)
                                 <span>
                                    <i class="fas fa-briefcase mr-1.5"></i> Type: <span class="text-gray-700 dark:text-gray-300">{{ \Modules\BusinessDirectory\Entities\Tender::getTenderTypes()[$tender->type] ?? Str::title($tender->type) }}</span>
                                </span>
                            @endif
                        </div>

                        @if($tender->budget_min || $tender->budget_max)
                            <div class="mb-6 p-3 bg-indigo-50 dark:bg-indigo-900/30 rounded-md border border-indigo-200 dark:border-indigo-700">
                                <p class="text-sm font-semibold text-indigo-700 dark:text-indigo-300">
                                    <i class="fas fa-wallet mr-1.5"></i> Budget Range:
                                    <span class="text-indigo-800 dark:text-indigo-200">
                                        {{ $tender->budget_min ? ($tender->currency ?? setting('site_currency_symbol','$')) . number_format($tender->budget_min, 2) : 'Not Specified' }}
                                        @if($tender->budget_min && $tender->budget_max) - @endif
                                        {{ $tender->budget_max ? ($tender->currency ?? setting('site_currency_symbol','$')) . number_format($tender->budget_max, 2) : ($tender->budget_min ? '' : 'Not Specified') }}
                                    </span>
                                </p>
                            </div>
                        @endif

                        <div class="mb-8">
                            <h3 class="text-xl font-semibold text-gray-800 dark:text-white mb-3">Description</h3>
                            <div class="prose dark:prose-invert max-w-none text-gray-700 dark:text-gray-300">
                                {!! nl2br(e($tender->description)) !!}
                            </div>
                        </div>

                        @if($tender->requirements)
                            <div class="mb-8">
                                <h3 class="text-xl font-semibold text-gray-800 dark:text-white mb-3">Requirements</h3>
                                <div class="prose dark:prose-invert max-w-none text-gray-700 dark:text-gray-300">
                                    {!! nl2br(e($tender->requirements)) !!}
                                </div>
                            </div>
                        @endif

                        @if($tender->document_url)
                            <div class="mb-8">
                                <h3 class="text-xl font-semibold text-gray-800 dark:text-white mb-3">Main Tender Document</h3>
                                <a href="{{ $tender->document_url }}" target="_blank" download
                                   class="inline-flex items-center px-4 py-2 bg-blue-600 hover:bg-blue-700 text-white font-semibold rounded-md shadow-sm transition-colors duration-300">
                                    <i class="fas fa-file-download mr-2"></i>
                                    Download Tender Document
                                    @if($tender->document_path && Storage::disk('public')->exists($tender->document_path)) ({{ \Illuminate\Support\Number::fileSize(Storage::disk('public')->size($tender->document_path)) }}) @endif
                                </a>
                            </div>
                        @endif

                        @if($tender->additionalAttachments->isNotEmpty()) {{-- Use the new relationship name --}}
                            <div class="mb-8" id="additional-attachments">
                                <h3 class="text-xl font-semibold text-gray-800 dark:text-white mb-3">Additional Attachments</h3>
                                <ul class="space-y-2">
                                    @foreach($tender->additionalAttachments as $attachment) {{-- Use the new relationship name --}}
                                        <li class="flex items-center justify-between p-3 bg-gray-50 dark:bg-gray-700/50 rounded-md border dark:border-gray-600">
                                            <div class="flex items-center">
                                                <i class="fas fa-paperclip mr-3 text-gray-400 dark:text-gray-500"></i>
                                                <span class="text-sm text-gray-700 dark:text-gray-300">{{ $attachment->original_name }}</span>
                                                <span class="ml-2 text-xs text-gray-500 dark:text-gray-400">({{ $attachment->readable_size }})</span>
                                            </div>
                                            <a href="{{ $attachment->url }}" download="{{ $attachment->original_name }}"
                                               class="inline-flex items-center px-3 py-1.5 border border-transparent text-xs font-medium rounded-md shadow-sm text-white bg-gray-500 hover:bg-gray-600 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-gray-400 dark:focus:ring-offset-gray-800">
                                                <i class="fas fa-download mr-1.5"></i> Download
                                            </a>
                                        </li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif

                        @if($tender->status === \Modules\BusinessDirectory\Entities\Tender::STATUS_OPEN && $tender->deadline >= now())
                            <div id="bid-form" class="mt-8 pt-6 border-t border-gray-200 dark:border-gray-700">
                                <h3 class="text-2xl font-semibold text-gray-800 dark:text-white mb-4">Submit Your Bid</h3>
                                @auth
                                    @can('submitBid', $tender) {{-- Assuming a TenderPolicy with submitBid method --}}
                                        @include('businessdirectory::frontend.bids._form', ['tender' => $tender, 'bid' => new \Modules\BusinessDirectory\Entities\Bid(), 'userCompanies' => $userCompanies ?? collect()])
                                    @else
                                        <p class="text-sm text-yellow-600 dark:text-yellow-400 bg-yellow-50 dark:bg-yellow-900/30 p-3 rounded-md">
                                            <i class="fas fa-exclamation-triangle mr-2"></i>
                                            You cannot bid on your own tender or you may not have an eligible company profile.
                                        </p>
                                    @endcan
                                @else
                                    <p class="text-md text-gray-600 dark:text-gray-400">
                                        Please <a href="{{ route('login') }}?redirect={{ url()->current() }}#bid-form" class="text-blue-600 hover:underline font-semibold">login</a> or
                                        <a href="{{ route('register') }}?redirect={{ url()->current() }}#bid-form" class="text-blue-600 hover:underline font-semibold">register</a> to submit a bid.
                                    </p>
                                @endauth
                            </div>
                        @else
                            <div class="mt-8 pt-6 border-t border-gray-200 dark:border-gray-700">
                                 <p class="text-lg font-semibold text-red-600 dark:text-red-400 bg-red-50 dark:bg-red-900/30 p-4 rounded-md">
                                    <i class="fas fa-times-circle mr-2"></i> Bidding for this tender is closed.
                                 </p>
                            </div>
                        @endif
                    </div>
                </div>
            </div>

            <!-- Sidebar -->
            <aside class="lg:w-1/3 mt-8 lg:mt-0 space-y-6">
                @if($tender->company)
                <div class="bg-white dark:bg-gray-800 shadow-xl rounded-lg p-6">
                    <h3 class="text-xl font-semibold text-gray-800 dark:text-white mb-4 border-b dark:border-gray-700 pb-2">Posted By</h3>
                    <div class="flex items-center mb-3">
                        @if($tender->company->logo_url && $tender->company->logo_url !== asset('path/to/default-logo.png'))
                            <img src="{{ $tender->company->logo_url }}" alt="{{ $tender->company->name }} logo" class="h-16 w-16 mr-4 rounded-full object-contain border-2 border-gray-200 dark:border-gray-700">
                        @else
                            <span class="flex items-center justify-center h-16 w-16 mr-4 rounded-full bg-gray-200 dark:bg-gray-700 text-gray-400 dark:text-gray-500">
                                <i class="fas fa-building text-2xl"></i>
                            </span>
                        @endif
                        <div>
                            <a href="{{ active_public_route_url('companies.show', ['company' => $tender->company->slug]) }}" class="text-lg font-semibold text-blue-600 hover:text-blue-800 dark:text-blue-400 dark:hover:text-blue-300">
                                {{ $tender->company->name }}
                            </a>
                            <p class="text-sm text-gray-500 dark:text-gray-400">{{ $tender->company->companyType->name ?? 'Business' }}</p>
                        </div>
                    </div>
                    @if($tender->company->city || $tender->company->state_province)
                    <p class="text-sm text-gray-600 dark:text-gray-300">
                        <i class="fas fa-map-marker-alt mr-1.5 text-gray-400 dark:text-gray-500"></i>
                        {{ $tender->company->city ?? '' }}{{ ($tender->company->city && $tender->company->state_province) ? ', ' : '' }}{{ $tender->company->state_province ?? '' }}
                    </p>
                    @endif
                    <a href="{{ active_public_route_url('companies.show', ['company' => $tender->company->slug]) }}" class="mt-3 inline-block text-sm font-medium text-indigo-600 dark:text-indigo-400 hover:underline">
                        View Company Profile &rarr;
                    </a>
                </div>
                @endif

                <div class="bg-white dark:bg-gray-800 shadow-xl rounded-lg p-6">
                    <h3 class="text-xl font-semibold text-gray-800 dark:text-white mb-4 border-b dark:border-gray-700 pb-2">Tender Summary</h3>
                    <dl class="space-y-3 text-sm">
                        <div>
                            <dt class="font-medium text-gray-500 dark:text-gray-400">Status</dt>
                            <dd class="mt-1">
                                <span class="px-2 py-0.5 inline-flex text-xs leading-5 font-semibold rounded-full
                                    @if($tender->status == \Modules\BusinessDirectory\Entities\Tender::STATUS_OPEN && $tender->deadline >= now()) bg-green-100 text-green-800 dark:bg-green-700 dark:text-green-100
                                    @else bg-red-100 text-red-800 dark:bg-red-700 dark:text-red-100 @endif">
                                    {{ Str::title(str_replace('_', ' ', $tender->status)) }}
                                    @if($tender->status == \Modules\BusinessDirectory\Entities\Tender::STATUS_OPEN && $tender->deadline < now()) (Expired) @endif
                                </span>
                            </dd>
                        </div>
                        <div>
                            <dt class="font-medium text-gray-500 dark:text-gray-400">Bids Received</dt>
                            <dd class="mt-1 text-gray-900 dark:text-gray-100">{{ $tender->bids_count ?? $tender->bids->count() }}</dd>
                        </div>
                        <div>
                            <dt class="font-medium text-gray-500 dark:text-gray-400">Posted On</dt>
                            <dd class="mt-1 text-gray-900 dark:text-gray-100">{{ $tender->created_at->format('M d, Y') }}</dd>
                        </div>
                    </dl>
                </div>

                {{-- Social Share (Optional) --}}
                <div class="bg-white dark:bg-gray-800 shadow-xl rounded-lg p-6">
                    <h3 class="text-xl font-semibold text-gray-800 dark:text-white mb-4 border-b dark:border-gray-700 pb-2">Share this Tender</h3>
                    <div class="flex space-x-3">
                        @php $shareUrl = url()->current(); $shareTitle = $tender->title; @endphp
                        <a href="https://www.facebook.com/sharer/sharer.php?u={{ urlencode($shareUrl) }}" target="_blank" class="text-gray-400 hover:text-blue-600 dark:hover:text-blue-400 text-2xl" title="Share on Facebook"><i class="fab fa-facebook-square"></i></a>
                        <a href="https://twitter.com/intent/tweet?url={{ urlencode($shareUrl) }}&text={{ urlencode($shareTitle) }}" target="_blank" class="text-gray-400 hover:text-sky-500 dark:hover:text-sky-400 text-2xl" title="Share on Twitter"><i class="fab fa-twitter-square"></i></a>
                        <a href="https://www.linkedin.com/shareArticle?mini=true&url={{ urlencode($shareUrl) }}&title={{ urlencode($shareTitle) }}" target="_blank" class="text-gray-400 hover:text-blue-700 dark:hover:text-blue-500 text-2xl" title="Share on LinkedIn"><i class="fab fa-linkedin"></i></a>
                        <a href="https://wa.me/?text={{ urlencode($shareTitle . ' - ' . $shareUrl) }}" target="_blank" class="text-gray-400 hover:text-green-500 dark:hover:text-green-400 text-2xl" title="Share on WhatsApp"><i class="fab fa-whatsapp-square"></i></a>
                    </div>
                </div>

            </aside>
        </div>
    </div>
</div>
@endsection

@push('styles')
{{-- Add any specific styles for this page if needed --}}
@endpush

@push('scripts')
{{-- Add any specific scripts for this page if needed --}}
<script>
    // Example: Smooth scroll to bid form
    document.querySelectorAll('a[href="#bid-form"]').forEach(anchor => {
        anchor.addEventListener('click', function (e) {
            e.preventDefault();
            const targetElement = document.getElementById('bid-form');
            if (targetElement) {
                targetElement.scrollIntoView({ behavior: 'smooth' });
            }
        });
    });
</script>
@endpush
