@extends('layouts.frontend')

    @section('title', $pageTitle ?? __('Tenders'))
    @section('meta_description', $metaDescription ?? __('Browse and find the latest tender opportunities.'))

@section('content')
    @include('businessdirectory::frontend.partials._page_hero_search', [
        'title' => $pageTitle ?? __('Tender Listings'),
        'subtitle' => $metaDescription ?? __('Explore current tender opportunities and submit your bids.'),
        'searchActionRoute' => active_public_route_url('tenders.index'),
        'searchPlaceholder' => 'Search by tender title, category, or reference...',
        'showFilters' => true, // Set to true to show the "Advanced Filters" button
        'filterTargetId' => 'tender-filters' // ID of the filter section below
    ])

    <div class="py-12" id="tender-filters">
        <div class="container mx-auto px-4 sm:px-6 lg:px-8">
            <!-- Search/Filter Form -->
            <div class="mb-8 p-6 bg-white dark:bg-gray-800 shadow-xl rounded-lg">
                <h3 class="text-xl font-semibold text-gray-700 dark:text-gray-200 mb-4">Filter Tenders</h3>
                <form method="GET" action="{{ active_public_route_url('tenders.index') }}">
                    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-x-6 gap-y-4 items-end">
                        <div class="lg:col-span-1">
                            <label for="keywords" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Keywords</label>
                            <input type="text" name="keywords" id="keywords" value="{{ request('keywords') }}" placeholder="Title, description, company..."
                                   class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm">
                        </div>
                        <div class="lg:col-span-1">
                            <label for="location" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Location</label>
                            <input type="text" name="location" id="location" value="{{ request('location') }}" placeholder="e.g., City, Region"
                                   class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm">
                        </div>
                        <div class="lg:col-span-1">
                            <label for="category_id" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Category</label>
                            <select name="category_id" id="category_id"
                                    class="mt-1 block w-full pl-3 pr-10 py-2 text-base border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 focus:outline-none focus:ring-blue-500 focus:border-blue-500 sm:text-sm rounded-md">
                                <option value="">All Categories</option>
                                @foreach($categories ?? [] as $category) {{-- Ensure $categories is passed from controller --}}
                                    <option value="{{ $category->id }}" {{ request('category_id') == $category->id ? 'selected' : '' }}>{{ $category->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="lg:col-span-3 flex justify-end space-x-3 mt-4"> {{-- Buttons on their own row on large screens, spanning all columns --}}
                            <a href="{{ active_public_route_url('tenders.index') }}" class="px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-md text-sm font-medium text-gray-700 dark:text-gray-300 hover:bg-gray-50 dark:hover:bg-gray-700">Reset</a>
                            <button type="submit"
                                    class="bg-blue-600 hover:bg-blue-700 text-white font-semibold py-2 px-4 rounded-md shadow-sm focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                                Apply Filters
                            </button>
                        </div>
                    </div>
                </form>
            </div>

            @if($tenders->count() > 0)
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
                    @foreach($tenders as $tender)
                        <div class="bg-white dark:bg-gray-800 shadow-lg rounded-lg overflow-hidden hover:shadow-2xl transition-all duration-300 transform hover:-translate-y-1 flex flex-col group">
                            <div class="p-6 flex-grow flex flex-col">
                                <div class="mb-3">
                                    @if($tender->category)
                                        <span class="text-xs font-semibold uppercase tracking-wider text-purple-600 dark:text-purple-400">{{ $tender->category->name }}</span>
                                    @endif
                                </div>
                                <h3 class="text-xl font-bold text-gray-900 dark:text-white mb-2">
                                    <a href="{{ active_public_route_url('tenders.show', ['tender' => $tender->slug]) }}" class="hover:text-blue-600 dark:hover:text-blue-400">
                                        {{ $tender->title }}
                                    </a>
                                </h3>
                                @if($tender->company)
                                <p class="text-xs text-gray-500 dark:text-gray-400 mb-3">
                                    Posted by: <a href="{{ active_public_route_url('companies.show', ['company' => $tender->company->slug]) }}" class="hover:underline font-medium">{{ $tender->company->name }}</a>
                                </p>
                                @endif
                                <p class="text-gray-600 dark:text-gray-300 text-sm mb-4 line-clamp-3 flex-grow" title="{{ strip_tags($tender->description) }}">
                                    {{ Str::limit(strip_tags($tender->description), 120) }}
                                </p>
                                <div class="text-sm text-gray-500 dark:text-gray-400 mb-3">
                                    <i class="fas fa-calendar-alt mr-1.5 text-gray-400 dark:text-gray-500"></i> Deadline: <span class="font-semibold">{{ $tender->deadline->format('M d, Y') }}</span> ({{ $tender->deadline->diffForHumans() }})
                                </div>
                                @if($tender->location)
                                <div class="text-xs text-gray-500 dark:text-gray-400 mb-3 flex items-center">
                                    <i class="fas fa-map-marker-alt mr-1.5 text-gray-400 dark:text-gray-500"></i> {{ $tender->location }}
                                </div>
                                @endif
                                <div class="mt-auto pt-3 border-t border-gray-200 dark:border-gray-700">
                                    <a href="{{ active_public_route_url('tenders.show', ['tender' => $tender->slug]) }}" class="text-sm font-semibold text-indigo-600 dark:text-indigo-400 hover:text-indigo-500 dark:hover:text-indigo-300 transition-colors duration-200">
                                        View Details <i class="fas fa-arrow-right text-xs ml-1"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
                <div class="mt-8">
                    {{ $tenders->links() }}
                </div>
            @else
                <div class="text-center py-12">
                    <i class="fas fa-file-signature fa-3x text-gray-400 dark:text-gray-500 mb-3"></i>
                    <p class="text-xl text-gray-600 dark:text-gray-300">No tenders found matching your criteria.</p>
                    <p class="text-gray-500 dark:text-gray-400 mt-2">Try adjusting your search terms or filters, or check back later!</p>
                </div>
            @endif
        </div>
    </div>
@endsection