{{--
    This partial expects:
    - $tender: The tender model instance (new Tender() for create, existing for edit)
    - $userCompanies: Collection of user's approved companies (id => name)
    - $isEdit: (Optional) boolean, true if editing, defaults to false.
--}}
<div class="space-y-6">
    <div>
        <label for="title" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Tender Title <span class="text-red-500">*</span></label>
        <input type="text" name="title" id="title" value="{{ old('title', $tender->title ?? '') }}" required
               class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm @error('title') border-red-500 @enderror">
        @error('title') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
    </div>

    <div>
        <label for="company_id" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Posting Company <span class="text-red-500">*</span></label>
        <select name="company_id" id="company_id" required {{ ($isEdit ?? false) ? 'disabled' : '' }}
                class="mt-1 block w-full pl-3 pr-10 py-2 text-base border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 focus:outline-none focus:ring-blue-500 focus:border-blue-500 sm:text-sm rounded-md @error('company_id') border-red-500 @enderror {{ ($isEdit ?? false) ? 'bg-gray-100 dark:bg-gray-600 cursor-not-allowed' : '' }}">
            <option value="">Select Company</option>
            @foreach($userCompanies as $id => $name)
                <option value="{{ $id }}" {{ (old('company_id', $tender->company_id ?? '') == $id) ? 'selected' : '' }}>
                    {{ $name }}
                </option>
            @endforeach
        </select>
        @if(($isEdit ?? false))
            <input type="hidden" name="company_id" value="{{ $tender->company_id }}">
            <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">Company cannot be changed after posting.</p>
        @endif
        @error('company_id') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
    </div>

    <div>
        <label for="description" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Description <span class="text-red-500">*</span></label>
        <textarea name="description" id="description" rows="6" required
                  class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm @error('description') border-red-500 @enderror">{{ old('description', $tender->description ?? '') }}</textarea>
        @error('description') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
    </div>

    <div>
        <label for="requirements" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Requirements (Optional)</label>
        <textarea name="requirements" id="requirements" rows="4"
                  class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm @error('requirements') border-red-500 @enderror">{{ old('requirements', $tender->requirements ?? '') }}</textarea>
        @error('requirements') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
    </div>

    <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
        <div>
            <label for="budget_min" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Min Budget (Optional)</label>
            <input type="number" name="budget_min" id="budget_min" value="{{ old('budget_min', $tender->budget_min ?? '') }}" step="0.01"
                   class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm @error('budget_min') border-red-500 @enderror">
            @error('budget_min') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
        </div>
        <div>
            <label for="budget_max" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Max Budget (Optional)</label>
            <input type="number" name="budget_max" id="budget_max" value="{{ old('budget_max', $tender->budget_max ?? '') }}" step="0.01"
                   class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm @error('budget_max') border-red-500 @enderror">
            @error('budget_max') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
        </div>
        <div>
            <label for="currency" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Currency (e.g., USD)</label>
            <input type="text" name="currency" id="currency" value="{{ old('currency', $tender->currency ?? 'USD') }}" maxlength="3"
                   class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm @error('currency') border-red-500 @enderror">
            @error('currency') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
        </div>
    </div>

    <div>
        <label for="deadline" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Bidding Deadline <span class="text-red-500">*</span></label>
        <input type="date" name="deadline" id="deadline" value="{{ old('deadline', isset($tender->deadline) ? $tender->deadline->format('Y-m-d') : '') }}" required
               class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm @error('deadline') border-red-500 @enderror">
        @error('deadline') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
    </div>

    {{-- Attachments Section --}}
    <div class="pt-6 mt-6 border-t border-gray-200 dark:border-gray-700">
        <h3 class="text-lg font-medium leading-6 text-gray-900 dark:text-gray-100">Attachments</h3>
        <p class="mt-1 text-sm text-gray-500 dark:text-gray-400">Upload any relevant documents (PDF, DOC, DOCX, XLS, XLSX, PPT, PPTX, TXT, JPG, PNG, ZIP). Max 5MB per file.</p>

        @if(($isEdit ?? false) && $tender->attachments && $tender->attachments->isNotEmpty())
            <div class="mt-4">
                <h4 class="text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Current Attachments:</h4>
                <ul class="list-disc list-inside space-y-1">
                    @foreach($tender->attachments as $attachment)
                        <li class="text-sm text-gray-600 dark:text-gray-400">
                            <a href="{{ $attachment->url }}" target="_blank" class="text-blue-600 dark:text-blue-400 hover:underline">{{ $attachment->original_name }}</a>
                            ({{ $attachment->readable_size }})
                            {{-- TODO: Implement Delete Attachment Functionality --}}
                            {{-- <button type="button" class="ml-2 text-red-500 hover:text-red-700 text-xs" onclick="deleteAttachment({{ $attachment->id }})">Delete</button> --}}
                        </li>
                    @endforeach
                </ul>
            </div>
        @endif

        <div class="mt-4">
            <label for="attachments" class="block text-sm font-medium text-gray-700 dark:text-gray-300">{{ ($isEdit ?? false) ? 'Add More Attachments' : 'Upload Attachments' }}</label>
            <input type="file" name="attachments[]" id="attachments" multiple
                   class="mt-1 block w-full text-sm text-gray-500 dark:text-gray-400
                          file:mr-4 file:py-2 file:px-4
                          file:rounded-md file:border-0
                          file:text-sm file:font-semibold
                          file:bg-blue-50 dark:file:bg-blue-800 file:text-blue-700 dark:file:text-blue-200
                          hover:file:bg-blue-100 dark:hover:file:bg-blue-700
                          @error('attachments') border-red-500 @enderror @error('attachments.*') border-red-500 @enderror">
            @error('attachments') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
            @error('attachments.*') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
        </div>
    </div>

    <div class="pt-8">
        <div class="flex justify-end space-x-3">
            <a href="{{ route('frontend.businessdirectory.my-tenders.index') }}"
               class="bg-white dark:bg-gray-700 py-2 px-4 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm text-sm font-medium text-gray-700 dark:text-gray-200 hover:bg-gray-50 dark:hover:bg-gray-600 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                Cancel
            </a>
            <button type="submit"
                    class="inline-flex justify-center py-2 px-4 border border-transparent shadow-sm text-sm font-medium rounded-md text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 dark:focus:ring-offset-gray-800">
                {{ ($isEdit ?? false) ? 'Update Tender' : 'Post Tender' }}
            </button>
        </div>
    </div>
</div>