{{--
    This partial expects the following variables:
    - $company: The Company model instance being reviewed.
--}}

@auth
    @php
        // Check if the user has already reviewed this company
        $existingReview = \Modules\BusinessDirectory\Entities\Review::where('company_id', $company->id)
                                ->where('user_id', Auth::id())
                                ->first();
    @endphp

    @if($existingReview)
        <div class="bg-blue-100 border-l-4 border-blue-500 text-blue-700 p-4 rounded-md mb-6" role="alert">
            <p class="font-bold">Review Submitted</p>
            <p>You've already reviewed this company. Thank you for your feedback!</p>
            {{-- Optionally, allow editing the existing review if your system supports it --}}
            {{-- <a href="#" class="text-sm text-blue-600 hover:underline mt-1 inline-block">Edit your review</a> --}}
        </div>
    @else
        <div class="bg-white shadow-md rounded-lg p-6 mb-8">
            <h3 class="text-xl font-semibold text-gray-800 mb-4">Write a Review for {{ $company->name }}</h3>
            <form action="{{ route('frontend.businessdirectory.companies.reviews.store', $company->slug) }}" method="POST">
                @csrf
                <div class="space-y-4">
                    <div>
                        <label for="rating" class="block text-sm font-medium text-gray-700">Your Rating <span class="text-red-500">*</span></label>
                        <div class="mt-1 flex items-center space-x-1" x-data="{ rating: {{ old('rating', 0) }}, hoverRating: 0 }">
                            @for ($i = 1; $i <= 5; $i++)
                                <button type="button"
                                        @click="rating = {{ $i }}"
                                        @mouseenter="hoverRating = {{ $i }}"
                                        @mouseleave="hoverRating = 0"
                                        class="text-2xl focus:outline-none"
                                        :class="{
                                            'text-yellow-400': hoverRating >= {{ $i }} || rating >= {{ $i }},
                                            'text-gray-300': !(hoverRating >= {{ $i }} || rating >= {{ $i }})
                                        }">
                                    <i class="fas fa-star"></i>
                                </button>
                            @endfor
                            <input type="hidden" name="rating" x-model="rating">
                        </div>
                        @error('rating') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
                    </div>

                    <div>
                        <label for="title" class="block text-sm font-medium text-gray-700">Review Title (Optional)</label>
                        <input type="text" name="title" id="title" value="{{ old('title') }}"
                               class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm @error('title') border-red-500 @enderror"
                               placeholder="e.g., Excellent Service!">
                        @error('title') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
                    </div>

                    <div>
                        <label for="comment" class="block text-sm font-medium text-gray-700">Your Review <span class="text-red-500">*</span></label>
                        <textarea name="comment" id="comment" rows="5" required
                                  class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm @error('comment') border-red-500 @enderror"
                                  placeholder="Share your experience with this company...">{{ old('comment') }}</textarea>
                        @error('comment') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
                    </div>

                    <div>
                        <button type="submit"
                                class="w-full sm:w-auto inline-flex justify-center items-center px-6 py-2 border border-transparent text-base font-medium rounded-md shadow-sm text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                            Submit Review
                        </button>
                    </div>
                </div>
            </form>
        </div>
    @endif
@else
    <div class="bg-gray-100 border-l-4 border-gray-500 text-gray-700 p-4 rounded-md mb-6" role="alert">
        <p>Please <a href="{{ route('login') }}" class="font-semibold text-blue-600 hover:underline">log in</a> or <a href="{{ route('register') }}" class="font-semibold text-blue-600 hover:underline">register</a> to leave a review.</p>
    </div>
@endauth