{{--
    This partial expects the following variables:
    - $company: The Company model instance whose reviews are being displayed.
    - $reviews: A paginated collection of approved Review Entities for the company.
               (e.g., $company->reviews()->approved()->latest()->paginate(5))
--}}

<div class="mt-10">
    <h3 class="text-2xl font-semibold text-gray-800 mb-6">Customer Reviews ({{ $reviews->total() }})</h3>

    @if($reviews->isNotEmpty())
        <div class="space-y-8">
            @foreach($reviews as $review)
                <div class="bg-white shadow-sm rounded-lg p-6 border border-gray-200">
                    <div class="flex items-start space-x-4">
                        {{-- User Avatar Placeholder --}}
                        <div class="flex-shrink-0">
                            <span class="inline-flex items-center justify-center h-10 w-10 rounded-full bg-blue-100">
                                <span class="font-medium text-blue-700">{{ strtoupper(substr($review->user->name ?? 'U', 0, 1)) }}</span>
                            </span>
                        </div>
                        <div class="flex-1">
                            <div class="flex items-center justify-between">
                                <p class="text-sm font-semibold text-gray-900">{{ $review->user->name ?? 'Anonymous User' }}</p>
                                <p class="text-xs text-gray-500">{{ $review->created_at->format('M d, Y') }}</p>
                            </div>
                            <div class="flex items-center mt-1">
                                @for ($i = 1; $i <= 5; $i++)
                                    <i class="fas fa-star text-sm {{ $i <= $review->rating ? 'text-yellow-400' : 'text-gray-300' }}"></i>
                                @endfor
                                @if($review->title)
                                    <span class="ml-3 text-sm font-medium text-gray-700">{{ $review->title }}</span>
                                @endif
                            </div>
                            <div class="mt-3 text-gray-600 text-sm leading-relaxed prose prose-sm max-w-none">
                                {!! nl2br(e($review->comment)) !!}
                            </div>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>

        @if ($reviews->hasPages())
            <div class="mt-8">
                {{ $reviews->links() }} {{-- Standard Laravel Pagination --}}
            </div>
        @endif
    @else
        <div class="bg-white shadow-sm rounded-lg p-6 border border-gray-200 text-center">
            <i class="fas fa-comment-slash fa-2x text-gray-400 mb-3"></i>
            <p class="text-gray-600">This company has no reviews yet.</p>
            @auth
                <p class="text-sm text-gray-500 mt-1">Be the first to share your experience!</p>
            @else
                <p class="text-sm text-gray-500 mt-1">Log in to leave a review.</p>
            @endauth
        </div>
    @endif
</div>