<x-app-layout>
    @section('title', __('Project Details: ') . $project->name)

    <x-slot name="header">
        <div class="flex flex-col md:flex-row md:items-center md:justify-between">
            <h2 class="text-xl font-semibold leading-tight text-gray-800 dark:text-gray-200">
                {{ __('Project Details: ') }} <span class="text-purple-600 dark:text-purple-400">{{ $project->name }}</span>
            </h2>
            <a href="{{ route('frontend.businessdirectory.my-projects.index') }}" class="mt-4 md:mt-0 px-4 py-2 text-sm font-medium tracking-wide text-gray-700 dark:text-gray-300 capitalize transition-colors duration-300 transform bg-gray-200 dark:bg-gray-700 rounded-md hover:bg-gray-300 dark:hover:bg-gray-600 focus:outline-none focus:ring focus:ring-gray-300 focus:ring-opacity-50 inline-flex items-center">
                <i class="fas fa-arrow-left mr-2"></i> {{ __('Back to My Projects') }}
            </a>
        </div>
    </x-slot>

    <div class="py-8">
        <div class="container mx-auto px-4 sm:px-6 lg:px-8">
            <div class="bg-white dark:bg-gray-800 shadow-xl rounded-lg overflow-hidden">
                {{-- Project Header --}}
                <div class="bg-purple-700 dark:bg-purple-800 p-6 text-white">
                    <div class="flex flex-col md:flex-row md:items-center md:justify-between">
                        <h1 class="text-3xl font-bold">{{ $project->name }}</h1>
                        <a href="{{ route('frontend.businessdirectory.my-projects.edit', $project->id) }}" class="mt-3 md:mt-0 bg-white hover:bg-purple-100 text-purple-700 font-semibold py-2 px-4 rounded-md shadow-sm text-sm inline-flex items-center">
                            <i class="fas fa-edit mr-2"></i> Edit Project
                        </a>
                    </div>
                    <p class="text-sm text-purple-200 dark:text-purple-300 mt-1">Company: {{ $project->company->name ?? 'N/A' }}</p>
                </div>

                {{-- Project Details --}}
                <div class="p-6 grid grid-cols-1 md:grid-cols-3 gap-6">
                    <div>
                        <h3 class="text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wider">Status</h3>
                        <p class="mt-1 text-lg font-medium text-gray-900 dark:text-gray-100">
                             <span class="px-3 py-1 inline-flex text-sm leading-5 font-semibold rounded-full
                                @if($project->status == 'completed') bg-green-100 text-green-800 dark:bg-green-700 dark:text-green-100
                                @elseif($project->status == 'in_progress') bg-blue-100 text-blue-800 dark:bg-blue-700 dark:text-blue-100
                                @elseif($project->status == 'planning') bg-yellow-100 text-yellow-800 dark:bg-yellow-700 dark:text-yellow-100
                                @elseif($project->status == 'on_hold') bg-orange-100 text-orange-800 dark:bg-orange-700 dark:text-orange-100
                                @elseif($project->status == 'cancelled') bg-red-100 text-red-800 dark:bg-red-700 dark:text-red-100
                                @else bg-gray-100 text-gray-800 dark:bg-gray-700 dark:text-gray-100 @endif">
                                {{ Str::title(str_replace('_', ' ', $project->status)) }}
                            </span>
                        </p>
                    </div>
                    <div>
                        <h3 class="text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wider">Start Date</h3>
                        <p class="mt-1 text-lg text-gray-900 dark:text-gray-100">{{ $project->start_date ? $project->start_date->format('M d, Y') : 'Not Set' }}</p>
                    </div>
                    <div>
                        <h3 class="text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wider">End Date</h3>
                        <p class="mt-1 text-lg text-gray-900 dark:text-gray-100">{{ $project->end_date ? $project->end_date->format('M d, Y') : 'Not Set' }}</p>
                    </div>
                </div>

                @if($project->description)
                <div class="px-6 pb-6 border-t border-gray-200 dark:border-gray-700">
                    <h3 class="text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wider mt-4">Description</h3>
                    <p class="mt-1 text-sm text-gray-700 dark:text-gray-300 leading-relaxed">{{ $project->description }}</p>
                </div>
                @endif

                {{-- Tasks Section --}}
                <div class="px-6 py-6 border-t border-gray-200 dark:border-gray-700">
                    <div class="flex flex-col md:flex-row md:items-center md:justify-between mb-4">
                        <h2 class="text-xl font-semibold text-gray-800 dark:text-gray-100">Tasks ({{ $project->tasks->count() }})</h2>
                        <a href="{{ route('frontend.businessdirectory.my-projects.tasks.create', $project->id) }}" class="mt-3 md:mt-0 bg-green-500 hover:bg-green-600 text-white font-semibold py-2 px-3 rounded-md shadow-sm text-sm inline-flex items-center">
                            <i class="fas fa-plus-circle mr-2"></i> Add New Task
                        </a>
                    </div>

                    @if($project->tasks->isNotEmpty())
                        <div class="space-y-4">
                            @foreach($project->tasks as $task)
                                <div class="bg-gray-50 dark:bg-gray-700/50 p-4 rounded-lg shadow hover:shadow-md transition-shadow duration-200">
                                    <div class="flex justify-between items-start">
                                        <h4 class="font-semibold text-gray-700 dark:text-gray-200">{{ $task->title }}</h4>
                                        <div class="text-xs space-x-2">
                                            <a href="{{ route('frontend.businessdirectory.my-projects.tasks.edit', [$project->id, $task->id]) }}" class="text-blue-500 dark:text-blue-400 hover:text-blue-700 dark:hover:text-blue-300"><i class="fas fa-edit"></i></a>
                                            <form action="{{ route('frontend.businessdirectory.my-projects.tasks.destroy', [$project->id, $task->id]) }}" method="POST" class="inline-block" onsubmit="return confirm('Are you sure you want to delete this task?');">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="text-red-500 dark:text-red-400 hover:text-red-700 dark:hover:text-red-300"><i class="fas fa-trash"></i></button>
                                            </form>
                                        </div>
                                    </div>
                                    @if($task->description)
                                        <p class="text-sm text-gray-600 dark:text-gray-300 mt-1">{{ Str::limit($task->description, 100) }}</p>
                                    @endif
                                    <div class="mt-2 text-xs text-gray-500 dark:text-gray-400 flex flex-wrap gap-x-4 gap-y-1">
                                        <span>
                                            Status:
                                            <span class="font-medium px-1.5 py-0.5 rounded-full text-xs
                                                @if($task->status == 'completed') bg-green-100 text-green-700 dark:bg-green-700 dark:text-green-100
                                                @elseif($task->status == 'in_progress') bg-blue-100 text-blue-700 dark:bg-blue-700 dark:text-blue-100
                                                @elseif($task->status == 'todo') bg-yellow-100 text-yellow-700 dark:bg-yellow-700 dark:text-yellow-100
                                                @else bg-gray-200 text-gray-600 dark:bg-gray-600 dark:text-gray-300 @endif">
                                                {{ Str::title(str_replace('_', ' ', $task->status)) }}
                                            </span>
                                        </span>
                                        @if($task->due_date)
                                            <span>Due: <span class="font-medium">{{ $task->due_date->format('M d, Y') }}</span></span>
                                        @endif
                                        @if($task->assignee)
                                            <span>Assignee: <span class="font-medium">{{ $task->assignee->name }}</span></span>
                                        @endif
                                        @if($task->priority)
                                            <span>Priority: <span class="font-medium">{{ Str::title($task->priority) }}</span></span>
                                        @endif
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    @else
                        <div class="text-center py-6 text-gray-500 dark:text-gray-400">
                            <i class="fas fa-tasks fa-2x mb-2"></i>
                            <p>No tasks have been added to this project yet.</p>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
