<x-app-layout>
    @section('title', __('My Company Projects'))

    <x-slot name="header">
        <div class="flex flex-col md:flex-row md:items-center md:justify-between">
            <h2 class="text-xl font-semibold leading-tight text-gray-800 dark:text-gray-200">
                {{ __('My Company Projects') }}
            </h2>
            <a href="{{ route('frontend.businessdirectory.my-projects.create') }}" class="mt-4 md:mt-0 px-4 py-2 text-sm font-medium tracking-wide text-white capitalize transition-colors duration-300 transform bg-purple-600 rounded-md hover:bg-purple-500 focus:outline-none focus:ring focus:ring-purple-300 focus:ring-opacity-50 inline-flex items-center">
                <i class="fas fa-project-diagram mr-2"></i> {{ __('Create New Project') }}
            </a>
        </div>
    </x-slot>

    <div class="py-8">
        <div class="container mx-auto px-4 sm:px-6 lg:px-8">
            {{-- Session messages are handled by app.blade.php --}}

            {{-- Search and Filter Form --}}
            <form method="GET" action="{{ route('frontend.businessdirectory.my-projects.index') }}" class="mb-8 p-6 bg-white dark:bg-gray-800 shadow-md rounded-lg">
                <div class="grid grid-cols-1 md:grid-cols-3 gap-4 items-end">
                    <div>
                        <label for="search" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Search by Project Name</label>
                        <input type="text" name="search" id="search" value="{{ request('search') }}"
                               class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 rounded-md shadow-sm focus:ring-purple-500 focus:border-purple-500 sm:text-sm"
                               placeholder="e.g., New Website Launch">
                    </div>
                    @php
                        $user = Auth::user();
                        $userCompanies = $user->companies()->where('status', 'approved')->orderBy('name')->pluck('name', 'id');
                    @endphp
                    @if($userCompanies->count() > 1)
                    <div>
                        <label for="company_id" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Company</label>
                        <select name="company_id" id="company_id"
                                class="mt-1 block w-full pl-3 pr-10 py-2 text-base border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 focus:outline-none focus:ring-purple-500 focus:border-purple-500 sm:text-sm rounded-md">
                            <option value="">All My Companies</option>
                            @foreach($userCompanies as $id => $name)
                                <option value="{{ $id }}" {{ request('company_id') == $id ? 'selected' : '' }}>{{ $name }}</option>
                            @endforeach
                        </select>
                    </div>
                    @endif
                    <div>
                        <label for="status" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Status</label>
                        <select name="status" id="status"
                                class="mt-1 block w-full pl-3 pr-10 py-2 text-base border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 focus:outline-none focus:ring-purple-500 focus:border-purple-500 sm:text-sm rounded-md">
                            <option value="">All Statuses</option>
                            @php
                                $projectStatuses = ['planning' => 'Planning', 'in_progress' => 'In Progress', 'completed' => 'Completed', 'on_hold' => 'On Hold', 'cancelled' => 'Cancelled', 'draft' => 'Draft'];
                            @endphp
                            @foreach($projectStatuses as $key => $value)
                                <option value="{{ $key }}" {{ request('status') == $key ? 'selected' : '' }}>{{ $value }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="mt-4 text-right">
                    <button type="submit"
                            class="bg-purple-600 hover:bg-purple-700 text-white font-semibold py-2 px-4 rounded-md shadow-sm focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-purple-500">
                        Filter Projects
                    </button>
                </div>
            </form>

            @if($projects && $projects->count() > 0)
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                    @foreach($projects as $project)
                        <div class="bg-white dark:bg-gray-800 shadow-lg rounded-lg p-6 flex flex-col justify-between">
                            <div>
                                <h3 class="text-xl font-semibold text-purple-700 dark:text-purple-400 mb-2">
                                    <a href="{{ route('frontend.businessdirectory.my-projects.show', $project->id) }}" class="hover:underline">
                                        {{ $project->name }}
                                    </a>
                                </h3>
                                <p class="text-xs text-gray-500 dark:text-gray-400 mb-1">Company: {{ $project->company->name ?? 'N/A' }}</p>
                                <p class="text-sm text-gray-600 dark:text-gray-300 mb-3 line-clamp-3">{{ $project->description ?? 'No description provided.' }}</p>
                                <div class="text-xs text-gray-500 dark:text-gray-400 mb-3">
                                    <span class="font-medium">Status:</span>
                                    <span class="px-2 py-0.5 inline-flex text-xs leading-5 font-semibold rounded-full
                                        @if($project->status == 'completed') bg-green-100 text-green-800 dark:bg-green-700 dark:text-green-100
                                        @elseif($project->status == 'in_progress') bg-blue-100 text-blue-800 dark:bg-blue-700 dark:text-blue-100
                                        @elseif($project->status == 'planning') bg-yellow-100 text-yellow-800 dark:bg-yellow-700 dark:text-yellow-100
                                        @elseif($project->status == 'on_hold') bg-orange-100 text-orange-800 dark:bg-orange-700 dark:text-orange-100
                                        @elseif($project->status == 'cancelled') bg-red-100 text-red-800 dark:bg-red-700 dark:text-red-100
                                        @else bg-gray-100 text-gray-800 dark:bg-gray-700 dark:text-gray-100 @endif">
                                        {{ Str::title(str_replace('_', ' ', $project->status)) }}
                                    </span>
                                </div>
                                <div class="text-xs text-gray-500 dark:text-gray-400">
                                    @if($project->start_date)
                                        <span>Start: {{ $project->start_date->format('M d, Y') }}</span>
                                    @endif
                                    @if($project->end_date)
                                        <span class="ml-2">End: {{ $project->end_date->format('M d, Y') }}</span>
                                    @endif
                                </div>
                                 <p class="text-xs text-gray-500 dark:text-gray-400 mt-1">Tasks: {{ $project->tasks_count ?? $project->tasks()->count() }}</p>
                            </div>
                            <div class="mt-4 pt-4 border-t border-gray-200 dark:border-gray-700 flex items-center justify-between">
                                <a href="{{ route('frontend.businessdirectory.my-projects.show', $project->id) }}" class="text-sm text-purple-600 dark:text-purple-400 hover:text-purple-800 dark:hover:text-purple-300 font-medium">
                                    View Details <i class="fas fa-arrow-right ml-1"></i>
                                </a>
                                <div>
                                    <a href="{{ route('frontend.businessdirectory.my-projects.edit', $project->id) }}" class="text-sm text-blue-600 dark:text-blue-400 hover:text-blue-800 dark:hover:text-blue-300 mr-2"><i class="fas fa-edit"></i></a>
                                    <form action="{{ route('frontend.businessdirectory.my-projects.destroy', $project->id) }}" method="POST" class="inline-block" onsubmit="return confirm('Are you sure you want to delete this project and all its tasks?');">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="text-sm text-red-600 dark:text-red-400 hover:text-red-800 dark:hover:text-red-300"><i class="fas fa-trash"></i></button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
                @if($projects->hasPages())
                <div class="mt-8">
                    {{ $projects->appends(request()->query())->links() }}
                </div>
                @endif
            @else
                <div class="text-center py-12 bg-white dark:bg-gray-800 shadow-md rounded-lg">
                    <i class="fas fa-folder-open fa-3x text-gray-400 dark:text-gray-500 mb-3"></i>
                    <p class="text-xl text-gray-600 dark:text-gray-300">You haven't created any projects yet.</p>
                    <a href="{{ route('frontend.businessdirectory.my-projects.create') }}" class="mt-4 inline-block bg-purple-600 hover:bg-purple-700 text-white font-semibold py-2 px-4 rounded-md">Create Your First Project</a>
                </div>
            @endif
        </div>
    </div>
</x-app-layout>
