@extends('layouts.frontend')

    @section('title', $pageTitle ?? __('Products'))
    @section('meta_description', $metaDescription ?? __('Browse our wide range of products.'))

@section('content')
    @include('businessdirectory::frontend.partials._page_hero_search', [
        'title' => $pageTitle ?? __('Product Marketplace'),
        'subtitle' => $metaDescription ?? __('Discover a wide variety of products from our trusted sellers.'),
        'searchActionRoute' => active_public_route_url('products.index'),
        'searchPlaceholder' => 'Search by product name, SKU, category...',
        'showFilters' => true, // Set to true to show the "Advanced Filters" button
        'filterTargetId' => 'product-filters' // ID of the filter section below
    ])

    <div class="py-12" id="product-filters">
        <div class="container mx-auto px-4 sm:px-6 lg:px-8">
            <!-- Search/Filter Form -->
            <div class="mb-8 p-6 bg-white dark:bg-gray-800 shadow-xl rounded-lg">
                <h3 class="text-xl font-semibold text-gray-700 dark:text-gray-200 mb-4">Filter Products</h3>
                <form method="GET" action="{{ active_public_route_url('products.index') }}">
                    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-x-6 gap-y-4 items-end">
                        <div class="lg:col-span-1">
                            <label for="search" class="sr-only">Search Products</label>
                            <input type="text" name="search" id="search" value="{{ request('search') }}" placeholder="Product name, SKU..."
                                   class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm">
                        </div>
                        <div class="lg:col-span-1">
                            <label for="category_id" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Category</label>
                            <select name="category_id" id="category_id"
                                    class="mt-1 block w-full pl-3 pr-10 py-2 text-base border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 focus:outline-none focus:ring-blue-500 focus:border-blue-500 sm:text-sm rounded-md">
                                <option value="">All Categories</option>
                                {{-- @foreach($categories ?? [] as $category)
                                    <option value="{{ $category->id }}" {{ request('category_id') == $category->id ? 'selected' : '' }}>{{ $category->name }}</option>
                                @endforeach --}}
                            </select>
                        </div>
                        <div class="lg:col-span-1 flex justify-end space-x-3 self-end">
                            <a href="{{ active_public_route_url('products.index') }}" class="px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-md text-sm font-medium text-gray-700 dark:text-gray-300 hover:bg-gray-50 dark:hover:bg-gray-700">Reset</a>
                            <button type="submit"
                                    class="bg-blue-600 hover:bg-blue-700 text-white font-semibold py-2 px-4 rounded-md shadow-sm focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                                Apply Filters
                            </button>
                        </div>
                    </div>
                </form>
            </div>

            @if($products->count() > 0)
                <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-6">
                    @foreach($products as $product)
                        <div class="bg-white dark:bg-gray-800 rounded-xl shadow-lg overflow-hidden group transition-all duration-300 hover:shadow-2xl flex flex-col">
                            <a href="{{ active_public_route_url('products.show', ['product' => $product->slug]) }}" class="block">
                                <div class="relative overflow-hidden">
                                    <img class="w-full h-56 object-cover transform group-hover:scale-105 transition-transform duration-300"
                                         src="{{ $product->featured_image_url_public ?? asset(config('businessdirectory.default_product_image_path', 'images/defaults/product_image.png')) }}"
                                         alt="{{ $product->name }}">
                                    @if($product->sale_price && $product->sale_price < $product->price)
                                        <span class="absolute top-2 right-2 bg-red-500 text-white text-xs font-semibold px-2 py-1 rounded">SALE</span>
                                    @endif
                                </div>
                            </a>
                            <div class="p-5 flex-grow flex flex-col">
                                <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-1 truncate" title="{{ $product->name }}">
                                    <a href="{{ active_public_route_url('products.show', ['product' => $product->slug]) }}" class="hover:text-blue-600 dark:hover:text-blue-400">{{ $product->name }}</a>
                                </h3>
                                <p class="text-xs text-gray-500 dark:text-gray-400 mb-2">
                                    By: <a href="{{ active_public_route_url('companies.show', ['company' => $product->company->slug]) }}" class="hover:underline">{{ $product->company->name ?? 'N/A' }}</a>
                                </p>
                                <div class="mt-auto">
                                    <p class="text-xl font-bold text-purple-600 dark:text-purple-400">
                                        {{ setting('site_currency_symbol', '$') }}{{ number_format($product->sale_price ?? $product->price, 2) }}
                                        @if($product->sale_price && $product->sale_price < $product->price)
                                            <span class="text-sm text-gray-400 line-through ml-1">{{ setting('site_currency_symbol', '$') }}{{ number_format($product->price, 2) }}</span>
                                        @endif
                                    </p>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
                <div class="mt-8">
                    {{ $products->links() }}
                </div>
            @else
                <div class="text-center py-12">
                    <i class="fas fa-box-open fa-3x text-gray-400 dark:text-gray-500 mb-3"></i>
                    <p class="text-xl text-gray-600 dark:text-gray-300">No products found matching your criteria.</p>
                    <p class="text-gray-500 dark:text-gray-400 mt-2">Try adjusting your search terms or filters, or check back later!</p>
                </div>
            @endif
        </div>
    </div>
@endsection