<x-app-layout>
    @section('title', __('Edit Product: ') . $product->name)

    <x-slot name="header">
        <div class="flex flex-col md:flex-row md:items-center md:justify-between">
            <h2 class="text-xl font-semibold leading-tight text-gray-800 dark:text-gray-200">
                {{ __('Edit Product: ') }} <span class="text-indigo-600 dark:text-indigo-400">{{ $product->name }}</span>
            </h2>
             <a href="{{ route('frontend.businessdirectory.my-products.index') }}" class="mt-4 md:mt-0 px-4 py-2 text-sm font-medium tracking-wide text-gray-700 dark:text-gray-300 capitalize transition-colors duration-300 transform bg-gray-200 dark:bg-gray-700 rounded-md hover:bg-gray-300 dark:hover:bg-gray-600 focus:outline-none focus:ring focus:ring-gray-300 focus:ring-opacity-50 inline-flex items-center">
                <i class="fas fa-arrow-left mr-2"></i> {{ __('Back to My Products') }}
            </a>
        </div>
    </x-slot>

    <div class="py-8">
        <div class="container mx-auto px-4 sm:px-6 lg:px-8">
            <div class="max-w-2xl mx-auto bg-white dark:bg-gray-800 shadow-md rounded-lg p-6">
                <form action="{{ route('frontend.businessdirectory.my-products.update', $product->slug) }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    @method('PUT')

                    {{-- Company Selection (Usually not changed on edit, but shown for context or if allowed) --}}
                    <div class="mb-4">
                        <label for="company_id_display" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Company</label>
                        <input type="text" id="company_id_display" value="{{ $product->company->name ?? 'N/A' }}" readonly
                               class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700/50 dark:text-gray-400 rounded-md shadow-sm sm:text-sm">
                        {{-- If you allow changing company, replace with a select like in create form --}}
                        {{-- For simplicity, assuming company is fixed on edit for user-managed products --}}
                        <input type="hidden" name="company_id" value="{{ $product->company_id }}">
                    </div>

                    {{-- Product Name --}}
                    <div class="mb-4">
                        <label for="name" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Product Name <span class="text-red-500">*</span></label>
                        <input type="text" name="name" id="name" value="{{ old('name', $product->name) }}" required
                               class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 rounded-md shadow-sm focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm @error('name') border-red-500 @enderror">
                        @error('name') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
                    </div>

                    {{-- Description --}}
                    <div class="mb-4">
                        <label for="description" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Description <span class="text-red-500">*</span></label>
                        <textarea name="description" id="description" rows="5" required
                                  class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 rounded-md shadow-sm focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm @error('description') border-red-500 @enderror">{{ old('description', $product->description) }}</textarea>
                        @error('description') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
                    </div>

                    {{-- Price & Stock --}}
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-4">
                        <div>
                            <label for="price" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Price <span class="text-red-500">*</span></label>
                            <input type="number" name="price" id="price" value="{{ old('price', $product->price) }}" required step="0.01" min="0"
                                   class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 rounded-md shadow-sm focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm @error('price') border-red-500 @enderror">
                            @error('price') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
                        </div>
                        <div>
                            <label for="stock_quantity" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Stock Quantity <span class="text-red-500">*</span></label>
                            <input type="number" name="stock_quantity" id="stock_quantity" value="{{ old('stock_quantity', $product->stock_quantity) }}" required min="0"
                                   class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 rounded-md shadow-sm focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm @error('stock_quantity') border-red-500 @enderror">
                            @error('stock_quantity') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
                        </div>
                    </div>
                    <div class="mb-4">
                        <label for="sale_price" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Sale Price (Optional)</label>
                        <input type="number" name="sale_price" id="sale_price" value="{{ old('sale_price', $product->sale_price) }}" step="0.01" min="0"
                               class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 rounded-md shadow-sm focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm @error('sale_price') border-red-500 @enderror">
                        @error('sale_price') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
                    </div>

                    {{-- Featured Image --}}
                    <div class="mb-4">
                        <label for="featured_image" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Featured Image (leave blank to keep current)</label>
                        <input type="file" name="featured_image" id="featured_image"
                               class="mt-1 block w-full text-sm text-gray-500 dark:text-gray-400 file:mr-4 file:py-2 file:px-4 file:rounded-md file:border-0 file:text-sm file:font-semibold file:bg-indigo-50 dark:file:bg-indigo-800 file:text-indigo-700 dark:file:text-indigo-200 hover:file:bg-indigo-100 dark:hover:file:bg-indigo-700 @error('featured_image') border-red-500 @enderror">
                        @error('featured_image') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
                        @if($product->featured_image_url)
                            <div class="mt-2">
                                <p class="text-xs text-gray-500 dark:text-gray-400">Current Image:</p>
                                <img src="{{ $product->featured_image_url }}" alt="Current product image" class="h-20 w-20 object-cover rounded-md mt-1">
                            </div>
                        @endif
                    </div>

                    {{-- Status --}}
                    <div class="mb-4">
                        <label for="status" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Status <span class="text-red-500">*</span></label>
                        <select name="status" id="status" required
                                class="mt-1 block w-full pl-3 pr-10 py-2 text-base border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm rounded-md @error('status') border-red-500 @enderror">
                            @php
                                $productStatuses = \Modules\BusinessDirectory\Entities\Product::getStatuses();
                            @endphp
                            @foreach($productStatuses as $key => $value)
                                <option value="{{ $key }}" {{ old('status', $product->status) == $key ? 'selected' : '' }}>{{ $value }}</option>
                            @endforeach
                        </select>
                        @error('status') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
                    </div>

                    {{-- Published Status --}}
                    <div class="mb-6">
                        <label for="is_published" class="flex items-center">
                            <input type="checkbox" name="is_published" id="is_published" value="1" {{ old('is_published', $product->is_published) ? 'checked' : '' }}
                                   class="h-4 w-4 text-indigo-600 border-gray-300 dark:border-gray-600 dark:bg-gray-700 rounded focus:ring-indigo-500">
                            <span class="ml-2 text-sm text-gray-700 dark:text-gray-300">Publish this product</span>
                        </label>
                        @error('is_published') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
                    </div>

                    {{-- Submit Button --}}
                    <div class="mt-6 flex justify-end space-x-3">
                        <a href="{{ route('frontend.businessdirectory.my-products.index') }}" class="px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm text-sm font-medium text-gray-700 dark:text-gray-300 bg-white dark:bg-gray-800 hover:bg-gray-50 dark:hover:bg-gray-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                            Cancel
                        </a>
                        <button type="submit" class="px-4 py-2 border border-transparent rounded-md shadow-sm text-sm font-medium text-white bg-green-600 hover:bg-green-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-green-500">
                            Update Product
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</x-app-layout>
