{{--
    This partial expects:
    - $product: The product model instance
--}}
<div class="bg-gray-50 dark:bg-gray-700/50 rounded-lg shadow-md overflow-hidden hover:shadow-lg transition-shadow duration-300 group">
    <a href="{{ active_public_route_url('products.show', ['product' => $product->slug]) }}" class="block">
        <div class="relative overflow-hidden">
            <img class="w-full h-40 object-cover transform group-hover:scale-105 transition-transform duration-300"
                 src="{{ $product->featured_image_url_public ?? asset(config('businessdirectory.default_product_image_path', 'images/defaults/product_image.png')) }}"
                 alt="{{ $product->name }}">
            @if($product->sale_price && $product->sale_price < $product->price)
                <span class="absolute top-2 right-2 bg-red-500 text-white text-xs font-semibold px-2 py-0.5 rounded">SALE</span>
            @endif
        </div>
        <div class="p-4">
            <h4 class="font-semibold text-md text-gray-800 dark:text-gray-100 truncate" title="{{ $product->name }}">{{ $product->name }}</h4>
            <div class="mt-1">
                <p class="text-sm font-bold text-purple-600 dark:text-purple-400">
                    {{ setting('site_currency_symbol', '$') }}{{ number_format($product->sale_price ?? $product->price, 2) }}
                    @if($product->sale_price && $product->sale_price < $product->price)
                        <span class="text-xs text-gray-400 line-through ml-1">{{ setting('site_currency_symbol', '$') }}{{ number_format($product->price, 2) }}</span>
                    @endif
                </p>
            </div>
            {{-- <p class="text-xs text-gray-500 dark:text-gray-400 mt-1">
                By: <span class="hover:underline">{{ $product->company->name ?? 'N/A' }}</span>
            </p> --}}
        </div>
    </a>
</div>