<section class="py-16 bg-gray-100 dark:bg-gray-800">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-12">
            <h2 class="text-3xl font-bold text-gray-800 dark:text-white sm:text-4xl">Explore Our Core Features</h2>
            <p class="mt-4 text-lg text-gray-600 dark:text-gray-400">Everything you need in one powerful platform.</p>
        </div>
        <div class="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-8">
            @php
                $features = [
                    ['icon' => 'fas fa-building', 'name' => 'Company Profiles', 'color' => 'purple', 'description' => 'Detailed listings for businesses of all sizes.'],
                    ['icon' => 'fas fa-store', 'name' => 'Marketplace', 'color' => 'green', 'description' => 'Buy and sell products with ease.'],
                    ['icon' => 'fas fa-briefcase', 'name' => 'Job Postings', 'color' => 'blue', 'description' => 'Connect employers with talented professionals.'],
                    ['icon' => 'fas fa-file-signature', 'name' => 'Tender Listings', 'color' => 'yellow', 'description' => 'Discover and bid on new project opportunities.'],
                    ['icon' => 'fas fa-gavel', 'name' => 'Tender Bidding', 'color' => 'red', 'description' => 'Seamlessly submit and manage your bids.'],
                    ['icon' => 'fas fa-tasks', 'name' => 'Project Management', 'color' => 'indigo', 'description' => 'Organize and track your company projects.'],
                    ['icon' => 'fas fa-robot', 'name' => 'AI Integrations', 'color' => 'teal', 'description' => 'Leverage AI for smarter business insights.'],
                    ['icon' => 'fas fa-users', 'name' => 'Team Collaboration', 'color' => 'pink', 'description' => 'Work together effectively with team features.'],
                ];
            @endphp

            @foreach($features as $feature)
            <div class="flex flex-col items-center text-center p-6 bg-white dark:bg-gray-700 rounded-xl shadow-lg hover:shadow-xl transition-shadow duration-300">
                <div class="mb-4 text-{{$feature['color']}}-500 dark:text-{{$feature['color']}}-400 text-5xl">
                    <i class="{{ $feature['icon'] }}"></i>
                </div>
                <h3 class="text-xl font-semibold text-gray-800 dark:text-white mb-2">{{ $feature['name'] }}</h3>
                <p class="text-sm text-gray-600 dark:text-gray-400">{{ $feature['description'] }}</p>
            </div>
            @endforeach
        </div>
    </div>
</section>
