@props(['item'])

@php
    $isJob = $item->opportunity_type === 'job';
    $isTender = $item->opportunity_type === 'tender';

    $title = $item->title;
    $slug = $item->slug;
    $location = $item->location ?? 'Not specified';
    $detailsLink = '#';
    $tagText = '';
    $tagBgClass = '';
    $keyInfo = '';

    if ($isJob) {
        $detailsLink = active_public_route_url('jobs.show', ['slug' => $slug]);
        $tagText = 'Job';
        $tagBgClass = 'bg-blue-500'; // Using job-tag-home color
        $keyInfo = Str::title($item->job_type ?? 'N/A');
        if ($item->application_deadline) {
            $keyInfo .= ' - Apply by: ' . $item->application_deadline->format('M d, Y');
        }
    } elseif ($isTender) {
        $detailsLink = active_public_route_url('tenders.show', ['tender' => $slug]);
        $tagText = 'Tender';
        $tagBgClass = 'bg-purple-500'; // Using tender-tag-home color
        if ($item->deadline) {
            $keyInfo = 'Deadline: ' . $item->deadline->format('M d, Y H:i A');
        }
    }
@endphp

<div class="relative bg-slate-50 dark:bg-slate-700/50 rounded-lg shadow-md overflow-hidden hover:shadow-lg transition-shadow duration-300 group flex flex-col">
    @if($tagText)
    <div class="corner-tag {{ $tagBgClass }}">
        {{ $tagText }}
    </div>
    @endif
    <div class="p-5 flex-grow flex flex-col">
        <h4 class="font-semibold text-md text-gray-800 dark:text-gray-100 mb-1 truncate" title="{{ $title }}">
            <a href="{{ $detailsLink }}" class="hover:text-indigo-600 dark:hover:text-indigo-400 transition-colors">
                {{ Str::limit($title, 50) }}
            </a>
        </h4>
        <p class="text-xs text-gray-500 dark:text-gray-400 mb-2 flex items-center">
            <i class="fas fa-map-marker-alt mr-1.5 text-gray-400 dark:text-gray-500"></i>
            <span>{{ $location }}</span>
        </p>
        @if($keyInfo)
        <p class="text-xs text-gray-500 dark:text-gray-400 mb-3">
            {{ $keyInfo }}
        </p>
        @endif
        <div class="mt-auto pt-2">
            <a href="{{ $detailsLink }}" class="text-sm font-medium text-indigo-600 dark:text-indigo-400 hover:text-indigo-500 dark:hover:text-indigo-300 transition-colors duration-200">
                View Details <i class="fas fa-arrow-right text-xs ml-1"></i>
            </a>
        </div>
    </div>
</div>
