{{--
    Expects:
    - $companyTypes: Collection of company types for search dropdown (optional, can be fetched by a view composer or controller)
--}}
@php
    $features = [
        [
            'title' => 'Explore a Vast Company Directory',
            'subtitle' => 'Connect with thousands of verified businesses and services providers.',
            'icon' => 'fas fa-search-location',
            'cta_text' => 'Browse Companies',
            'cta_link' => active_public_route_url('companies.index'),
            'gradient' => 'from-sky-500 to-indigo-600', // Brighter Blue/Indigo
            'image_url' => asset('images/hero/directory.jpg'), // Replace with your actual image
        ],
        [
            'title' => 'Discover & Bid on Tenders',
            'subtitle' => 'Find lucrative project opportunities and submit your proposals seamlessly.',
            'icon' => 'fas fa-file-signature',
            'cta_text' => 'View Tenders',
            'cta_link' => active_public_route_url('tenders.index'),
            'gradient' => 'from-purple-500 to-pink-500', // Brighter Purple/Pink
            'image_url' => asset('images/hero/tenders.jpg'), // Replace with your actual image
        ],
        [
            'title' => 'Find Your Next Career Move',
            'subtitle' => 'Explore job openings from top companies and apply with ease.',
            'icon' => 'fas fa-briefcase',
            'cta_text' => 'Search Jobs',
            'cta_link' => active_public_route_url('jobs.index'),
            'gradient' => 'from-rose-500 to-red-600', // Brighter Rose/Red
            'image_url' => asset('images/hero/jobs.jpg'), // Replace with your actual image
        ],
        [
            'title' => 'Shop in Our Vibrant Marketplace',
            'subtitle' => 'Buy and sell products, discover unique items and great deals.',
            'icon' => 'fas fa-shopping-cart',
            'cta_text' => 'Explore Marketplace',
            'cta_link' => active_public_route_url('products.index'),
            'gradient' => 'from-emerald-500 to-green-600', // Brighter Emerald/Green
            'image_url' => asset('images/hero/marketplace.jpg'), // Replace with your actual image
        ],
    ];
@endphp

<section class="relative h-[60vh] md:h-[65vh] lg:h-[550px] text-white overflow-hidden hero-feature-slider-section">
    <div class="swiper-container hero-feature-swiper h-full"> {{-- Ensure this class matches your JS selector --}}
        <div class="swiper-wrapper">
            @foreach($features as $feature)
            <div class="swiper-slide">
                <div class="absolute inset-0 bg-gradient-to-br {{ $feature['gradient'] }} opacity-80"></div>
                @if($feature['image_url'])
                    <div class="absolute inset-0 bg-cover bg-center opacity-30" style="background-image: url('{{ $feature['image_url'] }}');"></div>
                @endif
                <div class="relative z-10 flex flex-col items-center justify-center h-full text-center p-8 max-w-3xl mx-auto">
                    <div class="mb-6 text-5xl md:text-6xl">
                        <i class="{{ $feature['icon'] }}"></i>
                    </div>
                    <h1 class="text-4xl sm:text-5xl md:text-6xl font-extrabold mb-4 leading-tight animate-fade-in-down">
                        {{ $feature['title'] }}
                    </h1>
                    <p class="text-lg sm:text-xl md:text-2xl mb-10 opacity-90 animate-fade-in-up animation-delay-300">
                        {{ $feature['subtitle'] }}
                    </p>
                    <a href="{{ $feature['cta_link'] }}"
                       class="bg-white text-gray-800 font-bold py-3 px-8 rounded-lg text-lg shadow-xl transition-transform hover:scale-105 animate-fade-in-up animation-delay-600">
                        {{ $feature['cta_text'] }} <i class="fas fa-arrow-right ml-2"></i>
                    </a>
                </div>
            </div>
            @endforeach
        </div>
        <!-- Add Pagination -->
        <div class="swiper-pagination hero-feature-pagination"></div>
        <!-- Add Navigation -->
        <div class="swiper-button-next hero-feature-next text-white"></div>
        <div class="swiper-button-prev hero-feature-prev text-white"></div>
    </div>
</section>

@push('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function () {
        if (typeof Swiper !== 'undefined') {
            if (document.querySelector('.hero-feature-swiper')) {
                new Swiper('.hero-feature-swiper', { // Changed var heroSwiper to new Swiper directly
                    loop: {{ count($features) > 1 ? 'true' : 'false' }}, // Should be true with 4 features
                    autoplay: {
                        delay: 5000, // Autoplay delay in ms (e.g., 5 seconds)
                        disableOnInteraction: false, // Autoplay will not be disabled after user interactions (swipes)
                    },
                    pagination: {
                        el: '.hero-feature-pagination',
                        clickable: true,
                    },
                    // Ensure navigation elements are correctly targeted
                    navigation: {
                        nextEl: '.hero-feature-next',
                        prevEl: '.hero-feature-prev',
                    },
                    // effect: 'fade', // Temporarily disable fade to test basic slide functionality
                    // fadeEffect: {
                    //     crossFade: true
                    // },
                    // Temporarily disable custom animation event handlers
                    // on: { /* ... your custom animation event handlers ... */ }
                });
            }
        } else {
            console.error('Swiper library is not loaded or not globally available. Hero slider not initialized.');
        }
    });
</script>
@endpush