@php
$customerFeatures = [
    ['icon' => 'fas fa-search-dollar', 'text' => 'Find Best Deals', 'link' => active_public_route_url('products.index'), 'color' => 'text-green-500'],
    ['icon' => 'fas fa-user-tie', 'text' => 'Apply for Jobs', 'link' => active_public_route_url('jobs.index'), 'color' => 'text-blue-500'],
    ['icon' => 'fas fa-gavel', 'text' => 'Bid on Tenders', 'link' => active_public_route_url('tenders.index'), 'color' => 'text-purple-500'],
    ['icon' => 'fas fa-building', 'text' => 'Discover Companies', 'link' => active_public_route_url('companies.index'), 'color' => 'text-indigo-500'],
    ['icon' => 'fas fa-handshake', 'text' => 'Partner with Businesses', 'link' => active_public_route_url('companies.index'), 'color' => 'text-pink-500'],
    ['icon' => 'fas fa-bullhorn', 'text' => 'Post Your Needs', 'link' => route('frontend.businessdirectory.my-tenders.create'), 'color' => 'text-orange-500'], // Example link
];
@endphp

<section class="py-12 bg-gray-50 dark:bg-gray-800 features-icon-marquee-section overflow-x-hidden">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        <div class="marquee-container">
            <div class="marquee-content flex">
                {{-- Original Items --}}
                @foreach($customerFeatures as $feature)
                <div class="marquee-item flex-none w-48 md:w-56 lg:w-64 mx-3"> {{-- Adjust width as needed --}}
                    <a href="{{ $feature['link'] }}" class="group block bg-white dark:bg-gray-700 rounded-xl shadow-lg hover:shadow-2xl transition-shadow duration-300 p-6 text-center h-full flex flex-col items-center justify-center">
                        <div class="mb-4 text-5xl {{ $feature['color'] }} group-hover:scale-110 transition-transform duration-300">
                            <i class="{{ $feature['icon'] }}"></i>
                        </div>
                        <h3 class="text-lg font-semibold text-gray-700 dark:text-gray-200 group-hover:text-purple-600 dark:group-hover:text-purple-400 transition-colors">
                            {{ $feature['text'] }}
                        </h3>
                    </a>
                </div>
                @endforeach
                {{-- Duplicated Items for seamless loop --}}
                @foreach($customerFeatures as $feature)
                <div class="marquee-item flex-none w-48 md:w-56 lg:w-64 mx-3" aria-hidden="true"> {{-- Adjust width as needed --}}
                    <a href="{{ $feature['link'] }}" class="group block bg-white dark:bg-gray-700 rounded-xl shadow-lg hover:shadow-2xl transition-shadow duration-300 p-6 text-center h-full flex flex-col items-center justify-center">
                        <div class="mb-4 text-5xl {{ $feature['color'] }} group-hover:scale-110 transition-transform duration-300">
                            <i class="{{ $feature['icon'] }}"></i>
                        </div>
                        <h3 class="text-lg font-semibold text-gray-700 dark:text-gray-200 group-hover:text-purple-600 dark:group-hover:text-purple-400 transition-colors">
                            {{ $feature['text'] }}
                        </h3>
                    </a>
                </div>
                @endforeach
            </div>
        </div>
    </div>
</section>

@push('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function () {
        // Swiper initialization for '.features-icon-swiper' is removed.
        // Marquee effect will be handled by CSS.
    });
</script>
@endpush