<section class="py-16 bg-white dark:bg-gray-900">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-12">
            <h2 class="text-3xl font-bold text-gray-800 dark:text-white sm:text-4xl">Featured Products</h2>
            <p class="mt-4 text-lg text-gray-600 dark:text-gray-400">Check out these amazing products from our trusted sellers.</p>
        </div>

        <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-8">
            @forelse($products as $product)
                <div class="bg-white dark:bg-gray-800 rounded-xl shadow-lg overflow-hidden group transition-all duration-300 hover:shadow-2xl">
                    <a href="{{ active_public_route_url('products.show', ['product' => $product->slug]) }}" class="block">
                        <div class="relative overflow-hidden">
                            <img class="w-full h-56 object-cover transform group-hover:scale-105 transition-transform duration-300"
                                 src="{{ $product->featured_image_url_public ?? asset(config('businessdirectory.default_product_image_path', 'images/defaults/product_image.png')) }}"
                                 alt="{{ $product->name }}">
                            @if($product->sale_price && $product->sale_price < $product->price)
                                <span class="absolute top-2 right-2 bg-red-500 text-white text-xs font-semibold px-2 py-1 rounded">SALE</span>
                            @endif
                        </div>
                        <div class="p-5">
                            <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-1 truncate" title="{{ $product->name }}">{{ $product->name }}</h3>
                            <p class="text-xs text-gray-500 dark:text-gray-400 mb-2">
                                By: <span class="hover:underline">{{ $product->company->name ?? 'N/A' }}</span>
                            </p>
                            <div class="flex items-baseline justify-between">
                                <p class="text-xl font-bold text-purple-600 dark:text-purple-400">
                                    ${{ number_format($product->sale_price ?? $product->price, 2) }}
                                    @if($product->sale_price && $product->sale_price < $product->price)
                                        <span class="text-sm text-gray-400 line-through ml-1">${{ number_format($product->price, 2) }}</span>
                                    @endif
                                </p>
                                {{-- Optional: Add to cart icon or quick view --}}
                                <span class="text-purple-500 group-hover:text-purple-700 dark:text-purple-300 dark:group-hover:text-purple-200">
                                    <i class="fas fa-shopping-cart"></i>
                                </span>
                            </div>
                        </div>
                    </a>
                </div>
            @empty
                <p class="col-span-full text-center text-gray-500 dark:text-gray-400">No featured products available at the moment.</p>
            @endforelse
        </div>
         @if($products->count() > 0)
        <div class="text-center mt-12">
            <a href="{{ active_public_route_url('products.index') }}"
               class="inline-block bg-purple-600 hover:bg-purple-700 text-white font-bold py-3 px-8 rounded-lg text-lg shadow-md hover:shadow-lg transition-all duration-300">
                Shop All Products
            </a>
        </div>
        @endif
    </div>
</section>
