{{-- d:\projects\digitalvocano\Modules\BusinessDirectory\resources\views\frontend\orders\show_my_order.blade.php --}}
<x-app-layout>
    @section('title', 'My Order: ' . $order->order_number)

    <x-slot name="header">
        <div class="flex items-center justify-between">
            <h2 class="text-xl font-semibold leading-tight text-gray-800 dark:text-gray-200">
                {{ __('Order Details: ') }} <span class="text-blue-600 dark:text-blue-400">{{ $order->order_number }}</span>
            </h2>
            <a href="{{ route('frontend.businessdirectory.my-orders.index') }}"
               class="px-4 py-2 text-sm font-medium tracking-wide text-gray-700 capitalize transition-colors duration-300 transform bg-gray-200 rounded-md dark:text-gray-200 dark:bg-gray-700 hover:bg-gray-300 dark:hover:bg-gray-600 focus:outline-none focus:ring focus:ring-gray-300 focus:ring-opacity-50">
                {{ __('Back to My Orders') }}
            </a>
        </div>
    </x-slot>

    <div class="py-8">
        <div class="container mx-auto px-4 sm:px-6 lg:px-8">
            <div class="bg-white dark:bg-gray-800 shadow-xl rounded-lg p-6 md:p-8">
                <h3 class="text-2xl font-semibold text-gray-800 dark:text-white mb-4 border-b dark:border-gray-700 pb-2">Order Summary</h3>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-6 text-gray-700 dark:text-gray-300 text-sm">
                    <div><strong>Order Number:</strong> {{ $order->order_number }}</div>
                    <div><strong>Order Date:</strong> {{ $order->created_at->format('M d, Y H:i A') }}</div>
                    <div><strong>Status:</strong> <span class="font-semibold">{{ ucfirst($order->status) }}</span></div>
                    <div><strong>Payment Status:</strong> <span class="font-semibold">{{ ucfirst($order->payment_status) }}</span></div>
                    <div><strong>Total Amount:</strong> {{ $order->currency }} {{ number_format($order->total_amount, 2) }}</div>
                    <div><strong>Payment Method:</strong> {{ $order->payment_method ?? 'N/A' }}</div>
                    @if($order->company)
                    <div class="md:col-span-2"><strong>Seller:</strong> <a href="{{ active_public_route_url('companies.show', ['company' => $order->company->slug]) }}" class="text-blue-600 dark:text-blue-400 hover:underline">{{ $order->company->name }}</a></div>
                    @endif
                </div>

                @if($order->shipping_address)
                <div class="mt-6">
                    <h4 class="text-lg font-semibold text-gray-800 dark:text-white mb-2">Shipping Address</h4>
                    <address class="text-gray-700 dark:text-gray-300 text-sm not-italic">
                        {{ $order->shipping_address['name'] ?? '' }}<br>
                        {{ $order->shipping_address['address_line_1'] ?? '' }}<br>
                        @if(!empty($order->shipping_address['address_line_2'])){{ $order->shipping_address['address_line_2'] }}<br>@endif
                        {{ $order->shipping_address['city'] ?? '' }}, {{ $order->shipping_address['state_province'] ?? '' }} {{ $order->shipping_address['postal_code'] ?? '' }}<br>
                        {{ $order->shipping_address['country_code'] ?? '' }}
                    </address>
                </div>
                @endif

                 @if($order->billing_address)
                <div class="mt-6">
                    <h4 class="text-lg font-semibold text-gray-800 dark:text-white mb-2">Billing Address</h4>
                    <address class="text-gray-700 dark:text-gray-300 text-sm not-italic">
                        {{ $order->billing_address['name'] ?? '' }}<br>
                        {{ $order->billing_address['address_line_1'] ?? '' }}<br>
                        @if(!empty($order->billing_address['address_line_2'])){{ $order->billing_address['address_line_2'] }}<br>@endif
                        {{ $order->billing_address['city'] ?? '' }}, {{ $order->billing_address['state_province'] ?? '' }} {{ $order->billing_address['postal_code'] ?? '' }}<br>
                        {{ $order->billing_address['country_code'] ?? '' }}
                    </address>
                </div>
                @endif

                <div class="mt-8 pt-6 border-t dark:border-gray-700">
                    <h3 class="text-2xl font-semibold text-gray-800 dark:text-white mb-4">Items</h3>
                    @if($order->items->isEmpty())
                        <p class="text-gray-600 dark:text-gray-400">No items found for this order.</p>
                    @else
                        <div class="space-y-4">
                            @foreach($order->items as $item)
                                <div class="flex items-center bg-gray-50 dark:bg-gray-700/50 p-4 rounded-lg shadow-sm">
                                    @if($item->product && $item->product->images && !empty($item->product->images[0]))
                                        <img src="{{ Storage::url($item->product->images[0]) }}" alt="{{ $item->product->name }}" class="w-12 h-12 object-cover rounded-md mr-4">
                                    @endif
                                    <div class="flex-grow">
                                        <h4 class="font-semibold text-gray-800 dark:text-gray-100">{{ $item->product->name ?? 'Deleted Product' }}</h4>
                                        <p class="text-sm text-gray-600 dark:text-gray-400">{{ $item->quantity }} x {{ $order->currency }} {{ number_format($item->price_per_unit, 2) }}</p>
                                    </div>
                                    <div class="font-bold text-gray-800 dark:text-gray-100">{{ $order->currency }} {{ number_format($item->total_price, 2) }}</div>
                                </div>
                            @endforeach
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</x-app-layout>