@extends('layouts.frontend') {{-- Your TALL stack frontend layout --}}

@section('title', 'Order Details: #' . $order->order_number)

@section('content')
<div class="bg-gray-100 py-12">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        <header class="mb-8 md:flex md:items-center md:justify-between">
            <div>
                <nav class="text-sm mb-1" aria-label="Breadcrumb">
                    <ol class="list-none p-0 inline-flex">
                        <li class="flex items-center">
                            <a href="{{ route('frontend.businessdirectory.orders.index') }}" class="text-gray-500 hover:text-blue-600">My Orders</a>
                            <svg class="fill-current w-3 h-3 mx-3" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 320 512"><path d="M285.476 272.971L91.132 467.314c-9.373 9.373-24.569 9.373-33.941 0l-22.667-22.667c-9.357-9.357-9.375-24.522-.04-33.901L188.505 256 34.484 101.255c-9.335-9.379-9.317-24.544.04-33.901l22.667-22.667c9.373-9.373 24.569 9.373 33.941 0L285.475 239.03c9.373 9.372 9.373 24.568.001 33.941z"/></svg>
                        </li>
                        <li class="flex items-center">
                            <span class="text-gray-700 font-semibold">Order #{{ $order->order_number }}</span>
                        </li>
                    </ol>
                </nav>
                <h1 class="text-3xl font-bold text-blue-700">Order Details</h1>
            </div>
            {{-- Add actions like "Reorder", "Print Invoice" if applicable --}}
        </header>

        @if(session('success'))
            <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded relative mb-6" role="alert">
                <strong class="font-bold">Success!</strong>
                <span class="block sm:inline">{{ session('success') }}</span>
            </div>
        @endif

        <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
            {{-- Order Items & Summary --}}
            <div class="lg:col-span-2 space-y-8">
                <div class="bg-white shadow-lg rounded-lg overflow-hidden">
                    <div class="px-6 py-4 border-b border-gray-200 bg-gray-50">
                        <h2 class="text-xl font-semibold text-gray-800">Items in Order #{{ $order->order_number }}</h2>
                    </div>
                    <div class="divide-y divide-gray-200">
                        @foreach($order->items as $item)
                        <div class="p-4 sm:p-6 flex items-center space-x-4">
                            @if($item->product && $item->product->images && isset($item->product->images[0]))
                                <img src="{{ Storage::url($item->product->images[0]) }}" alt="{{ $item->product->name }}" class="w-20 h-20 object-cover rounded-md">
                            @else
                                <div class="w-20 h-20 bg-gray-200 rounded-md flex items-center justify-center text-gray-400">
                                    <i class="fas fa-image fa-2x"></i>
                                </div>
                            @endif
                            <div class="flex-1">
                                <p class="text-md font-medium text-gray-900 hover:text-blue-600">
                                    <a href="{{ route('frontend.businessdirectory.products.show', ['company' => $item->product->company->slug, 'product' => $item->product->slug]) }}">{{ $item->product->name ?? 'Product Deleted' }}</a>
                                </p>
                                <p class="text-sm text-gray-500">Sold by: {{ $item->product->company->name ?? 'N/A' }}</p>
                                <p class="text-sm text-gray-500">Qty: {{ $item->quantity }} @ {{ $order->currency ?? '$' }}{{ number_format($item->price_per_unit, 2) }}</p>
                            </div>
                            <div class="text-md font-semibold text-gray-900">
                                {{ $order->currency ?? '$' }}{{ number_format($item->total_price, 2) }}
                            </div>
                        </div>
                        @endforeach
                    </div>
                    <div class="px-6 py-4 border-t border-gray-200 bg-gray-50 text-right space-y-1">
                        <p class="text-sm text-gray-600">Subtotal: {{ $order->currency ?? '$' }}{{ number_format($order->items_sum_total_price, 2) }}</p>
                        {{-- Add Shipping and Taxes if applicable --}}
                        <p class="text-lg font-bold text-gray-800">Order Total: {{ $order->currency ?? '$' }}{{ number_format($order->total_amount, 2) }}</p>
                    </div>
                </div>
            </div>

            {{-- Order & Shipping Info --}}
            <div class="lg:col-span-1 space-y-8">
                <div class="bg-white shadow-lg rounded-lg p-6">
                    <h3 class="text-lg font-semibold text-gray-800 mb-3 border-b pb-2">Order Information</h3>
                    <div class="text-sm space-y-2 text-gray-700">
                        <p><strong>Order Date:</strong> {{ $order->created_at->format('M d, Y H:i A') }}</p>
                        <p><strong>Payment Method:</strong> {{ ucfirst(str_replace('_', ' ', $order->payment_method ?? 'N/A')) }}</p>
                        <p><strong>Order Status:</strong>
                            @php
                                $statusClass = 'bg-gray-200 text-gray-700';
                                if ($order->status === 'delivered' || $order->status === 'completed') $statusClass = 'bg-green-100 text-green-700';
                                elseif ($order->status === 'pending') $statusClass = 'bg-yellow-100 text-yellow-700';
                                elseif ($order->status === 'processing' || $order->status === 'shipped') $statusClass = 'bg-blue-100 text-blue-700';
                                elseif (in_array($order->status, ['cancelled', 'refunded', 'payment_failed'])) $statusClass = 'bg-red-100 text-red-700';
                            @endphp
                            <span class="px-2 py-1 text-xs font-semibold rounded-full {{ $statusClass }}">{{ ucfirst(str_replace('_', ' ', $order->status)) }}</span>
                        </p>
                        <p><strong>Payment Status:</strong>
                            @php
                                $paymentStatusClass = $order->payment_status === 'paid' ? 'bg-green-100 text-green-700' : ($order->payment_status === 'pending' ? 'bg-yellow-100 text-yellow-700' : 'bg-red-100 text-red-700');
                            @endphp
                            <span class="px-2 py-1 text-xs font-semibold rounded-full {{ $paymentStatusClass }}">{{ ucfirst($order->payment_status) }}</span>
                        </p>
                    </div>
                </div>

                <div class="bg-white shadow-lg rounded-lg p-6">
                    <h3 class="text-lg font-semibold text-gray-800 mb-3 border-b pb-2">Shipping Address</h3>
                    <div class="text-sm space-y-1 text-gray-700">
                        <p><strong>{{ $order->shipping_address['name'] ?? $order->user->name }}</strong></p>
                        <p>{{ $order->shipping_address['address_line_1'] ?? '' }}</p>
                        @if(isset($order->shipping_address['address_line_2']) && $order->shipping_address['address_line_2'])
                            <p>{{ $order->shipping_address['address_line_2'] }}</p>
                        @endif
                        <p>{{ $order->shipping_address['city'] ?? '' }}, {{ $order->shipping_address['state'] ?? '' }} {{ $order->shipping_address['zip_code'] ?? '' }}</p>
                        <p>{{ $order->shipping_address['country'] ?? '' }}</p>
                    </div>
                </div>

                @if($order->notes)
                <div class="bg-white shadow-lg rounded-lg p-6">
                    <h3 class="text-lg font-semibold text-gray-800 mb-3 border-b pb-2">Order Notes</h3>
                    <p class="text-sm text-gray-600 italic">{{ $order->notes }}</p>
                </div>
                @endif
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
{{-- Add any specific JS for this page if needed --}}
@endpush