{{-- d:\projects\digitalvocano\Modules\BusinessDirectory\resources\views\frontend\opportunity_create_placeholder.blade.php --}}
@extends('layouts.frontend')

@section('title', 'Create an Opportunity')

@section('content')
<div class="container mx-auto px-4 py-8">
    <h1 class="text-3xl font-bold text-gray-800 dark:text-gray-100 mb-6">Create an Opportunity</h1>
    <p class="text-gray-600 dark:text-gray-400 mb-8">What would you like to create today?</p>

    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
        {{-- Link to Create Company --}}
        <a href="{{ route('frontend.businessdirectory.my-companies.create') }}" class="block p-6 bg-white dark:bg-gray-800 rounded-lg shadow-md hover:shadow-lg transition-shadow">
            <h2 class="text-xl font-semibold text-purple-600 dark:text-purple-400 mb-2"><i class="fas fa-building mr-2"></i>List a Company</h2>
            <p class="text-sm text-gray-500 dark:text-gray-300">Get your business discovered by thousands of users.</p>
        </a>

        {{-- Link to Post Job --}}
        <a href="{{ route('frontend.businessdirectory.my_jobs.create') }}" class="block p-6 bg-white dark:bg-gray-800 rounded-lg shadow-md hover:shadow-lg transition-shadow">
            <h2 class="text-xl font-semibold text-blue-600 dark:text-blue-400 mb-2"><i class="fas fa-briefcase mr-2"></i>Post a Job</h2>
            <p class="text-sm text-gray-500 dark:text-gray-300">Find the perfect candidate for your open positions.</p>
        </a>

        {{-- Link to Post Tender --}}
        <a href="{{ route('frontend.businessdirectory.my-tenders.create') }}" class="block p-6 bg-white dark:bg-gray-800 rounded-lg shadow-md hover:shadow-lg transition-shadow">
            <h2 class="text-xl font-semibold text-green-600 dark:text-green-400 mb-2"><i class="fas fa-file-signature mr-2"></i>Post a Tender</h2>
            <p class="text-sm text-gray-500 dark:text-gray-300">Invite bids for your projects and services.</p>
        </a>

        {{-- Link to List Product --}}
        <a href="{{ route('frontend.businessdirectory.my-products.create') }}" class="block p-6 bg-white dark:bg-gray-800 rounded-lg shadow-md hover:shadow-lg transition-shadow">
            <h2 class="text-xl font-semibold text-yellow-600 dark:text-yellow-400 mb-2"><i class="fas fa-store mr-2"></i>List a Product</h2>
            <p class="text-sm text-gray-500 dark:text-gray-300">Sell your products in our marketplace.</p>
        </a>
    </div>
</div>
@endsection