@extends('layouts.frontend') {{-- Your main frontend layout --}}

@section('title', $job->title . ' at ' . ($job->company->name ?? 'N/A'))
@section('meta_description', Str::limit(strip_tags($job->description), 160))

@section('content')
<div class="bg-gray-100 dark:bg-gray-900">
    <!-- Company Hero Section (if company exists) -->
    @if($job->company)
    <section class="relative mb-8">
        @if($job->company->banner_url && $job->company->banner_url !== asset('path/to/default-banner.png')) {{-- Replace with your actual default banner path check --}}
            <img src="{{ $job->company->banner_url }}" alt="{{ $job->company->name }} banner" class="w-full h-48 md:h-64 object-cover">
            <div class="absolute inset-0 bg-gradient-to-t from-black/50 via-black/20 to-transparent"></div>
        @else
            <div class="w-full h-48 md:h-64 bg-gradient-to-br from-slate-400 to-slate-600 dark:from-slate-700 dark:to-slate-800 flex items-center justify-center">
                {{-- Placeholder if no banner --}}
            </div>
        @endif
        <div class="absolute bottom-0 left-0 right-0 px-4 sm:px-6 lg:px-8 pb-4">
            <div class="container mx-auto">
                <div class="flex items-end space-x-4">
                    @if($job->company->logo_url && $job->company->logo_url !== asset('path/to/default-logo.png')) {{-- Replace with your actual default logo path check --}}
                        <img src="{{ $job->company->logo_url }}" alt="{{ $job->company->name }} logo" class="w-20 h-20 md:w-24 md:h-24 object-contain rounded-md bg-white dark:bg-gray-700 p-1 border-2 border-white dark:border-gray-600 shadow-lg -mb-8 md:-mb-10 relative z-10">
                    @else
                        <div class="flex items-center justify-center w-20 h-20 md:w-24 md:h-24 object-contain rounded-md bg-gray-200 dark:bg-gray-700 p-1 border-2 border-white dark:border-gray-600 shadow-lg -mb-8 md:-mb-10 relative z-10 text-gray-400 dark:text-gray-500">
                            <i class="fas fa-building text-3xl"></i>
                        </div>
                    @endif
                    <div>
                        <p class="text-sm text-gray-200 dark:text-gray-300 drop-shadow-sm">Job at</p>
                        <h2 class="text-xl md:text-2xl font-semibold text-white drop-shadow-lg">
                            <a href="{{ active_public_route_url('companies.show', ['company' => $job->company->slug]) }}" class="hover:underline">{{ $job->company->name }}</a>
                        </h2>
                    </div>
                </div>
            </div>
        </div>
    </section>
    @endif

    <div class="container mx-auto px-4 sm:px-6 lg:px-8 pb-12 {{ $job->company ? 'pt-8 md:pt-12' : 'pt-12' }}"> {{-- Adjust top padding if no company hero --}}
        <div class="lg:flex lg:space-x-8">
            <!-- Main Job Content -->
            <div class="lg:w-2/3">
                <div class="bg-white dark:bg-gray-800 shadow-xl rounded-lg overflow-hidden">
                    <div class="p-6 md:p-8">
                        <h1 class="text-3xl md:text-4xl font-bold text-gray-900 dark:text-white mb-3">{{ $job->title }}</h1>
                        <div class="flex flex-wrap items-center text-sm text-gray-500 dark:text-gray-400 mb-6 space-x-2 sm:space-x-4">
                            @if(!$job->company) {{-- Show company name here if no hero --}}
                                <span><i class="fas fa-building mr-1"></i> {{ $job->company_name_fallback ?? 'A Reputable Company' }}</span>
                            @endif
                            @if($job->location)
                                <span><i class="fas fa-map-marker-alt mr-1"></i>{{ $job->location }}</span>
                            @endif
                            @if($job->job_type)
                                <span><i class="fas fa-briefcase mr-1"></i>{{ \Modules\BusinessDirectory\Entities\Job::getJobTypes()[$job->job_type] ?? Str::title($job->job_type) }}</span>
                            @endif
                            @if($job->is_remote)
                                <span class="inline-flex items-center px-2 py-0.5 rounded text-xs font-medium bg-blue-100 text-blue-800 dark:bg-blue-700 dark:text-blue-100">
                                    <i class="fas fa-wifi mr-1"></i> Remote
                                </span>
                            @endif
                        </div>

                        @if($job->salary_range)
                            <div class="mb-6 p-3 bg-green-50 dark:bg-green-900/30 rounded-md border border-green-200 dark:border-green-700">
                                <p class="text-sm font-semibold text-green-700 dark:text-green-300">
                                    <i class="fas fa-dollar-sign mr-1.5"></i> Salary Range: <span class="text-green-800 dark:text-green-200">{{ $job->salary_range }}</span>
                                </p>
                            </div>
                        @endif

                        <div class="mb-8">
                            <h3 class="text-xl font-semibold text-gray-800 dark:text-white mb-3">Job Description</h3>
                            <div class="prose dark:prose-invert max-w-none text-gray-700 dark:text-gray-300">
                                {!! nl2br(e($job->description)) !!}
                            </div>
                        </div>

                        @if($job->skills_required)
                            <div class="mb-8">
                                <h3 class="text-xl font-semibold text-gray-800 dark:text-white mb-3">Skills Required:</h3>
                                <div class="flex flex-wrap gap-2">
                                    @foreach(is_array($job->skills_required) ? $job->skills_required : explode(',', $job->skills_required) as $skill)
                                        <span class="bg-gray-200 dark:bg-gray-700 text-gray-700 dark:text-gray-300 text-xs font-medium px-2.5 py-0.5 rounded-full">{{ trim($skill) }}</span>
                                    @endforeach
                                </div>
                            </div>
                        @endif

                        @if($job->attachments->isNotEmpty())
                            <div class="mb-8">
                                <h3 class="text-xl font-semibold text-gray-800 dark:text-white mb-3">Attachments</h3>
                                <ul class="space-y-2">
                                    @foreach($job->attachments as $attachment)
                                        <li class="flex items-center justify-between p-3 bg-gray-50 dark:bg-gray-700/50 rounded-md border dark:border-gray-600">
                                            <div class="flex items-center">
                                                <i class="fas fa-paperclip mr-3 text-gray-400 dark:text-gray-500"></i>
                                                <span class="text-sm text-gray-700 dark:text-gray-300">{{ $attachment->original_name }}</span>
                                                <span class="ml-2 text-xs text-gray-500 dark:text-gray-400">({{ $attachment->readable_size }})</span>
                                            </div>
                                            <a href="{{ $attachment->url }}" download="{{ $attachment->original_name }}"
                                               class="inline-flex items-center px-3 py-1.5 border border-transparent text-xs font-medium rounded-md shadow-sm text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 dark:focus:ring-offset-gray-800">
                                                <i class="fas fa-download mr-1.5"></i> Download
                                            </a>
                                        </li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif

                        @if($job->how_to_apply)
                            <div class="mb-8">
                                <h3 class="text-xl font-semibold text-gray-800 dark:text-white mb-3">How to Apply:</h3>
                                <div class="prose dark:prose-invert max-w-none text-gray-700 dark:text-gray-300">
                                    {!! nl2br(e($job->how_to_apply)) !!}
                                </div>
                            </div>
                        @endif

                        <div class="mt-8 pt-6 border-t border-gray-200 dark:border-gray-700">
                            @if($hasApplied)
                                <p class="text-green-600 dark:text-green-400 font-semibold"><i class="fas fa-check-circle mr-2"></i>You have already applied for this job.</p>
                            @else
                                <h3 class="text-xl font-semibold text-gray-800 dark:text-white mb-4">Apply for this Job</h3>
                                @auth
                                    <form action="{{ route('frontend.businessdirectory.jobs.apply', $job->id) }}" method="POST" enctype="multipart/form-data">
                                        @csrf
                                        <div class="mb-4">
                                            <label for="resume" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Resume (PDF, DOC, DOCX - Max 2MB) <span class="text-red-500">*</span></label>
                                            <input type="file" name="resume" id="resume" required class="mt-1 block w-full text-sm text-gray-500 dark:text-gray-400 file:mr-4 file:py-2 file:px-4 file:rounded-md file:border-0 file:text-sm file:font-semibold file:bg-blue-50 dark:file:bg-blue-800 file:text-blue-700 dark:file:text-blue-200 hover:file:bg-blue-100 dark:hover:file:bg-blue-700 @error('resume') border-red-500 @enderror">
                                            @error('resume') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
                                        </div>
                                        <div class="mb-4">
                                            <label for="cover_letter" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Cover Letter (Optional)</label>
                                            <textarea name="cover_letter" id="cover_letter" rows="4" class="mt-1 form-textarea block w-full dark:bg-gray-700 dark:text-gray-200 dark:border-gray-600 rounded-md shadow-sm @error('cover_letter') border-red-500 @enderror">{{ old('cover_letter') }}</textarea>
                                            @error('cover_letter') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
                                        </div>
                                        <button type="submit" class="inline-flex items-center px-6 py-3 border border-transparent text-base font-medium rounded-md shadow-sm text-white bg-green-600 hover:bg-green-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-green-500 dark:focus:ring-offset-gray-800">
                                            Apply Now
                                        </button>
                                    </form>
                                @else
                                    <p class="text-md text-gray-600 dark:text-gray-400">
                                        Please <a href="{{ route('login') }}?redirect={{ url()->current() }}" class="text-blue-600 hover:underline font-semibold">login</a> or
                                        <a href="{{ route('register') }}?redirect={{ url()->current() }}" class="text-blue-600 hover:underline font-semibold">register</a> to apply.
                                    </p>
                                @endauth
                            @endif
                        </div>
                    </div>
                </div>
            </div>

            <!-- Sidebar -->
            <aside class="lg:w-1/3 mt-8 lg:mt-0 space-y-6">
                @if($job->company)
                <div class="bg-white dark:bg-gray-800 shadow-xl rounded-lg p-6">
                    <h3 class="text-xl font-semibold text-gray-800 dark:text-white mb-4 border-b dark:border-gray-700 pb-2">About {{ $job->company->name }}</h3>
                    <div class="flex items-center mb-3">
                        @if($job->company->logo_url && $job->company->logo_url !== asset('path/to/default-logo.png'))
                            <img src="{{ $job->company->logo_url }}" alt="{{ $job->company->name }} logo" class="h-16 w-16 mr-4 rounded-full object-contain border-2 border-gray-200 dark:border-gray-700">
                        @else
                             <span class="flex items-center justify-center h-16 w-16 mr-4 rounded-full bg-gray-200 dark:bg-gray-700 text-gray-400 dark:text-gray-500">
                                <i class="fas fa-building text-2xl"></i>
                            </span>
                        @endif
                        <div>
                            <a href="{{ active_public_route_url('companies.show', ['company' => $job->company->slug]) }}" class="text-lg font-semibold text-blue-600 hover:text-blue-800 dark:text-blue-400 dark:hover:text-blue-300">
                                {{ $job->company->name }}
                            </a>
                            <p class="text-sm text-gray-500 dark:text-gray-400">{{ $job->company->companyType->name ?? 'Business' }}</p>
                        </div>
                    </div>
                    <p class="text-sm text-gray-600 dark:text-gray-300 line-clamp-3 mb-3">
                        {{ Str::limit(strip_tags($job->company->description), 150) }}
                    </p>
                    <a href="{{ active_public_route_url('companies.show', ['company' => $job->company->slug]) }}" class="text-sm font-medium text-indigo-600 dark:text-indigo-400 hover:underline">
                        View Company Profile &rarr;
                    </a>
                </div>
                @endif

                @if($relatedJobs->isNotEmpty())
                <div class="bg-white dark:bg-gray-800 shadow-xl rounded-lg p-6">
                    <h3 class="text-xl font-semibold text-gray-800 dark:text-white mb-4 border-b dark:border-gray-700 pb-2">More Jobs from {{ $job->company->name ?? 'this Company' }}</h3>
                    <ul class="space-y-3">
                        @foreach($relatedJobs as $relatedJob)
                            <li>
                                <a href="{{ active_public_route_url('jobs.show', ['slug' => $relatedJob->slug]) }}" class="group">
                                    <h4 class="text-md font-semibold text-blue-600 group-hover:text-blue-800 dark:text-blue-400 dark:group-hover:text-blue-300">{{ $relatedJob->title }}</h4>
                                    <p class="text-xs text-gray-500 dark:text-gray-400">
                                        {{ $relatedJob->location ?? 'Remote' }} - {{ \Modules\BusinessDirectory\Entities\Job::getJobTypes()[$relatedJob->job_type] ?? Str::title($relatedJob->job_type) }}
                                    </p>
                                </a>
                            </li>
                        @endforeach
                    </ul>
                </div>
                @endif

                {{-- Social Share (Optional) --}}
                <div class="bg-white dark:bg-gray-800 shadow-xl rounded-lg p-6">
                    <h3 class="text-xl font-semibold text-gray-800 dark:text-white mb-4 border-b dark:border-gray-700 pb-2">Share this Job</h3>
                    <div class="flex space-x-3">
                        @php $shareUrl = url()->current(); $shareTitle = $job->title . ' at ' . ($job->company->name ?? 'a company'); @endphp
                        <a href="https://www.facebook.com/sharer/sharer.php?u={{ urlencode($shareUrl) }}" target="_blank" class="text-gray-400 hover:text-blue-600 dark:hover:text-blue-400 text-2xl" title="Share on Facebook"><i class="fab fa-facebook-square"></i></a>
                        <a href="https://twitter.com/intent/tweet?url={{ urlencode($shareUrl) }}&text={{ urlencode($shareTitle) }}" target="_blank" class="text-gray-400 hover:text-sky-500 dark:hover:text-sky-400 text-2xl" title="Share on Twitter"><i class="fab fa-twitter-square"></i></a>
                        <a href="https://www.linkedin.com/shareArticle?mini=true&url={{ urlencode($shareUrl) }}&title={{ urlencode($shareTitle) }}" target="_blank" class="text-gray-400 hover:text-blue-700 dark:hover:text-blue-500 text-2xl" title="Share on LinkedIn"><i class="fab fa-linkedin"></i></a>
                        <a href="https://wa.me/?text={{ urlencode($shareTitle . ' - ' . $shareUrl) }}" target="_blank" class="text-gray-400 hover:text-green-500 dark:hover:text-green-400 text-2xl" title="Share on WhatsApp"><i class="fab fa-whatsapp-square"></i></a>
                    </div>
                </div>
            </aside>
        </div>
    </div>
</div>
@endsection

@push('styles')
{{-- Add any specific styles for this page if needed --}}
@endpush

@push('scripts')
{{-- Add any specific scripts for this page if needed --}}
@endpush
