@extends('layouts.frontend')

    @section('title', $pageTitle ?? 'Find Your Next Opportunity - Job Listings')
    @section('meta_description', $metaDescription ?? 'Discover exciting career opportunities from top companies.')

@section('content')
    @include('businessdirectory::frontend.partials._page_hero_search', [
        'title' => $pageTitle ?? __('Job Listings'),
        'subtitle' => 'Discover exciting career opportunities from top companies.',
        'searchActionRoute' => active_public_route_url('jobs.index'),
        'searchPlaceholder' => 'Search job titles, skills, companies...',
        'showFilters' => true,
        'filterTargetId' => 'job-filters'
    ])
    <div class="py-12">
        <div class="container mx-auto px-4 sm:px-6 lg:px-8">
            {{-- Search and Filter Form --}}
            <div id="job-filters" class="mb-8 p-6 bg-white dark:bg-gray-800 shadow-xl rounded-lg">
                <h3 class="text-xl font-semibold text-gray-700 dark:text-gray-200 mb-4">Filter Jobs</h3>
                <form method="GET" action="{{ active_public_route_url('jobs.index') }}" >
                    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-x-6 gap-y-4 items-end">
                        <div class="lg:col-span-1">
                            <label for="search" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Keywords</label>
                            <input type="text" name="search" id="search" value="{{ request('search') }}"
                                   class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm"
                                   placeholder="Job title, company, skill...">
                        </div>
                        <div class="lg:col-span-1">
                            <label for="location" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Location</label>
                            <input type="text" name="location" id="location" value="{{ request('location') }}"
                                   class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm"
                                   placeholder="City, State, or Remote">
                        </div>
                        <div class="lg:col-span-1">
                            <label for="job_type" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Job Type</label>
                            <select name="job_type" id="job_type"
                                    class="mt-1 block w-full pl-3 pr-10 py-2 text-base border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 focus:outline-none focus:ring-blue-500 focus:border-blue-500 sm:text-sm rounded-md">
                                <option value="">All Types</option>
                                @foreach($job_types ?? [] as $key => $value)
                                    <option value="{{ $key }}" {{ request('job_type') == $key ? 'selected' : '' }}>{{ $value }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="lg:col-span-1">
                            <label for="salary_min" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Min Salary ({{ setting('site_currency_symbol', '$') }})</label>
                            <input type="number" name="salary_min" id="salary_min" value="{{ request('salary_min') }}"
                                   class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm"
                                   placeholder="e.g., 50000">
                        </div>
                        <div class="lg:col-span-1">
                            <label for="posted_within" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Posted Within</label>
                            <select name="posted_within" id="posted_within"
                                    class="mt-1 block w-full pl-3 pr-10 py-2 text-base border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 focus:outline-none focus:ring-blue-500 focus:border-blue-500 sm:text-sm rounded-md">
                                <option value="">Any Time</option>
                                <option value="1" {{ request('posted_within') == '1' ? 'selected' : '' }}>Last 24 hours</option>
                                <option value="7" {{ request('posted_within') == '7' ? 'selected' : '' }}>Last 7 days</option>
                                <option value="14" {{ request('posted_within') == '14' ? 'selected' : '' }}>Last 14 days</option>
                                <option value="30" {{ request('posted_within') == '30' ? 'selected' : '' }}>Last 30 days</option>
                            </select>
                        </div>
                        <div class="lg:col-span-1 flex justify-end space-x-3 self-end"> {{-- Align buttons to the end of the grid cell --}}
                            <a href="{{ active_public_route_url('jobs.index') }}" class="px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-md text-sm font-medium text-gray-700 dark:text-gray-300 hover:bg-gray-50 dark:hover:bg-gray-700">Reset</a>
                            <button type="submit"
                                    class="bg-blue-600 hover:bg-blue-700 text-white font-semibold py-2 px-4 rounded-md shadow-sm focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                                Apply Filters
                            </button>
                        </div>
                    </div>
                </form>
            </div>

            {{-- Job Listings --}}
            @if($jobs->isNotEmpty())
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                    @foreach($jobs as $job) {{-- Ensure $job->company is eager loaded in controller --}}
                        <div class="bg-white dark:bg-gray-800 shadow-lg rounded-lg overflow-hidden hover:shadow-xl transition-shadow duration-300 ease-in-out flex flex-col">
                            <div class="p-6 flex-grow"> {{-- Added flex-grow to allow content to push footer down --}}
                                <div class="flex items-start justify-between">
                                    <div class="min-w-0 flex-1"> {{-- Allow this div to shrink and wrap text, crucial for long titles/names --}}
                                        <h3 class="text-lg font-semibold text-blue-700 dark:text-blue-400 hover:text-blue-800 dark:hover:text-blue-300">
                                            <a href="{{ active_public_route_url('jobs.show', ['slug' => $job->slug]) }}">{{ $job->title }}</a>
                                        </h3>
                                        @if($job->company) {{-- Check if company relationship exists and is loaded --}}
                                        <p class="text-sm text-gray-600 dark:text-gray-400 mt-1 truncate" title="{{ $job->company->name }}">
                                            <a href="{{ active_public_route_url('companies.show', ['company' => $job->company->slug]) }}" class="hover:underline">{{ $job->company->name }}</a>
                                        </p>
                                        @endif
                                    </div> {{-- End of title and company name div --}}
                                    @if($job->company)
                                        @if($job->company->hasCustomLogo())
                                            <img src="{{ $job->company->logo_url_public }}" alt="{{ $job->company->name }} logo" class="w-12 h-12 object-contain rounded-md ml-4 flex-shrink-0">
                                        @else
                                            <div class="w-12 h-12 bg-gray-200 dark:bg-gray-700 rounded-md ml-4 flex-shrink-0 flex items-center justify-center text-gray-400 dark:text-gray-500">
                                                <i class="fas fa-building"></i>
                                            </div>
                                        @endif
                                    @endif
                                </div>

                                <p class="text-sm text-gray-500 dark:text-gray-400 mt-2">
                                    <i class="fas fa-map-marker-alt mr-1 text-blue-500"></i> {{ $job->location ?? 'Not specified' }}
                                    @if($job->is_remote)
                                        <span class="ml-2 inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-indigo-100 text-indigo-800 dark:bg-indigo-900 dark:text-indigo-300">
                                            Remote
                                        </span>
                                    @endif
                                </p>
                                <p class="text-sm text-gray-500 dark:text-gray-400 mt-1">
                                    <i class="fas fa-briefcase mr-1 text-blue-500"></i> {{ \Modules\BusinessDirectory\Entities\Job::getJobTypes()[$job->job_type] ?? ucfirst($job->job_type ?? 'N/A') }}
                                </p>
                                @if($job->salary_min || $job->salary_max)
                                <p class="text-sm text-gray-500 dark:text-gray-400 mt-1">
                                    <i class="fas fa-dollar-sign mr-1 text-green-500"></i>
                                    {{ $job->salary_min ? setting('site_currency_symbol','$').number_format($job->salary_min) : '' }}
                                    {{ ($job->salary_min && $job->salary_max) ? ' - ' : '' }}
                                    {{ $job->salary_max ? setting('site_currency_symbol','$').number_format($job->salary_max) : '' }}
                                    {{ $job->salary_type ? ' / ' . ucfirst(str_replace('_', ' ', $job->salary_type)) : '' }}
                                </p>
                                @endif
                                <p class="text-xs text-gray-400 dark:text-gray-500 mt-3">
                                    Posted: {{ $job->created_at->diffForHumans() }}
                                    @if($job->application_deadline)
                                    | Deadline: {{ $job->application_deadline->format('M d, Y') }}
                                    @endif
                                </p>
                            </div>
                            <div class="p-6 pt-4 border-t border-gray-100 dark:border-gray-700 text-right"> 
                                    <a href="{{ active_public_route_url('jobs.show', ['slug' => $job->slug]) }}"
                                       class="text-blue-600 dark:text-blue-400 hover:text-blue-800 dark:hover:text-blue-300 font-medium text-sm">
                                        View Details &rarr;
                                    </a>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>

                <div class="mt-10">
                    {{ $jobs->appends(request()->query())->links() }} {{-- Pagination --}}
                </div>
            @else
                <div class="text-center py-12">
                    <i class="fas fa-search fa-3x text-gray-400 dark:text-gray-500 mb-3"></i>
                    <p class="text-xl text-gray-600 dark:text-gray-300">No jobs found matching your criteria.</p>
                    <p class="text-gray-500 dark:text-gray-400 mt-2">Try adjusting your search terms or filters.</p>
                </div>
            @endif
        </div>
    </div>
@endsection