@extends('landingpage::themes.job_board.layouts.app') {{-- Changed to use the job_board theme's app layout --}}

@section('title', $company->name . ' - ' . ($company->companyType->name ?? 'Company Profile') . ' - ' . setting('site_name', 'Digital Vocano'))
@section('meta_description', Str::limit(strip_tags($company->description), 155))
{{-- Add more meta tags as needed, e.g., for Open Graph --}}

@section('content')
<div class="container mx-auto px-4 py-8">
    {{-- Banner Image --}}
    @if($company->banner_image_path)
        <div class="mb-8 rounded-lg overflow-hidden shadow-lg">
            <img src="{{ Storage::url($company->banner_image_path) }}" alt="{{ $company->name }} Banner" class="w-full h-48 md:h-64 object-cover">
        </div>
    @endif

    <div class="bg-white dark:bg-gray-800 shadow-xl rounded-lg p-6 md:p-8">
        <div class="flex flex-col md:flex-row items-start">
            {{-- Logo and Basic Info --}}
            <div class="md:w-1/4 mb-6 md:mb-0 md:mr-8 text-center md:text-left">
                @if($company->logo_path)
                    <img src="{{ Storage::url($company->logo_path) }}" alt="{{ $company->name }} Logo" class="w-32 h-32 md:w-40 md:h-40 object-contain rounded-lg shadow-md mx-auto md:mx-0 mb-4 border border-gray-200 dark:border-gray-700">
                @else
                    <div class="w-32 h-32 md:w-40 md:h-40 bg-gray-200 dark:bg-gray-700 flex items-center justify-center text-gray-400 rounded-lg shadow-md mx-auto md:mx-0 mb-4">No Logo</div>
                @endif
                <h1 class="text-3xl font-bold text-gray-800 dark:text-gray-100">{{ $company->name }}</h1>
                @if($company->companyType)
                    <p class="text-md text-indigo-600 dark:text-indigo-400">{{ $company->companyType->name }}</p>
                @endif
                 @if($company->is_featured)
                    <span class="mt-2 inline-block bg-yellow-400 text-yellow-800 text-xs font-semibold px-2.5 py-0.5 rounded dark:bg-yellow-500 dark:text-yellow-900">Featured</span>
                @endif
            </div>

            {{-- Details and Contact Info --}}
            <div class="md:w-3/4">
                <h2 class="text-2xl font-semibold text-gray-700 dark:text-gray-200 mb-4 border-b pb-2 dark:border-gray-700">About {{ $company->name }}</h2>
                <div class="prose dark:prose-invert max-w-none text-gray-600 dark:text-gray-300 mb-6">
                    {!! nl2br(e($company->description)) !!}
                </div>

                <h3 class="text-xl font-semibold text-gray-700 dark:text-gray-200 mb-3">Contact Information</h3>
                <ul class="space-y-2 text-gray-600 dark:text-gray-300">
                    @if($company->address_line_1)<li><strong>Address:</strong> {{ $company->address_line_1 }}{{ $company->address_line_2 ? ', ' . $company->address_line_2 : '' }}, {{ $company->city }}, {{ $company->state_province }} {{ $company->postal_code }}, {{ $company->country_code }}</li>@endif
                    @if($company->phone_number)<li><strong>Phone:</strong> <a href="tel:{{$company->phone_number}}" class="text-indigo-600 dark:text-indigo-400 hover:underline">{{ $company->phone_number }}</a></li>@endif
                    @if($company->email)<li><strong>Email:</strong> <a href="mailto:{{ $company->email }}" class="text-indigo-600 dark:text-indigo-400 hover:underline">{{ $company->email }}</a></li>@endif
                    @if($company->website_url)<li><strong>Website:</strong> <a href="{{ $company->website_url }}" target="_blank" rel="noopener noreferrer" class="text-indigo-600 dark:text-indigo-400 hover:underline">{{ $company->website_url }}</a></li>@endif
                    @if($company->whatsapp_number)
                        <li><strong>WhatsApp:</strong>
                            <a href="https://wa.me/{{ preg_replace('/[^0-9]/', '', $company->whatsapp_number) }}" target="_blank" rel="noopener noreferrer" class="text-green-600 dark:text-green-400 hover:underline">
                                <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 mr-1" viewBox="0 0 20 20" fill="currentColor"><path d="M10.001 2C5.583 2 2 5.582 2 9.999c0 1.52.43 2.939 1.187 4.154l-.958 3.509a.5.5 0 00.628.627l3.509-.958A7.953 7.953 0 0010.001 18c4.418 0 8-3.582 8-8.001S14.418 2 10.001 2zM6.5 12.5a.5.5 0 01-.5-.5V8a.5.5 0 01.5-.5h1a.5.5 0 01.5.5v4a.5.5 0 01-.5.5h-1zm3 0a.5.5 0 01-.5-.5V8a.5.5 0 01.5-.5h1a.5.5 0 01.5.5v4a.5.5 0 01-.5.5h-1zm3 0a.5.5 0 01-.5-.5V8a.5.5 0 01.5-.5h1a.5.5 0 01.5.5v4a.5.5 0 01-.5.5h-1z" clip-rule="evenodd" fill-rule="evenodd"></path></svg>
                                Chat ({{ $company->whatsapp_number }})
                            </a>
                        </li>
                    @endif
                </ul>

                {{-- Placeholder for Map --}}
                @if($company->latitude && $company->longitude)
                    <div id="company-map" style="height: 300px;" class="mt-6 border rounded-md dark:border-gray-700"></div>
                    <p class="text-xs text-gray-500 dark:text-gray-400 mt-1">Map data &copy; <a href="https://www.openstreetmap.org/copyright" class="underline" target="_blank">OpenStreetMap</a> contributors</p>
                @endif

                {{-- Company Products Section --}}
                @if($company->is_ecommerce)
                    <div class="mt-8">
                        <h3 class="text-xl font-semibold text-gray-700 dark:text-gray-200 mb-4 border-b pb-2 dark:border-gray-700">Our Products</h3>
                        <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-6">
                            @foreach($company->products as $product)
                                <div class="bg-slate-50 dark:bg-slate-700/50 rounded-lg shadow-md overflow-hidden hover:shadow-lg transition-shadow duration-300">
                                    <a href="{{ route('theme.product.show', $product->slug) }}" class="block">
                                        @if($product->images && !empty($product->images[0]))
                                            <img src="{{ Storage::url($product->images[0]) }}" alt="{{ $product->name }}" class="w-full h-40 object-cover">
                                        @else
                                            <div class="w-full h-40 bg-slate-200 dark:bg-slate-600 flex items-center justify-center text-slate-400 dark:text-slate-500">
                                                <i class="fas fa-image fa-2x"></i>
                                            </div>
                                        @endif
                                        <div class="p-4">
                                            <h4 class="font-semibold text-md text-gray-800 dark:text-gray-100 truncate" title="{{ $product->name }}">{{ $product->name }}</h4>
                                            @if($product->sale_price && $product->sale_price < $product->price)
                                                <p class="text-sm text-red-600 dark:text-red-400 font-bold">
                                                    ${{ number_format($product->sale_price, 2) }}
                                                    <span class="text-xs text-gray-500 dark:text-gray-400 line-through ml-1">${{ number_format($product->price, 2) }}</span>
                                                </p>
                                            @else
                                                <p class="text-sm text-gray-700 dark:text-gray-200 font-bold">${{ number_format($product->price, 2) }}</p>
                                            @endif
                                        </div>
                                    </a>
                                </div>
                            @endforeach
                        </div>
                        @if($company->products->isEmpty())
                            <p class="text-slate-500 dark:text-slate-400 mt-4">No products listed at the moment.</p>
                        @elseif($company->products()->where('status', 'published')->count() > $company->products->count()) {{-- Check if total count is greater than loaded count --}}
                            <div class="mt-4 text-center">
                                <a href="{{ route('theme.company.products', $company->slug) }}" class="text-indigo-600 dark:text-indigo-400 hover:underline font-semibold">
                                    View All Products &rarr;
                                </a>
                            </div>
                        @endif
                    </div>
                @endif

                {{-- Company Jobs Section --}}
                @if($company->relationLoaded('jobs')) {{-- Check if relation was loaded to avoid N+1 if not --}}
                    <div class="mt-8">
                        <h3 class="text-xl font-semibold text-gray-700 dark:text-gray-200 mb-4 border-b pb-2 dark:border-gray-700">Open Positions</h3>
                        @if($company->jobs->isEmpty())
                            <p class="text-slate-500 dark:text-slate-400">No open positions listed at the moment.</p>
                        @else
                        <div class="space-y-4">
                            @foreach($company->jobs as $job)
                                <div class="bg-slate-50 dark:bg-slate-700/50 p-4 rounded-lg shadow-md hover:shadow-lg transition-shadow duration-300">
                                    <h4 class="font-semibold text-md text-gray-800 dark:text-gray-100">
                                        <a href="{{ route('theme.job.show', $job->slug) }}" class="hover:text-indigo-600 dark:hover:text-indigo-400">{{ $job->title }}</a>
                                    </h4>
                                    <p class="text-sm text-gray-500 dark:text-gray-400">
                                        {{ $job->location ?: 'Not specified' }} - <span class="capitalize">{{ $job->job_type ?: 'N/A' }}</span>
                                    </p>
                                    @if($job->application_deadline)
                                    <p class="text-xs text-gray-400 dark:text-gray-500">Apply by: {{ $job->application_deadline->format('M d, Y') }}</p>
                                    @endif
                                </div>
                            @endforeach
                        </div>
                        @if($company->jobs()->where('status', 'open')->where(fn($q) => $q->whereNull('application_deadline')->orWhere('application_deadline', '>=', now()))->count() > $company->jobs->count())
                            <div class="mt-4 text-center">
                                <a href="{{ route('theme.company.jobs', $company->slug) }}" class="text-indigo-600 dark:text-indigo-400 hover:underline font-semibold">
                                    View All Open Positions &rarr;
                                </a>
                            </div>
                        @endif
                        @endif
                    </div>
                @endif

                {{-- Company Tenders Section --}}
                @if($company->relationLoaded('tenders'))
                    <div class="mt-8">
                        <h3 class="text-xl font-semibold text-gray-700 dark:text-gray-200 mb-4 border-b pb-2 dark:border-gray-700">Current Tenders</h3>
                        @if($company->tenders->isEmpty())
                            <p class="text-slate-500 dark:text-slate-400">No current tenders listed at the moment.</p>
                        @else
                        <div class="space-y-4">
                            @foreach($company->tenders as $tender)
                                <div class="bg-slate-50 dark:bg-slate-700/50 p-4 rounded-lg shadow-md hover:shadow-lg transition-shadow duration-300">
                                    <h4 class="font-semibold text-md text-gray-800 dark:text-gray-100">
                                        <a href="{{ route('theme.tender.show', $tender->slug) }}" class="hover:text-indigo-600 dark:hover:text-indigo-400">{{ $tender->title }}</a>
                                    </h4>
                                    <p class="text-sm text-gray-500 dark:text-gray-400">
                                        {{ $tender->location ?: 'Not specified' }}
                                    </p>
                                    @if($tender->deadline)
                                    <p class="text-xs text-gray-400 dark:text-gray-500">Deadline: {{ $tender->deadline->format('M d, Y H:i A') }}</p>
                                    @endif
                                </div>
                            @endforeach
                        </div>
                        @if($company->tenders()->where('status', 'open')->where('deadline', '>=', now())->count() > $company->tenders->count())
                            <div class="mt-4 text-center">
                                <a href="{{ route('theme.company.tenders', $company->slug) }}" class="text-indigo-600 dark:text-indigo-400 hover:underline font-semibold">
                                    View All Current Tenders &rarr;
                                </a>
                            </div>
                        @endif
                        @endif
                    </div>
                @endif

                {{-- Reviews Section --}}
                @if($company->approved_reviews->isNotEmpty())
                    <div class="mt-8">
                        <h3 class="text-xl font-semibold text-gray-700 dark:text-gray-200 mb-4 border-b pb-2 dark:border-gray-700">Reviews</h3>
                        <div class="space-y-4">
                            @foreach($company->approved_reviews as $review)
                                <div class="bg-slate-50 dark:bg-slate-700/50 p-4 rounded-lg shadow">
                                    <div class="flex items-center mb-2">
                                        {{-- Add star rating display if you have it --}}
                                        {{-- Example:
                                        @for ($i = 1; $i <= 5; $i++)
                                            <i class="fas fa-star {{ $i <= $review->rating ? 'text-yellow-400' : 'text-gray-300' }}"></i>
                                        @endfor
                                        --}}
                                        <h4 class="font-semibold text-md text-gray-800 dark:text-gray-100 ml-2">{{ $review->reviewer_name ?? 'Anonymous' }}</h4>
                                    </div>
                                    <p class="text-sm text-gray-600 dark:text-gray-300">{{ $review->comment }}</p>
                                    <p class="text-xs text-gray-400 dark:text-gray-500 mt-1">{{ $review->created_at->format('M d, Y') }}</p>
                                </div>
                            @endforeach
                        </div>
                    </div>
                @endif

            </div>
        </div>
    </div>
</div>

{{-- WhatsApp Floating Widget --}}
@if($company->whatsapp_number)
<a href="https://wa.me/{{ preg_replace('/[^0-9]/', '', $company->whatsapp_number) }}?text={{ urlencode('Hello, I found you on ' . setting('site_name', 'our platform') . ' and would like to inquire about...') }}"
   target="_blank" rel="noopener noreferrer"
   class="fixed bottom-5 right-5 z-50 bg-green-500 hover:bg-green-600 text-white p-4 rounded-full shadow-lg transition-transform duration-300 hover:scale-110"
   aria-label="Chat with {{ $company->name }} on WhatsApp">
    <svg xmlns="http://www.w3.org/2000/svg" class="h-8 w-8" viewBox="0 0 24 24" fill="currentColor"><path d="M.057 24l1.687-6.163c-1.041-1.804-1.588-3.849-1.587-5.946.003-6.556 5.338-11.891 11.893-11.891 3.181.001 6.167 1.24 8.413 3.488 2.245 2.248 3.487 5.235 3.487 8.413 0 6.557-5.338 11.892-11.893 11.892-1.99-.001-3.951-.5-5.688-1.448l-6.305 1.654zm6.597-3.807c1.676.995 3.276 1.591 5.392 1.592 5.448 0 9.886-4.434 9.889-9.885.002-5.462-4.415-9.89-9.881-9.892-5.452 0-9.887 4.434-9.889 9.884-.001 2.225.651 3.891 1.746 5.634l-.999 3.648 3.742-.981zm11.387-5.464c-.074-.124-.272-.198-.57-.347-.297-.149-1.758-.868-2.031-.967-.272-.099-.47-.149-.669.149-.198.297-.768.967-.941 1.165-.173.198-.347.223-.644.074-.297-.149-1.255-.462-2.39-1.475-.883-.788-1.48-1.761-1.653-2.059-.173-.297-.018-.458.13-.606.134-.133.297-.347.446-.521.151-.172.2-.296.3-.495.099-.198.05-.372-.025-.521-.075-.148-.669-1.611-.916-2.206-.242-.579-.487-.5-.669-.51-.173-.008-.371-.01-.57-.01s-.521.074-.792.372c-.272.297-1.04 1.016-1.04 2.479 0 1.462 1.065 2.875 1.213 3.074.149.198 2.096 3.2 5.077 4.487.709.306 1.262.489 1.694.626.712.227 1.36.195 1.871.118.571-.085 1.758-.719 2.006-1.413.248-.695.248-1.289.173-1.413z"/></svg>
</a>
@endif

@push('styles')
@if($company->latitude && $company->longitude)
<link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css" integrity="sha256-p4NxAoJBhIIN+hmNHrzRCf9tD/miZyoHS5obTRR9BMY=" crossorigin=""/>
@endif
@endpush

@if($company->latitude && $company->longitude)
@push('scripts')
<script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js" integrity="sha256-20nQCchB9co0qIjJZRGuk2/Z9VM+kNiyxNV1lvTlZBo=" crossorigin=""></script>
<script>
    document.addEventListener('DOMContentLoaded', function () {
        if (document.getElementById('company-map')) {
            const lat = parseFloat("{{ $company->latitude }}");
            const lng = parseFloat("{{ $company->longitude }}");
            const companyName = "{{ addslashes($company->name) }}"; // Escape company name for JS

            var map = L.map('company-map').setView([lat, lng], 13);
            L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
                maxZoom: 19,
                attribution: '© OpenStreetMap contributors'
            }).addTo(map);
            L.marker([lat, lng]).addTo(map)
                .bindPopup(companyName)
                .openPopup();
        }
    });
</script>
@endpush
@endif

@push('schema_markup')
<script type="application/ld+json">
{
    "@context": "https://schema.org",
    "@type": "{{ $company->companyType && $company->companyType->name === 'Retailer' ? 'Store' : ($company->companyType && $company->companyType->name === 'Service Provider' ? 'ProfessionalService' : 'LocalBusiness') }}",
    "name": "{{ addslashes($company->name) }}",
    "description": "{{ addslashes(Str::limit(strip_tags($company->description), 250)) }}",
    "url": "{{ route('theme.company.show', $company->slug) }}",
    @if($company->logo_path)
    "logo": "{{ Storage::url($company->logo_path) }}",
    "image": "{{ Storage::url($company->logo_path) }}",
    @endif
    @if($company->banner_image_path && !$company->logo_path)
    "image": "{{ Storage::url($company->banner_image_path) }}",
    @endif
    @if($company->phone_number)
    "telephone": "{{ $company->phone_number }}",
    @endif
    @if($company->email)
    "email": "{{ $company->email }}",
    @endif
    @if($company->address_line_1 && $company->city && $company->country_code)
    "address": {
        "@type": "PostalAddress",
        "streetAddress": "{{ addslashes($company->address_line_1 . ($company->address_line_2 ? ', ' . $company->address_line_2 : '')) }}",
        "addressLocality": "{{ addslashes($company->city) }}",
        @if($company->state_province)
        "addressRegion": "{{ addslashes($company->state_province) }}",
        @endif
        @if($company->postal_code)
        "postalCode": "{{ addslashes($company->postal_code) }}",
        @endif
        "addressCountry": "{{ strtoupper($company->country_code) }}"
    },
    @endif
    @if($company->latitude && $company->longitude)
    "geo": {
        "@type": "GeoCoordinates",
        "latitude": "{{ $company->latitude }}",
        "longitude": "{{ $company->longitude }}"
    },
    @endif
    @if($company->website_url || ($company->social_links && is_array(json_decode($company->social_links, true))))
    "sameAs": [
        @if($company->website_url)"{{ $company->website_url }}"@if($company->social_links && !empty(array_filter(json_decode($company->social_links, true)))),@endif @endif
        @if($company->social_links && is_array(json_decode($company->social_links, true)))
            @foreach(array_filter(json_decode($company->social_links, true)) as $link)@if(!empty($link))"{{ $link }}"@if(!$loop->last),@endif @endif @endforeach
        @endif
    ]
    @endif
}
</script>
@endpush
@endsection