@extends('layouts.frontend') {{-- Your TALL stack frontend layout --}}

@section('title', 'My Companies')

@section('content')
<div class="bg-gray-100 py-12">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        <div class="md:flex md:items-center md:justify-between mb-8">
            <div class="flex-1 min-w-0">
                <h1 class="text-3xl font-bold text-blue-700">My Companies</h1>
                <p class="mt-1 text-sm text-gray-600">Manage your company profiles listed on our directory.</p>
            </div>
            <div class="mt-4 flex md:mt-0 md:ml-4">
                <a href="{{ route('frontend.businessdirectory.my-companies.create') }}"
                   class="bg-blue-600 hover:bg-blue-700 text-white font-semibold py-2 px-4 rounded-md shadow-sm inline-flex items-center">
                    <i class="fas fa-plus mr-2"></i> List New Company
                </a>
            </div>
        </div>

        @if(session('success'))
            <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded relative mb-6" role="alert">
                <strong class="font-bold">Success!</strong>
                <span class="block sm:inline">{{ session('success') }}</span>
            </div>
        @endif
        @if(session('error'))
            <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative mb-6" role="alert">
                <strong class="font-bold">Error!</strong>
                <span class="block sm:inline">{{ session('error') }}</span>
            </div>
        @endif

        @if($companies->isNotEmpty())
            <div class="bg-white shadow-lg rounded-lg overflow-hidden">
                <div class="overflow-x-auto">
                    <table class="min-w-full divide-y divide-gray-200">
                        <thead class="bg-gray-50">
                            <tr>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Company Name</th>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Type</th>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Submitted</th>
                                <th scope="col" class="relative px-6 py-3"><span class="sr-only">Actions</span></th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200">
                            @foreach($companies as $company)
                                <tr>
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <div class="flex items-center">
                                            @if($company->logo)
                                                <div class="flex-shrink-0 h-10 w-10">
                                                    <img class="h-10 w-10 rounded-full object-contain" src="{{ Storage::url($company->logo) }}" alt="{{ $company->name }} logo">
                                                </div>
                                            @endif
                                            <div class="ml-4">
                                                <div class="text-sm font-medium text-gray-900">{{ $company->name }}</div>
                                                <a href="{{ route('frontend.businessdirectory.companies.show', $company->slug) }}" target="_blank" class="text-xs text-blue-500 hover:underline">View Public Profile</a>
                                            </div>
                                        </div>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">{{ $company->companyType->name ?? 'N/A' }}</td>
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        @php
                                            $statusClass = 'bg-gray-200 text-gray-700';
                                            if ($company->status === 'approved') $statusClass = 'bg-green-100 text-green-700';
                                            elseif ($company->status === 'rejected') $statusClass = 'bg-red-100 text-red-700';
                                            elseif ($company->status === 'pending') $statusClass = 'bg-yellow-100 text-yellow-700';
                                            elseif ($company->status === 'suspended') $statusClass = 'bg-orange-100 text-orange-700';
                                        @endphp
                                        <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full {{ $statusClass }}">
                                            {{ ucfirst($company->status) }}
                                        </span>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">{{ $company->created_at->format('M d, Y') }}</td>
                                    <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium space-x-3">
                                        <a href="{{ route('frontend.businessdirectory.my-companies.edit', $company->slug) }}" class="text-blue-600 hover:text-blue-800">Edit</a>
                                        <form action="{{ route('frontend.businessdirectory.my-companies.destroy', $company->slug) }}" method="POST" class="inline-block" onsubmit="return confirm('Are you sure you want to delete this company profile? This action cannot be undone.');">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="text-red-600 hover:text-red-800">Delete</button>
                                        </form>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="mt-6">
                {{ $companies->links() }}
            </div>
        @else
            <div class="text-center py-12 bg-white shadow-md rounded-lg">
                <i class="fas fa-building fa-3x text-gray-400 mb-3"></i>
                <p class="text-xl text-gray-600">You haven't listed any companies yet.</p>
                <a href="{{ route('frontend.businessdirectory.my-companies.create') }}" class="mt-4 inline-block bg-blue-600 hover:bg-blue-700 text-white font-semibold py-2 px-4 rounded-md">List Your Company</a>
            </div>
        @endif
    </div>
</div>
@endsection
