@extends('layouts.frontend') {{-- Your TALL stack frontend layout --}}

@section('title', 'List Your Company')

@section('content')
<div class="bg-gray-100 py-12">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        <header class="mb-8 text-center">
            <h1 class="text-3xl font-bold text-blue-700">List Your Company</h1>
            <p class="mt-2 text-gray-600">Share your business with our community. Submitted profiles are subject to admin approval.</p>
        </header>

        <div class="max-w-3xl mx-auto bg-white shadow-xl rounded-lg p-6 md:p-8 border border-blue-100">
            <form action="{{ route('frontend.businessdirectory.my-companies.store') }}" method="POST" enctype="multipart/form-data">
                @csrf
                @include('businessdirectory::frontend.companies._my_company_form', ['companyTypes' => $companyTypes])
            </form>
        </div>
    </div>
</div>
@endsection