<x-app-layout>
    @section('title', __('Edit Company: ') . $company->name)

    <x-slot name="header">
        <div class="flex flex-col md:flex-row md:items-center md:justify-between">
            <h2 class="text-xl font-semibold leading-tight text-gray-800 dark:text-gray-200">
                {{ __('Edit Company: ') }} <span class="text-blue-600 dark:text-blue-400">{{ $company->name }}</span>
            </h2>
            <a href="{{ route('frontend.businessdirectory.my-companies.index') }}"
               class="mt-4 md:mt-0 px-4 py-2 text-sm font-medium tracking-wide text-gray-700 capitalize transition-colors duration-300 transform bg-gray-200 rounded-md dark:text-gray-200 dark:bg-gray-700 hover:bg-gray-300 dark:hover:bg-gray-600 focus:outline-none focus:ring focus:ring-gray-300 focus:ring-opacity-50">
                {{ __('Back to My Companies') }}
            </a>
        </div>
    </x-slot>

    <div class="py-8">
        <div class="mx-auto max-w-7xl sm:px-6 lg:px-8">
            <div class="p-6 overflow-hidden bg-white shadow-sm dark:bg-gray-800 sm:rounded-lg">
                <form method="POST" action="{{ route('frontend.businessdirectory.my-companies.update', $company->slug) }}" enctype="multipart/form-data">
                    @csrf
                    @method('PUT')
                    @include('businessdirectory::frontend.companies._my_company_form', [
                        'companyTypes' => $companyTypes,
                        'company' => $company, // Pass the existing Company instance
                        'isEdit' => true // Optional flag for the partial to change button text
                    ])
                </form>
            </div>
        </div>
    </div>
</x-app-layout>