{{-- d:\projects\digitalvocano\Modules\BusinessDirectory\resources\views\frontend\categories\index.blade.php --}}
@extends('layouts.frontend')

@section('title', $pageTitle ?? 'All Categories - ' . setting('site_name', 'Digital Vocano'))
@section('meta_description', $metaDescription ?? 'Browse all categories on our platform.')

@section('content')
<div class="container mx-auto px-4 py-8">
    <h1 class="text-3xl font-bold text-gray-800 dark:text-gray-100 mb-6">All Categories</h1>

    @if($categories->isEmpty())
        <p class="text-gray-600 dark:text-gray-400">No categories found.</p>
    @else
        <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-6">
            @foreach($categories as $category)
                <a href="{{ active_public_route_url('category.show', ['category' => $category->slug]) }}" class="block p-6 bg-white dark:bg-gray-800 rounded-lg shadow-md hover:shadow-lg transition-shadow text-center">
                    @if($category->icon_class)
                        <i class="{{ $category->icon_class }} fa-3x text-purple-600 dark:text-purple-400 mb-4"></i>
                    @endif
                    <h2 class="text-xl font-semibold text-gray-800 dark:text-gray-100">{{ $category->name }}</h2>
                    @if($category->description)
                        <p class="text-sm text-gray-600 dark:text-gray-400 mt-2 line-clamp-2">{{ $category->description }}</p>
                    @endif
                </a>
            @endforeach
        </div>
        <div class="mt-8">
            {{ $categories->links() }}
        </div>
    @endif
</div>
@endsection