<x-app-layout>
    @section('title', __('My Submitted Bids'))

    <x-slot name="header">
        <div class="flex flex-col md:flex-row md:items-center md:justify-between">
            <h2 class="text-xl font-semibold leading-tight text-gray-800 dark:text-gray-200">
                {{ __('My Submitted Bids') }}
            </h2>
            <a href="{{ active_public_route_url('tenders.index') }}" class="mt-4 md:mt-0 px-4 py-2 text-sm font-medium tracking-wide text-white capitalize transition-colors duration-300 transform bg-blue-600 rounded-md hover:bg-blue-500 focus:outline-none focus:ring focus:ring-blue-300 focus:ring-opacity-50 inline-flex items-center">
                <i class="fas fa-search mr-2"></i> {{ __('Browse Tenders') }}
            </a>
        </div>
    </x-slot>

    <div class="py-8">
        <div class="container mx-auto px-4 sm:px-6 lg:px-8">
            {{-- Session messages are handled by app.blade.php --}}

            {{-- Search and Filter Form --}}
            <form method="GET" action="{{ route('frontend.businessdirectory.my-submitted-bids.index') }}" class="mb-8 p-6 bg-white dark:bg-gray-800 shadow-md rounded-lg">
                <div class="grid grid-cols-1 md:grid-cols-3 gap-4 items-end">
                    <div>
                        <label for="search" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Search by Tender Title</label>
                        <input type="text" name="search" id="search" value="{{ request('search') }}"
                               class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm"
                               placeholder="e.g., Website Redesign">
                    </div>
                    <div>
                        <label for="status" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Status</label>
                        <select name="status" id="status"
                                class="mt-1 block w-full pl-3 pr-10 py-2 text-base border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 focus:outline-none focus:ring-blue-500 focus:border-blue-500 sm:text-sm rounded-md">
                            <option value="">All Statuses</option>
                            @php
                                $bidStatuses = \Modules\BusinessDirectory\Entities\Bid::getStatuses();
                            @endphp
                            @foreach($bidStatuses as $key => $value)
                                <option value="{{ $key }}" {{ request('status') == $key ? 'selected' : '' }}>{{ $value }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div>
                        <button type="submit"
                                class="w-full bg-blue-600 hover:bg-blue-700 text-white font-semibold py-2 px-4 rounded-md shadow-sm focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                            Filter Bids
                        </button>
                    </div>
                </div>
            </form>

            @if($bids && $bids->count() > 0)
                <div class="overflow-x-auto bg-white dark:bg-gray-800 shadow-lg rounded-lg">
                    <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
                        <thead class="bg-gray-50 dark:bg-gray-700">
                            <tr>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Tender Title</th>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Bid Amount</th>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Submitted On</th>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Status</th>
                                <th scope="col" class="relative px-6 py-3"><span class="sr-only">Actions</span></th>
                            </tr>
                        </thead>
                        <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
                            @foreach($bids as $bid)
                                <tr>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900 dark:text-gray-100">
                                        <a href="{{ route('frontend.businessdirectory.tenders.show', $bid->tender->slug) }}" class="hover:text-blue-700 dark:hover:text-blue-300" target="_blank">
                                            {{ $bid->tender->title ?? 'N/A' }}
                                        </a>
                                        @if($bid->bidderCompany) <div class="text-xs text-gray-500 dark:text-gray-400">As: {{ $bid->bidderCompany->name }}</div> @endif
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-400">{{ $bid->bid_amount ? ($bid->tender->budget_currency ?? '$') . number_format($bid->bid_amount, 2) : 'Not specified' }}</td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-400">{{ $bid->created_at->format('M d, Y') }}</td>
                                    <td class="px-6 py-4 whitespace-nowrap"><span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full {{ $bid->status_class ?? 'bg-gray-100 text-gray-800 dark:bg-gray-700 dark:text-gray-100' }}">{{ Str::title(str_replace('_', ' ', $bid->status)) }}</span></td>
                                    <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium">
                                        <a href="{{ route('frontend.businessdirectory.my-submitted-bids.show', $bid->id) }}" class="text-blue-600 dark:text-blue-400 hover:text-blue-800 dark:hover:text-blue-300">View Bid</a>
                                        @can('withdraw', $bid)
                                            <form action="{{ route('frontend.businessdirectory.my-submitted-bids.withdraw', $bid->id) }}" method="POST" class="inline-block ml-2" onsubmit="return confirm('Are you sure you want to withdraw this bid?');">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="text-red-600 dark:text-red-400 hover:text-red-900 dark:hover:text-red-300">Withdraw</button>
                                            </form>
                                        @endcan
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                @if($bids->hasPages())
                <div class="mt-6">{{ $bids->appends(request()->query())->links() }}</div>
                @endif
            @else
                <div class="text-center py-12 bg-white dark:bg-gray-800 shadow-md rounded-lg">
                    <i class="fas fa-gavel fa-3x text-gray-400 dark:text-gray-500 mb-3"></i>
                    <p class="text-xl text-gray-600 dark:text-gray-300">You haven't submitted any bids yet.</p>
                    <a href="{{ active_public_route_url('tenders.index') }}" class="mt-4 inline-block bg-blue-600 hover:bg-blue-700 text-white font-semibold py-2 px-4 rounded-md">Find Tenders to Bid On</a>
                </div>
            @endif
        </div>
    </div>
</x-app-layout>