@extends('layouts.app') {{-- Or your main frontend/dashboard layout --}}

@section('title', 'My Submitted Bids')

@section('content')
<div class="container mx-auto px-4 py-8">
    <div class="mb-8">
        <h1 class="text-3xl font-bold text-gray-800 dark:text-white">My Submitted Bids</h1>
        <p class="text-gray-600 dark:text-gray-300 mt-1">Track the status of bids your companies have submitted.</p>
    </div>

    @include('admin.partials.alerts') {{-- Reusing admin alerts, or create a frontend partial --}}

    @if($myBids->isEmpty())
        <div class="text-center py-12 bg-white dark:bg-gray-800 shadow-md rounded-lg">
            <svg class="mx-auto h-12 w-12 text-gray-400" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9.172 16.172a4 4 0 015.656 0M9 10h.01M15 10h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
            </svg>
            <h3 class="mt-2 text-sm font-medium text-gray-900 dark:text-gray-100">No Bids Submitted Yet</h3>
            <p class="mt-1 text-sm text-gray-500 dark:text-gray-400">
                You haven't submitted any bids yet. Browse open tenders to find opportunities.
            </p>
            <div class="mt-6">
                <a href="{{ route('public.businessdirectory.tenders.index') }}"
                   class="inline-flex items-center px-4 py-2 border border-transparent shadow-sm text-sm font-medium rounded-md text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                    Browse Tenders
                </a>
            </div>
        </div>
    @else
        <div class="bg-white dark:bg-gray-800 shadow-xl sm:rounded-lg overflow-hidden">
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
                    <thead class="bg-gray-50 dark:bg-gray-700">
                        <tr>
                            <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Tender Title</th>
                            <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Bidding As</th>
                            <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Bid Amount</th>
                            <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Submitted</th>
                            <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Status</th>
                            <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
                        @foreach ($myBids as $bid)
                            <tr>
                                <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900 dark:text-gray-100">
                                    <a href="{{ route('public.businessdirectory.tenders.show', $bid->tender->slug) }}" class="hover:text-blue-600 dark:hover:text-blue-400" title="{{ $bid->tender->title }}">
                                        {{ Str::limit($bid->tender->title, 40) }}
                                    </a>
                                    <p class="text-xs text-gray-500 dark:text-gray-400">by: {{ $bid->tender->company->name }}</p>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-400">{{ $bid->bidderCompany->name }}</td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-400">
                                    {{ $bid->bid_amount ? number_format($bid->bid_amount, 2) . ' ' . ($bid->tender->budget_currency ?? 'USD') : 'N/A' }}
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-400">{{ $bid->created_at->format('M d, Y') }}</td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm">
                                    <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full
                                        @if($bid->status == 'submitted') bg-yellow-100 text-yellow-800 dark:bg-yellow-700 dark:text-yellow-100 @endif
                                        @if($bid->status == 'viewed') bg-blue-100 text-blue-800 dark:bg-blue-700 dark:text-blue-100 @endif
                                        @if($bid->status == 'shortlisted') bg-purple-100 text-purple-800 dark:bg-purple-700 dark:text-purple-100 @endif
                                        @if($bid->status == 'accepted') bg-green-100 text-green-800 dark:bg-green-700 dark:text-green-100 @endif
                                        @if($bid->status == 'rejected') bg-red-100 text-red-800 dark:bg-red-700 dark:text-red-100 @endif
                                        @if($bid->status == 'withdrawn') bg-gray-100 text-gray-800 dark:bg-gray-600 dark:text-gray-200 @endif
                                    ">
                                        {{ Str::title(str_replace('_', ' ', $bid->status)) }}
                                    </span>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                                    <a href="{{ route('public.businessdirectory.tenders.show', $bid->tender->slug) }}#bid-{{$bid->id}}" class="text-blue-600 hover:text-blue-900 dark:text-blue-400 dark:hover:text-blue-300 mr-3">View Details</a>
                                    @if(in_array($bid->status, ['submitted', 'viewed', 'shortlisted']) && $bid->tender->status === 'open' && \Carbon\Carbon::parse($bid->tender->deadline_for_bids)->isFuture())
                                        <form action="{{ route('public.businessdirectory.bids.withdraw', $bid) }}" method="POST" class="inline-block" onsubmit="return confirm('Are you sure you want to withdraw this bid? This action cannot be undone.');">
                                            @csrf
                                            @method('PATCH')
                                            <button type="submit" class="text-red-600 hover:text-red-900 dark:text-red-400 dark:hover:text-red-300 text-xs">
                                                Withdraw Bid
                                            </button>
                                        </form>
                                    @endif
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
            <div class="p-6">
                {{ $myBids->links() }}
            </div>
        </div>
    @endif
</div>
@endsection