@extends('layouts.admin')

@section('title', 'Bids for Tender: ' . $tender->title)

@section('content_header')
    <div class="flex justify-between items-center">
        <div>
            <h1 class="text-2xl font-semibold text-gray-800 dark:text-gray-200">Bids for: <span class="font-normal">{{ $tender->title }}</span></h1>
            <p class="text-sm text-gray-500 dark:text-gray-400">Posted by: {{ $tender->company->name ?? 'N/A' }}</p>
        </div>
        <div>
            <a href="{{ route('admin.businessdirectory.tenders.edit', $tender->id) }}" class="inline-flex items-center px-4 py-2 bg-indigo-600 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-indigo-500 active:bg-indigo-700 focus:outline-none focus:border-indigo-700 focus:ring focus:ring-indigo-300 disabled:opacity-25 transition"><i class="fas fa-edit mr-2"></i> Edit Tender</a>
            <a href="{{ route('admin.businessdirectory.tenders.index') }}" class="ml-3 inline-flex items-center px-4 py-2 bg-gray-200 dark:bg-gray-600 border border-transparent rounded-md font-semibold text-xs text-gray-700 dark:text-gray-200 uppercase tracking-widest hover:bg-gray-300 dark:hover:bg-gray-500 active:bg-gray-400 focus:outline-none focus:border-gray-400 focus:ring focus:ring-gray-300 disabled:opacity-25 transition">&larr; Back to Tenders</a>
        </div>
    </div>
@stop

@section('content')
<div class="px-4 sm:px-6 lg:px-8 py-8">
    <div class="bg-white dark:bg-gray-800 shadow-md rounded-lg">
        <div class="px-6 py-4 border-b border-gray-200 dark:border-gray-700">
            <h3 class="text-lg leading-6 font-medium text-gray-900 dark:text-white">Submitted Bids ({{ $bids->total() }})</h3>
        </div>
        <div class="p-6">
            @include('businessdirectory::admin.partials._alerts')

            @if($bids->isNotEmpty())
                <div class="overflow-x-auto">
                    <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
                        <thead class="bg-gray-50 dark:bg-gray-700">
                                <tr>
                                    <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Bidder</th>
                                    <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Amount</th>
                                    <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Submitted At</th>
                                    <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Status</th>
                                    <th scope="col" class="px-6 py-3 text-center text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Flagged</th>
                                    <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Actions</th>
                                </tr>
                            </thead>
                            <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
                                @foreach($bids as $bid)
                                    <tr>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900 dark:text-gray-100">
                                            {{ $bid->bidderCompany->name ?? ($bid->bidderUser->name ?? 'N/A') }}
                                            @if($bid->bidderCompany) <span class="block text-xs text-gray-500 dark:text-gray-400">Company</span> @else <span class="block text-xs text-gray-500 dark:text-gray-400">Individual</span> @endif
                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-300">{{ setting('site_currency_symbol', '$') }}{{ number_format($bid->bid_amount, 2) }}</td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-300">{{ $bid->created_at->format('M d, Y H:i') }}</td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm">
                                            @php
                                                // Assuming Bid model has a getStatusConfig method similar to Order
                                                $bidStatusConfig = \Modules\BusinessDirectory\Entities\Bid::getStatusConfig($bid->status);
                                            @endphp
                                            <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full {{ $bidStatusConfig['tailwind_class'] }}">
                                                {{ Str::title(str_replace('_', ' ', $bid->status)) }}
                                            </span>
                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-center">
                                            @if($bid->is_flagged)
                                                <i class="fas fa-flag text-red-500 dark:text-red-400" title="Flagged for review"></i>
                                            @endif
                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium space-x-2">
                                            {{-- <a href="#" class="btn btn-xs btn-info" data-toggle="modal" data-target="#bidDetailsModal-{{$bid->id}}"><i class="fas fa-eye"></i> Details</a> --}}
                                            <form action="{{ route('admin.businessdirectory.bids.toggle-flag', $bid->id) }}" method="POST" class="inline-block">
                                                @csrf
                                                @method('PATCH')
                                                <button type="submit" class="text-xs {{ $bid->is_flagged ? 'text-yellow-600 hover:text-yellow-900 dark:text-yellow-400 dark:hover:text-yellow-300' : 'text-gray-500 hover:text-gray-700 dark:text-gray-400 dark:hover:text-gray-200' }}" title="{{ $bid->is_flagged ? 'Unflag' : 'Flag' }} Bid">
                                                    <i class="fas fa-flag"></i>
                                                </button>
                                            </form>
                                            {{-- Add actions like "Award Bid" if applicable from admin side --}}
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                </div>
                <div class="mt-6">
                    {{ $bids->links() }}
                </div>
            @else
                <p class="text-center text-gray-500 dark:text-gray-400 py-6">No bids have been submitted for this tender yet.</p>
            @endif
            </div>
        </div>
</div>
@endsection
