@extends('layouts.admin')

@section('title', 'Create New Tender')

@section('content_header')
    <div class="flex justify-between items-center">
        <h1 class="text-2xl font-semibold text-gray-800 dark:text-gray-200">Create New Tender</h1>
        <a href="{{ route('admin.businessdirectory.tenders.index') }}" class="text-sm text-indigo-600 hover:text-indigo-900 dark:text-indigo-400 dark:hover:text-indigo-300">
            &larr; Back to Tenders
        </a>
    </div>
@stop

@section('content')
<div class="px-4 sm:px-6 lg:px-8 py-8">
    <form action="{{ route('admin.businessdirectory.tenders.store') }}" method="POST" enctype="multipart/form-data">
        {{-- Ensure all necessary variables are passed to the form partial --}}
        @include('businessdirectory::admin.tenders._form', ['tender' => $tender, 'companies' => $companies, 'statuses' => $statuses, 'categories' => $categories ?? [], 'users' => $users ?? []])
    </form>
</div>
@endsection
