@csrf
<div class="grid grid-cols-1 md:grid-cols-3 gap-6 p-6">
    {{-- Main Column for Tender Details & SEO --}}
    <div class="md:col-span-2 space-y-6">
        <div class="bg-white dark:bg-gray-800 shadow-md rounded-lg">
            <div class="px-6 py-4 border-b border-gray-200 dark:border-gray-700">
                <h3 class="text-lg leading-6 font-medium text-gray-900 dark:text-white">Tender Details</h3>
            </div>
            <div class="p-6 space-y-6">
                <div>
                    <label for="title" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Title <span class="text-red-500">*</span></label>
                    <input type="text" name="title" id="title" class="mt-1 form-input block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('title') border-red-500 @enderror" value="{{ old('title', $tender->title ?? '') }}" required>
                    @error('title') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                </div>

                <div>
                    <label for="description" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Description <span class="text-red-500">*</span></label>
                    <textarea name="description" id="description" class="mt-1 form-textarea block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('description') border-red-500 @enderror" rows="8">{{ old('description', $tender->description ?? '') }}</textarea>
                    @error('description') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                </div>

                <div>
                    <label for="requirements" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Requirements</label>
                    <textarea name="requirements" id="requirements" class="mt-1 form-textarea block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('requirements') border-red-500 @enderror" rows="5">{{ old('requirements', $tender->requirements ?? '') }}</textarea>
                    @error('requirements') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                </div>

                <div class="grid grid-cols-1 sm:grid-cols-3 gap-4">
                    <div>
                        <label for="budget_min" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Min Budget ({{ setting('site_currency_symbol', '$') }})</label>
                        <input type="number" name="budget_min" id="budget_min" step="0.01" class="mt-1 form-input block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('budget_min') border-red-500 @enderror" value="{{ old('budget_min', $tender->budget_min ?? '') }}">
                        @error('budget_min') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                    </div>
                     <div>
                        <label for="budget_max" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Max Budget ({{ setting('site_currency_symbol', '$') }})</label>
                        <input type="number" name="budget_max" id="budget_max" step="0.01" class="mt-1 form-input block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('budget_max') border-red-500 @enderror" value="{{ old('budget_max', $tender->budget_max ?? '') }}">
                        @error('budget_max') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                    </div>
                    <div>
                        <label for="budget_currency" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Currency</label>
                        <input type="text" name="budget_currency" id="budget_currency" class="mt-1 form-input block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('budget_currency') border-red-500 @enderror" value="{{ old('budget_currency', $tender->budget_currency ?? setting('site_currency_code', 'USD')) }}">
                        @error('budget_currency') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                    </div>
                </div>
                 <div>
                    <label for="location" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Location</label>
                    <input type="text" name="location" id="location" class="mt-1 form-input block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('location') border-red-500 @enderror" value="{{ old('location', $tender->location ?? '') }}">
                    @error('location') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                </div>

                <div>
                    <label for="category_id" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Category</label>
                    <select name="category_id" id="category_id" class="mt-1 form-select block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('category_id') border-red-500 @enderror">
                        <option value="">Select Category</option>
                        @foreach($categories ?? [] as $id => $name)
                            <option value="{{ $id }}" {{ (old('category_id', $tender->category_id ?? '') == $id) ? 'selected' : '' }}>{{ $name }}</option>
                        @endforeach
                    </select>
                    @error('category_id') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                </div>
                 <div>
                    <label for="tags" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Tags (comma-separated)</label>
                    <input type="text" name="tags" id="tags" class="mt-1 form-input block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('tags') border-red-500 @enderror" value="{{ old('tags', $tender->tags ?? '') }}">
                    @error('tags') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                </div>

                <hr class="dark:border-gray-700">
                <h3 class="text-lg font-medium text-gray-900 dark:text-white">SEO Information (Optional)</h3>
                 <div>
                    <label for="meta_title" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Meta Title</label>
                    <input type="text" name="meta_title" id="meta_title" class="mt-1 form-input block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('meta_title') border-red-500 @enderror" value="{{ old('meta_title', $tender->meta_title ?? '') }}">
                    @error('meta_title') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                </div>
                <div>
                    <label for="meta_description" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Meta Description</label>
                    <textarea name="meta_description" id="meta_description" class="mt-1 form-textarea block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('meta_description') border-red-500 @enderror" rows="2">{{ old('meta_description', $tender->meta_description ?? '') }}</textarea>
                    @error('meta_description') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                </div>
            </div>
        </div>
    </div>
    {{-- Sidebar Column for Settings & Attachments --}}
    <div class="md:col-span-1 space-y-6">
        <div class="bg-white dark:bg-gray-800 shadow-md rounded-lg">
            <div class="px-6 py-4 border-b border-gray-200 dark:border-gray-700">
                <h3 class="text-lg leading-6 font-medium text-gray-900 dark:text-white">Settings</h3>
            </div>
            <div class="p-6 space-y-6">
                <div>
                    <label for="company_id" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Posting Company <span class="text-red-500">*</span></label>
                    <select name="company_id" id="company_id" class="mt-1 form-select block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('company_id') border-red-500 @enderror" required>
                        <option value="">Select Company</option>
                        @foreach($companies ?? [] as $id => $name)
                            <option value="{{ $id }}" {{ (old('company_id', $tender->company_id ?? '') == $id) ? 'selected' : '' }}>{{ $name }}</option>
                        @endforeach
                    </select>
                    @error('company_id') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                </div>

                @if(isset($users)) {{-- Pass $users to the view if needed --}}
                <div>
                    <label for="user_id" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Tender Poster (User)</label>
                    <select name="user_id" id="user_id" class="mt-1 form-select block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('user_id') border-red-500 @enderror">
                        <option value="">Default (Company Owner)</option>
                        @foreach($users as $id => $name)
                            <option value="{{ $id }}" {{ (old('user_id', $tender->user_id ?? '') == $id) ? 'selected' : '' }}>{{ $name }}</option>
                        @endforeach
                    </select>
                    @error('user_id') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                </div>
                @endif

                <div>
                    <label for="deadline" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Application Deadline <span class="text-red-500">*</span></label>
                    <input type="date" name="deadline" id="deadline" class="mt-1 form-input block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('deadline') border-red-500 @enderror" value="{{ old('deadline', isset($tender->deadline) ? $tender->deadline->format('Y-m-d') : '') }}" required>
                    @error('deadline') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                </div>

                <div>
                    <label for="status" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Status <span class="text-red-500">*</span></label>
                    <select name="status" id="status" class="mt-1 form-select block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('status') border-red-500 @enderror" required>
                        @foreach($statuses ?? [] as $key => $value)
                            <option value="{{ $key }}" {{ (old('status', $tender->status ?? 'open') == $key) ? 'selected' : '' }}>{{ $value }}</option>
                        @endforeach
                    </select>
                    @error('status') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                </div>

                <div>
                    <label for="attachments" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Attachments (PDF, DOC, Images)</label>
                    <input type="file" name="attachments[]" id="attachments" class="mt-1 block w-full text-sm text-gray-500 dark:text-gray-300 file:mr-4 file:py-2 file:px-4 file:rounded-md file:border-0 file:text-sm file:font-semibold file:bg-indigo-50 dark:file:bg-gray-600 file:text-indigo-700 dark:file:text-indigo-300 hover:file:bg-indigo-100 dark:hover:file:bg-gray-500 @error('attachments.*') border-red-500 @enderror" multiple>
                    @error('attachments.*') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                    {{-- Display existing attachments if any --}}
                    @if(isset($tender) && $tender->attachments && count($tender->attachments))
                        <div class="mt-2 space-y-1">
                            <p class="text-xs text-gray-500 dark:text-gray-400">Current attachments:</p>
                            @foreach($tender->attachments as $attachment)
                                <a href="{{ Storage::url($attachment['path']) }}" target="_blank" class="text-xs text-indigo-600 hover:underline dark:text-indigo-400">{{ $attachment['name'] }}</a>
                                <input type="checkbox" name="remove_attachments[]" value="{{ $attachment['path'] }}" class="form-checkbox h-3 w-3 text-red-600 ml-1"> <span class="text-xs text-red-500">Remove</span><br>
                            @endforeach
                        </div>
                    @endif
                </div>
            </div>
        </div>
        <div class="md:col-span-3 flex justify-end space-x-3 mt-6">
            <a href="{{ route('admin.businessdirectory.tenders.index') }}" class="inline-flex justify-center py-2 px-4 border border-gray-300 dark:border-gray-500 rounded-md shadow-sm text-sm font-medium text-gray-700 dark:text-gray-200 bg-white dark:bg-gray-600 hover:bg-gray-50 dark:hover:bg-gray-500 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                Cancel
            </a>
            <button type="submit" class="inline-flex justify-center py-2 px-4 border border-transparent rounded-md shadow-sm text-sm font-medium text-white bg-indigo-600 hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                {{ isset($tender) && $tender->id ? 'Update Tender' : 'Create Tender' }}
            </button>
        </div>
    </div>
</div>

@push('scripts')
<script>
    // Initialize WYSIWYG editor if you have one with class 'form-controlwysiwyg'
    // Example for CKEditor (ensure CKEditor script is loaded in your admin layout):
    // if (typeof ClassicEditor !== 'undefined') {
    //     ClassicEditor.create( document.querySelector( '#description' ) );
    //     ClassicEditor.create( document.querySelector( '#requirements' ) );
    // }
</script>
@endpush
