@extends('layouts.admin')

@section('title', 'Review Details')

@section('content_header')
    <div class="flex justify-between items-center">
        <h1 class="text-2xl font-semibold text-gray-800 dark:text-gray-200">Review Details</h1>
        <div>
            <a href="{{ route('admin.businessdirectory.reviews.index') }}" class="ml-3 inline-flex items-center px-4 py-2 bg-gray-200 dark:bg-gray-600 border border-transparent rounded-md font-semibold text-xs text-gray-700 dark:text-gray-200 uppercase tracking-widest hover:bg-gray-300 dark:hover:bg-gray-500 active:bg-gray-400 focus:outline-none focus:border-gray-400 focus:ring focus:ring-gray-300 disabled:opacity-25 transition">
                &larr; Back to Reviews
            </a>
        </div>
    </div>
@stop

@section('content')
<div class="px-4 sm:px-6 lg:px-8 py-8">
    @include('businessdirectory::admin.partials._alerts')
    <div class="bg-white dark:bg-gray-800 shadow-md rounded-lg overflow-hidden">
        <div class="px-6 py-4 border-b border-gray-200 dark:border-gray-700 flex justify-between items-center">
            <h3 class="text-lg leading-6 font-medium text-gray-900 dark:text-white">
                Review by {{ $review->user->name ?? 'Anonymous' }} for {{ $review->company->name ?? 'N/A' }}
            </h3>
            <div class="space-x-2">
                <form action="{{ route('admin.businessdirectory.reviews.updateStatus', $review->id) }}" method="POST" class="inline-block">
                    @csrf
                    <input type="hidden" name="is_approved" value="{{ $review->is_approved ? 0 : 1 }}">
                    <button type="submit" class="inline-flex items-center px-3 py-2 border border-transparent text-xs leading-4 font-medium rounded-md shadow-sm text-white {{ $review->is_approved ? 'bg-yellow-500 hover:bg-yellow-600 focus:ring-yellow-400' : 'bg-green-600 hover:bg-green-700 focus:ring-green-500' }} focus:outline-none focus:ring-2 focus:ring-offset-2">
                        <i class="fas fa-{{ $review->is_approved ? 'times-circle' : 'check-circle' }} mr-1"></i>
                        {{ $review->is_approved ? 'Unapprove' : 'Approve' }}
                    </button>
                </form>
                <form action="{{ route('admin.businessdirectory.reviews.destroy', $review->id) }}" method="POST" class="inline-block" onsubmit="return confirm('Are you sure you want to delete this review?');">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="inline-flex items-center px-3 py-2 border border-transparent text-xs leading-4 font-medium rounded-md shadow-sm text-white bg-red-600 hover:bg-red-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-red-500">
                        <i class="fas fa-trash mr-1"></i> Delete
                    </button>
                </form>
            </div>
        </div>
        <div class="p-6">
            <dl class="grid grid-cols-1 sm:grid-cols-3 gap-x-4 gap-y-6">
                <div class="sm:col-span-1">
                    <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Company</dt>
                    <dd class="mt-1 text-sm text-gray-900 dark:text-gray-100">
                        @if(!$review->is_approved)
                        <a href="{{ route('admin.businessdirectory.companies.show', $review->company_id) }}" class="text-indigo-600 hover:text-indigo-900 dark:text-indigo-400 dark:hover:text-indigo-300">{{ $review->company->name }}</a>
                        @else
                        N/A
                        @endif
                    </dd>
                </div>
                <div class="sm:col-span-1">
                    <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">User</dt>
                    <dd class="mt-1 text-sm text-gray-900 dark:text-gray-100">{{ $review->user->name ?? 'Anonymous' }} ({{ $review->user->email ?? 'N/A' }})</dd>
                </div>
                <div class="sm:col-span-1">
                    <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Rating</dt>
                    <dd class="mt-1 text-sm text-yellow-500">
                        @for ($i = 1; $i <= 5; $i++)
                            <i class="fas fa-star{{ $i <= $review->rating ? '' : '-half-alt' }}"></i> {{-- Adjust for half stars or use far fa-star for empty --}}
                        @endfor
                        <span class="text-gray-600 dark:text-gray-300">({{ $review->rating }}/5)</span>
                    </dd>
                </div>
                <div class="sm:col-span-1">
                    <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Title</dt>
                    <dd class="mt-1 text-sm text-gray-900 dark:text-gray-100">{{ $review->title ?? 'N/A' }}</dd>
                </div>
                <div class="sm:col-span-1">
                    <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Status</dt>
                    <dd class="mt-1 text-sm">
                        <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full {{ $review->is_approved ? 'bg-green-100 text-green-800 dark:bg-green-700 dark:text-green-100' : 'bg-yellow-100 text-yellow-800 dark:bg-yellow-700 dark:text-yellow-100' }}">
                                {{ $review->is_approved ? 'Approved' : 'Pending Approval' }}
                        </span>
                    </dd>
                </div>
                <div class="sm:col-span-1">
                    <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Submitted At</dt>
                    <dd class="mt-1 text-sm text-gray-900 dark:text-gray-100">{{ $review->created_at->format('M d, Y H:i A') }}</dd>
                </div>
                <div class="sm:col-span-3">
                    <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Comment</dt>
                    <dd class="mt-1 text-sm text-gray-900 dark:text-gray-100 whitespace-pre-wrap">{{ $review->comment }}</dd>
                </div>
            </dl>
        </div>
    </div>
</div>
@stop

{{-- @push('js')
    // Removed AJAX for status update and delete, using standard forms now.
@endpush --}}
