@extends('layouts.admin')

@section('title', 'Manage Reviews')

@section('content_header')
    <div class="flex justify-between items-center">
        <h1 class="text-2xl font-semibold text-gray-800 dark:text-gray-200">Manage Reviews</h1>
        {{-- No "Add New Review" button as per current controller --}}
    </div>
@stop

@section('content')
<div class="px-4 sm:px-6 lg:px-8 py-8">
    <div class="bg-white dark:bg-gray-800 shadow-md rounded-lg">
        <div class="p-6">
            <form method="GET" action="{{ route('admin.businessdirectory.reviews.index') }}" class="mb-6">
                <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 gap-4 items-end">
                    <div>
                        <label for="search" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Search</label>
                        <input type="text" name="search" id="search" class="mt-1 form-input block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300" placeholder="Company, User, Title..." value="{{ request('search') }}">
                    </div>
                    <div>
                        <label for="status_filter" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Status</label>
                        <select name="status_filter" id="status_filter" class="mt-1 form-select block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300">
                            <option value="">All Statuses</option>
                            <option value="0" {{ request('status_filter') == '0' ? 'selected' : '' }}>Pending</option>
                            <option value="1" {{ request('status_filter') == '1' ? 'selected' : '' }}>Approved</option>
                        </select>
                    </div>
                    <div class="flex space-x-2">
                        <button type="submit" class="inline-flex items-center px-4 py-2 bg-blue-600 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-blue-500 active:bg-blue-700 focus:outline-none focus:border-blue-700 focus:ring focus:ring-blue-300 disabled:opacity-25 transition">Filter</button>
                        <a href="{{ route('admin.businessdirectory.reviews.index') }}" class="inline-flex items-center px-4 py-2 bg-gray-200 dark:bg-gray-600 border border-transparent rounded-md font-semibold text-xs text-gray-700 dark:text-gray-200 uppercase tracking-widest hover:bg-gray-300 dark:hover:bg-gray-500 active:bg-gray-400 focus:outline-none focus:border-gray-400 focus:ring focus:ring-gray-300 disabled:opacity-25 transition">Reset</a>
                    </div>
                </div>
            </form>

            @include('businessdirectory::admin.partials._alerts')

            <form action="{{ route('admin.businessdirectory.reviews.bulk-actions') }}" method="POST" id="bulk-actions-form" class="mb-4">
                @csrf
                <div class="flex items-center space-x-2">
                    <select name="action" class="form-select form-select-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300">
                        <option value="">Bulk Actions</option>
                        <option value="approve">Approve Selected</option>
                        <option value="unapprove">Unapprove Selected</option>
                        <option value="delete">Delete Selected</option>
                    </select>
                    <button type="submit" class="inline-flex items-center px-3 py-1.5 border border-transparent text-xs font-medium rounded-md shadow-sm text-white bg-indigo-600 hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">Apply</button>
                </div>
            </form>

            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
                    <thead class="bg-gray-50 dark:bg-gray-700">
                            <tr>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider"><input type="checkbox" id="select-all-reviews"></th>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">ID</th>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Company</th>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">User</th>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Rating</th>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Title</th>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Status</th>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Submitted</th>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
                            @forelse($reviews as $review)
                                <tr>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm">
                                        <input type="checkbox" name="review_ids[]" value="{{ $review->id }}" class="form-checkbox review-checkbox h-4 w-4 text-indigo-600 border-gray-300 dark:border-gray-600 rounded focus:ring-indigo-500">
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900 dark:text-gray-100">{{ $review->id }}</td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-300">{{ $review->company->name ?? 'N/A' }}</td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-300">{{ $review->user->name ?? 'Anonymous' }}</td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-yellow-500">
                                        @for ($i = 1; $i <= 5; $i++)
                                            <i class="fas fa-star{{ $i <= $review->rating ? '' : '-half-alt' }}"></i> {{-- Adjust for half stars if needed or use fas fa-star / far fa-star --}}
                                        @endfor
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900 dark:text-gray-100">{{ Str::limit($review->title, 30) ?? 'N/A' }}</td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm">
                                        <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full {{ $review->is_approved ? 'bg-green-100 text-green-800 dark:bg-green-700 dark:text-green-100' : 'bg-yellow-100 text-yellow-800 dark:bg-yellow-700 dark:text-yellow-100' }}">
                                            {{ $review->is_approved ? 'Approved' : 'Pending' }}
                                        </span>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-300">{{ $review->created_at->format('M d, Y') }}</td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium space-x-2">
                                        <a href="{{ route('admin.businessdirectory.reviews.show', $review->id) }}" class="text-blue-600 hover:text-blue-900 dark:text-blue-400 dark:hover:text-blue-300" title="View"><i class="fas fa-eye"></i></a>
                                        <form action="{{ route('admin.businessdirectory.reviews.updateStatus', $review->id) }}" method="POST" class="inline-block">
                                            @csrf
                                            <input type="hidden" name="is_approved" value="{{ $review->is_approved ? 0 : 1 }}">
                                            <button type="submit" class="{{ $review->is_approved ? 'text-yellow-600 hover:text-yellow-900 dark:text-yellow-400 dark:hover:text-yellow-300' : 'text-green-600 hover:text-green-900 dark:text-green-400 dark:hover:text-green-300' }}" title="{{ $review->is_approved ? 'Unapprove' : 'Approve' }}">
                                                <i class="fas fa-{{ $review->is_approved ? 'times-circle' : 'check-circle' }}"></i>
                                            </button>
                                        </form>
                                        <form action="{{ route('admin.businessdirectory.reviews.destroy', $review->id) }}" method="POST" class="inline-block" onsubmit="return confirm('Are you sure you want to delete this review?');">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="text-red-600 hover:text-red-900 dark:text-red-400 dark:hover:text-red-300" title="Delete"><i class="fas fa-trash"></i></button>
                                        </form>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="9" class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-300 text-center">No reviews found.</td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
            </div>
            <div class="mt-6">
                {{ $reviews->appends(request()->query())->links() }}
            </div>
                </div>
            </div>
        </div>
</div>
@stop

@push('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function () {
        const selectAllCheckbox = document.getElementById('select-all-reviews');
        const reviewCheckboxes = document.querySelectorAll('.review-checkbox');
        const bulkActionsForm = document.getElementById('bulk-actions-form');

        if (selectAllCheckbox) {
            selectAllCheckbox.addEventListener('change', function () {
                reviewCheckboxes.forEach(checkbox => {
                    checkbox.checked = this.checked;
                });
            });
        }
        if(bulkActionsForm) {
            // You might want to add a confirmation before submitting bulk actions
        }
    });
</script>
@endpush
