@extends('layouts.admin')

@section('title', 'Create New Product for ' . $company->name)

@section('content_header')
    <div class="flex justify-between items-center">
        <h1 class="text-2xl font-semibold text-gray-800 dark:text-gray-200">Create New Product <span class="text-lg font-normal text-gray-600 dark:text-gray-400">for {{ $company->name }}</span></h1>
        <a href="{{ route('admin.businessdirectory.companies.products.index', $company->id) }}" class="text-sm text-indigo-600 hover:text-indigo-900 dark:text-indigo-400 dark:hover:text-indigo-300">
            &larr; Back to Products for {{ $company->name }}
        </a>
    </div>
@stop

@section('content')
<div class="px-4 sm:px-6 lg:px-8 py-8">
    <form action="{{ route('admin.businessdirectory.companies.products.store', $company->id) }}" method="POST" enctype="multipart/form-data">
        {{-- Ensure all necessary variables are passed to the form partial --}}
        @include('businessdirectory::admin.products._form', ['product' => new \Modules\BusinessDirectory\Entities\Product(), 'company' => $company, 'categories' => $categories ?? [], 'statuses' => $statuses ?? [], 'users' => $users ?? []])
    </form>
</div>
@endsection
