@extends('layouts.admin')

@section('title', 'Order Details: #' . $order->order_number)

@section('content_header')
    <div class="flex justify-between items-center">
        <h1 class="text-2xl font-semibold text-gray-800 dark:text-gray-200">Order Details: <span class="font-normal">#{{ $order->order_number }}</span></h1>
        <div>
            {{-- The edit button is part of the form in the sidebar now for this view's purpose --}}
            <a href="{{ route('admin.businessdirectory.orders.index') }}" class="ml-3 inline-flex items-center px-4 py-2 bg-gray-200 dark:bg-gray-600 border border-transparent rounded-md font-semibold text-xs text-gray-700 dark:text-gray-200 uppercase tracking-widest hover:bg-gray-300 dark:hover:bg-gray-500 active:bg-gray-400 focus:outline-none focus:border-gray-400 focus:ring focus:ring-gray-300 disabled:opacity-25 transition">
                &larr; Back to Orders
            </a>
        </div>
    </div>
@stop

@section('content')
<div class="px-4 sm:px-6 lg:px-8 py-8">
    @include('businessdirectory::admin.partials._alerts')
    <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
        {{-- Main Order Information & Items Column --}}
        <div class="md:col-span-2 bg-white dark:bg-gray-800 shadow-md rounded-lg overflow-hidden">
            <div class="px-6 py-4 border-b border-gray-200 dark:border-gray-700">
                <h3 class="text-lg leading-6 font-medium text-gray-900 dark:text-white">Order Information</h3>
            </div>
            <div class="p-6">
                <dl class="grid grid-cols-1 sm:grid-cols-2 gap-x-4 gap-y-6">
                    <div class="sm:col-span-1">
                        <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Order Number</dt>
                        <dd class="mt-1 text-sm text-gray-900 dark:text-gray-100">{{ $order->order_number }}</dd>
                    </div>
                    <div class="sm:col-span-1">
                        <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Customer</dt>
                        <dd class="mt-1 text-sm text-gray-900 dark:text-gray-100">{{ $order->user->name ?? 'N/A' }} ({{ $order->user->email ?? 'N/A' }})</dd>
                    </div>
                    <div class="sm:col-span-1">
                        <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Seller Company</dt>
                        <dd class="mt-1 text-sm text-gray-900 dark:text-gray-100">
                            @if($order->company)
                            <a href="{{ route('admin.businessdirectory.companies.show', $order->company_id) }}" class="text-indigo-600 hover:text-indigo-900 dark:text-indigo-400 dark:hover:text-indigo-300">{{ $order->company->name }}</a>
                            @else
                            N/A
                            @endif
                        </dd>
                    </div>
                    <div class="sm:col-span-1">
                        <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Order Date</dt>
                        <dd class="mt-1 text-sm text-gray-900 dark:text-gray-100">{{ $order->created_at->format('M d, Y H:i A') }}</dd>
                    </div>
                    <div class="sm:col-span-1">
                        <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Total Amount</dt>
                        <dd class="mt-1 text-sm font-semibold text-gray-900 dark:text-gray-100">{{ $order->currency ?? setting('site_currency_symbol','$') }}{{ number_format($order->total_amount, 2) }}</dd>
                    </div>
                    <div class="sm:col-span-1">
                        <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Payment Method</dt>
                        <dd class="mt-1 text-sm text-gray-900 dark:text-gray-100">{{ Str::title(str_replace('_', ' ', $order->payment_method)) }}</dd>
                    </div>
                    <div class="sm:col-span-1">
                        <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Payment Status</dt>
                        <dd class="mt-1 text-sm">
                             @php
                                $paymentStatusConfig = \Modules\BusinessDirectory\Entities\Order::getPaymentStatusConfig($order->payment_status);
                            @endphp
                            <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full {{ $paymentStatusConfig['tailwind_class'] }}">
                                {{ $paymentStatusConfig['label'] }}
                            </span>
                        </dd>
                    </div>
                    <div class="sm:col-span-1">
                        <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Order Status</dt>
                        <dd class="mt-1 text-sm">
                            @php
                                $orderStatusConfig = \Modules\BusinessDirectory\Entities\Order::getStatusConfig($order->status);
                            @endphp
                            <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full {{ $orderStatusConfig['tailwind_class'] }}">
                                {{ $orderStatusConfig['label'] }}
                            </span>
                        </dd>
                    </div>
                </dl>
            </div>

            <div class="px-6 py-4 border-t border-gray-200 dark:border-gray-700">
                <h3 class="text-lg leading-6 font-medium text-gray-900 dark:text-white">Order Items</h3>
            </div>
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
                    <thead class="bg-gray-50 dark:bg-gray-700">
                            <tr>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Product</th>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">SKU</th>
                                <th scope="col" class="px-6 py-3 text-right text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Quantity</th>
                                <th scope="col" class="px-6 py-3 text-right text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Unit Price</th>
                                <th scope="col" class="px-6 py-3 text-right text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Total</th>
                            </tr>
                    </thead>
                    <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
                            @foreach($order->items as $item)
                            <tr>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900 dark:text-gray-100">
                                    @if($item->product)
                                        <a href="{{ route('admin.businessdirectory.companies.products.edit', [$item->product->company_id, $item->product_id]) }}" class="text-indigo-600 hover:text-indigo-900 dark:text-indigo-400 dark:hover:text-indigo-300">{{ $item->product_name }}</a>
                                    @else
                                        {{ $item->product_name }} (Product Deleted)
                                    @endif
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-300">{{ $item->product_sku }}</td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-300 text-right">{{ $item->quantity }}</td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-300 text-right">{{ $order->currency ?? setting('site_currency_symbol','$') }}{{ number_format($item->unit_price, 2) }}</td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-300 text-right">{{ $order->currency ?? setting('site_currency_symbol','$') }}{{ number_format($item->quantity * $item->unit_price, 2) }}</td>
                            </tr>
                            @endforeach
                    </tbody>
                </table>
            </div>
        </div>

        {{-- Sidebar Column for Status Update & Addresses --}}
        <div class="space-y-6">
            <div class="bg-white dark:bg-gray-800 shadow-md rounded-lg">
                <div class="px-6 py-4 border-b border-gray-200 dark:border-gray-700">
                    <h3 class="text-lg leading-6 font-medium text-gray-900 dark:text-white">Update Status</h3>
                </div>
                <form action="{{ route('admin.businessdirectory.orders.update', $order->id) }}" method="POST">
                    <div class="p-6 space-y-4">
                        @csrf
                        @method('PUT')
                        <div>
                            <label for="status" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Order Status</label>
                            <select name="status" id="status" class="mt-1 form-select block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300">
                                @foreach(config('businessdirectory.order_statuses', ['pending' => 'Pending', 'processing' => 'Processing', 'shipped' => 'Shipped', 'delivered' => 'Delivered', 'completed' => 'Completed', 'cancelled' => 'Cancelled', 'refunded' => 'Refunded', 'payment_failed' => 'Payment Failed']) as $key => $value)
                                    <option value="{{ $key }}" {{ $order->status == $key ? 'selected' : '' }}>{{ $value }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div>
                            <label for="payment_status" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Payment Status</label>
                            <select name="payment_status" id="payment_status" class="mt-1 form-select block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300">
                                 @foreach(config('businessdirectory.payment_statuses', ['pending' => 'Pending', 'paid' => 'Paid', 'failed' => 'Failed', 'refunded' => 'Refunded']) as $key => $value)
                                    <option value="{{ $key }}" {{ $order->payment_status == $key ? 'selected' : '' }}>{{ $value }}</option>
                                @endforeach
                            </select>
                        </div>
                        {{-- Add fields for tracking number, notes, etc. if needed --}}
                    </div>
                    <div class="px-6 py-4 bg-gray-50 dark:bg-gray-700 text-right">
                        <button type="submit" class="inline-flex justify-center py-2 px-4 border border-transparent rounded-md shadow-sm text-sm font-medium text-white bg-indigo-600 hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">Update Order</button>
                    </div>
                </form>
            </div>
             <div class="bg-white dark:bg-gray-800 shadow-md rounded-lg">
                <div class="px-6 py-4 border-b border-gray-200 dark:border-gray-700"><h3 class="text-lg leading-6 font-medium text-gray-900 dark:text-white">Shipping Address</h3></div>
                <div class="p-6 text-sm text-gray-600 dark:text-gray-300">
                    <p>
                        <strong>{{ $order->shipping_address['name'] ?? 'N/A' }}</strong><br>
                        {{ $order->shipping_address['address_line_1'] ?? 'N/A' }}<br>
                        @if($order->shipping_address['address_line_2'] ?? null) {{ $order->shipping_address['address_line_2'] }}<br> @endif
                        {{ $order->shipping_address['city'] ?? '' }}{{ ($order->shipping_address['city'] && $order->shipping_address['state_province']) ? ', ' : '' }}{{ $order->shipping_address['state_province'] ?? '' }} {{ $order->shipping_address['postal_code'] ?? '' }}<br>
                        {{ $order->shipping_address['country_code'] ?? '' }}<br>
                        Phone: {{ $order->shipping_address['phone_number'] ?? 'N/A' }}<br>
                        Email: {{ $order->shipping_address['email'] ?? ($order->user->email ?? 'N/A') }}
                    </p>
                </div>
            </div>
        </div>
    </div>
</div>
@stop
