@csrf
<div class="grid grid-cols-1 md:grid-cols-3 gap-6 p-6">
    {{-- Main Column for Job Details & SEO --}}
    <div class="md:col-span-2 space-y-6">
        <div class="bg-white dark:bg-gray-800 shadow-md rounded-lg">
            <div class="px-6 py-4 border-b border-gray-200 dark:border-gray-700">
                <h3 class="text-lg leading-6 font-medium text-gray-900 dark:text-white">Job Details</h3>
            </div>
            <div class="p-6 space-y-6">
                <div>
                    <label for="title" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Job Title <span class="text-red-500">*</span></label>
                    <input type="text" name="title" id="title" class="mt-1 form-input block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('title') border-red-500 @enderror" value="{{ old('title', $job->title ?? '') }}" required>
                    @error('title') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                </div>

                <div>
                    <label for="description" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Description <span class="text-red-500">*</span></label>
                    {{-- For a WYSIWYG editor, you might need a specific class or JS initialization --}}
                    <textarea name="description" id="description" class="mt-1 form-textarea block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('description') border-red-500 @enderror" rows="10">{{ old('description', $job->description ?? '') }}</textarea>
                    @error('description') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                </div>

                <div>
                    <label for="skills_required" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Skills Required (comma-separated)</label>
                    {{-- Consider using a JS tag input library for better UX --}}
                    <input type="text" name="skills_required" id="skills_required" class="mt-1 form-input block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('skills_required') border-red-500 @enderror" value="{{ old('skills_required', isset($job->skills_required) && is_array($job->skills_required) ? implode(', ', $job->skills_required) : ($job->skills_required ?? '')) }}">
                    @error('skills_required') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                    @error('skills_required.*') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                </div>

                <hr class="dark:border-gray-700">
                <h3 class="text-lg font-medium text-gray-900 dark:text-white">SEO Information (Optional)</h3>
                 <div>
                    <label for="meta_title" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Meta Title</label>
                    <input type="text" name="meta_title" id="meta_title" class="mt-1 form-input block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('meta_title') border-red-500 @enderror" value="{{ old('meta_title', $job->meta_title ?? '') }}">
                    @error('meta_title') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                </div>
                 <div>
                    <label for="meta_description" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Meta Description</label>
                    <textarea name="meta_description" id="meta_description" class="mt-1 form-textarea block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('meta_description') border-red-500 @enderror" rows="2">{{ old('meta_description', $job->meta_description ?? '') }}</textarea>
                    @error('meta_description') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                </div>
                 <div>
                    <label for="meta_keywords" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Meta Keywords (comma-separated)</label>
                    <input type="text" name="meta_keywords" id="meta_keywords" class="mt-1 form-input block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('meta_keywords') border-red-500 @enderror" value="{{ old('meta_keywords', $job->meta_keywords ?? '') }}">
                    @error('meta_keywords') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                </div>
            </div>
        </div>
    </div>

    {{-- Sidebar Column for Settings & Details --}}
    <div class="md:col-span-1 space-y-6">
        <div class="bg-white dark:bg-gray-800 shadow-md rounded-lg">
            <div class="px-6 py-4 border-b border-gray-200 dark:border-gray-700">
                <h3 class="text-lg leading-6 font-medium text-gray-900 dark:text-white">Settings & Details</h3>
            </div>
            <div class="p-6 space-y-6">
                <div>
                    <label for="company_id" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Company <span class="text-red-500">*</span></label>
                    <select name="company_id" id="company_id" class="mt-1 form-select block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('company_id') border-red-500 @enderror" required>
                        <option value="">Select Company</option>
                        @foreach($companies as $id => $name)
                            <option value="{{ $id }}" {{ (old('company_id', $job->company_id ?? '') == $id) ? 'selected' : '' }}>{{ $name }}</option>
                        @endforeach
                    </select>
                    @error('company_id') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                </div>

                <div>
                    <label for="category_id" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Category</label>
                    <select name="category_id" id="category_id" class="mt-1 form-select block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('category_id') border-red-500 @enderror">
                        <option value="">Select Category</option>
                        @foreach($categories as $id => $name)
                            <option value="{{ $id }}" {{ (old('category_id', $job->category_id ?? '') == $id) ? 'selected' : '' }}>{{ $name }}</option>
                        @endforeach
                    </select>
                    @error('category_id') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                </div>

                <div>
                    <label for="job_type" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Job Type <span class="text-red-500">*</span></label>
                    <select name="job_type" id="job_type" class="mt-1 form-select block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('job_type') border-red-500 @enderror" required>
                        @foreach($job_types as $key => $value)
                            <option value="{{ $key }}" {{ (old('job_type', $job->job_type ?? '') == $key) ? 'selected' : '' }}>{{ $value }}</option>
                        @endforeach
                    </select>
                    @error('job_type') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                </div>

                <div>
                    <label for="location" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Location</label>
                    <input type="text" name="location" id="location" class="mt-1 form-input block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('location') border-red-500 @enderror" value="{{ old('location', $job->location ?? '') }}">
                    @error('location') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                </div>
                 <div class="flex items-center">
                    <input type="checkbox" name="is_remote" id="is_remote" class="form-checkbox h-4 w-4 text-indigo-600 border-gray-300 dark:border-gray-600 rounded focus:ring-indigo-500" value="1" {{ old('is_remote', $job->is_remote ?? false) ? 'checked' : '' }}>
                    <label for="is_remote" class="ml-2 block text-sm text-gray-900 dark:text-gray-300">Is Remote?</label>
                </div>

                <div class="grid grid-cols-2 gap-x-4">
                    <div>
                        <label for="salary_min" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Min Salary</label>
                        <input type="number" name="salary_min" id="salary_min" step="any" class="mt-1 form-input block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('salary_min') border-red-500 @enderror" value="{{ old('salary_min', $job->salary_min ?? '') }}">
                        @error('salary_min') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                    </div>
                    <div>
                        <label for="salary_max" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Max Salary</label>
                        <input type="number" name="salary_max" id="salary_max" step="any" class="mt-1 form-input block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('salary_max') border-red-500 @enderror" value="{{ old('salary_max', $job->salary_max ?? '') }}">
                        @error('salary_max') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                    </div>
                </div>
                 <div>
                    <label for="currency" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Salary Currency</label>
                    <input type="text" name="currency" id="currency" class="mt-1 form-input block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('currency') border-red-500 @enderror" value="{{ old('currency', $job->currency ?? setting('site_currency_code', 'USD')) }}">
                    @error('currency') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                </div>

                <div>
                    <label for="experience_level" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Experience Level</label>
                    <input type="text" name="experience_level" id="experience_level" class="mt-1 form-input block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('experience_level') border-red-500 @enderror" value="{{ old('experience_level', $job->experience_level ?? '') }}">
                    @error('experience_level') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                </div>
                <div>
                    <label for="education_level" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Education Level</label>
                    <input type="text" name="education_level" id="education_level" class="mt-1 form-input block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('education_level') border-red-500 @enderror" value="{{ old('education_level', $job->education_level ?? '') }}">
                    @error('education_level') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                </div>

                <div>
                    <label for="application_deadline" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Application Deadline</label>
                    <input type="date" name="application_deadline" id="application_deadline" class="mt-1 form-input block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('application_deadline') border-red-500 @enderror" value="{{ old('application_deadline', isset($job->application_deadline) ? $job->application_deadline->format('Y-m-d') : '') }}">
                    @error('application_deadline') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                </div>

                <div>
                    <label for="status" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Status <span class="text-red-500">*</span></label>
                    <select name="status" id="status" class="mt-1 form-select block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('status') border-red-500 @enderror" required>
                        @foreach($job_statuses as $key => $value)
                            <option value="{{ $key }}" {{ (old('status', $job->status ?? 'draft') == $key) ? 'selected' : '' }}>{{ $value }}</option>
                        @endforeach
                    </select>
                    @error('status') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                </div>
            </div>
        </div>

        <div class="flex justify-end space-x-3">
            <a href="{{ route('admin.businessdirectory.jobs.index') }}" class="inline-flex justify-center py-2 px-4 border border-gray-300 dark:border-gray-500 rounded-md shadow-sm text-sm font-medium text-gray-700 dark:text-gray-200 bg-white dark:bg-gray-600 hover:bg-gray-50 dark:hover:bg-gray-500 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                Cancel
            </a>
            <button type="submit" class="inline-flex justify-center py-2 px-4 border border-transparent rounded-md shadow-sm text-sm font-medium text-white bg-indigo-600 hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                {{ isset($job) && $job->id ? 'Update Job' : 'Create Job' }}
            </button>
        </div>
    </div>
</div>

@push('scripts')
<script>
    // If you use a WYSIWYG editor for 'description', initialize it here.
    // Example for CKEditor (ensure CKEditor script is loaded in your admin layout):
    // if (typeof ClassicEditor !== 'undefined') {
    //     ClassicEditor
    //         .create( document.querySelector( '#description' ) )
    //         .catch( error => {
    //             console.error( error );
    //         } );
    // }

    // If you use Select2 for company/category dropdowns, initialize it here.
    // $(document).ready(function() {
    //     $('#company_id, #category_id, #job_type, #status').select2({
    //         theme: 'bootstrap4' // Or your preferred theme
    //     });
    // });

    // If you use a tag input library for 'skills_required', initialize it here.
</script>
@endpush
